// $Id: relocate.cpp,v 1.5 2002/05/06 20:48:12 david Exp $

/*
	Copyright (c) 2002 David Eriksson

	Permission is hereby granted, free of charge, to any person obtaining a
	copy of this software and associated documentation files (the
	"Software"), to deal in the Software without restriction, including
	without limitation the rights to use, copy, modify, merge, publish,
	distribute, sublicense, and/or sell copies of the Software, and to permit
	persons to whom the Software is furnished to do so, subject to the
	following conditions:

	The above copyright notice and this permission notice shall be included
	in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <cstring>
#include <cstdlib>
#include <string>
#include <iostream>
using namespace std;

/* 
	 input looks like this:

	 00000043 R_386_32          __environ
	 00000086 R_386_PC32        malloc
	 0000009f R_386_32          __environ
	 000000a5 R_386_PC32        memcpy
	 000000b8 R_386_PC32        malloc
	 000000cd R_386_PC32        free
	 000000d2 R_386_PC32        __errno_location
	 000000f5 R_386_PC32        memcpy
	 00000117 R_386_PC32        memcpy
	 0000012b R_386_32          .data
	 00000134 R_386_32          .data
	 00000139 R_386_PC32        free
	 0000013f R_386_32          .data
	 00000145 R_386_32          __environ
	 0000017c R_386_PC32        malloc
	 00000198 R_386_PC32        memcpy
	 000001b5 R_386_PC32        memcpy
	 000001e4 R_386_32          __environ

*/

static const int MAX_SIZE = 64+255;

int main(int argc, char**argv)
{
	if (argc != 2)
	{
		cerr << "No data" << endl;
		return 1;
	}

	char* buffer = argv[1];

	if (strlen(buffer) < 64)
	{
		buffer = new char[65];
		strcpy(buffer, argv[1]);
		buffer[64] = '\0';
		for (int i = strlen(buffer); i < 64; i++)
			buffer[i] = '.';
	}
	
	char line[256];
  while(cin.getline(line, sizeof(line)))
	{
		unsigned offset = strtol(line, NULL, 16);

		if (0 == strncmp(line+9, "R_386_32 ", 9) ||
				0 == strncmp(line+9, "R_386_PC32 ", 11))
		{
			// ok
		}
		else
		{
			cerr << "Unknown relocation type on this line: " << endl;
			cerr << line << endl;
			continue;
		}

		if (offset*2 >= strlen(buffer))
		{
			cerr << "Too little data at this line:" << endl;
			cerr << line << endl;
			return 2;
		}

		memcpy(buffer + offset * 2, "........", 8);
	}

	cout << buffer;

	return 0;
};
