//-----------------------------------------------------------------------------
//  Debug Active process plugin for IDA 4.5+
//
//
//

#include <windows.h>

#include <d_psapi.h>
#include <string.h>

#include "idalib.h"

#include "idadap_hooks.h"

const char strDebuggerModuleName[] = "win32_user.plw";
char  comment[] = "IDA's DebugActive process v0.2 (" __DATE__ " " __TIME__ ")";


char help[] =
        "Debug active process for IDA\n"
        "\n"
        "Comments, Requests to <lallousx86@yahoo.com>\n";


HMODULE g_IDAdebug_hMod = NULL;
DWORD   g_IDA_pid = NULL;

//--------------------------------------------------------------------------
//
//      Initialize.
//
//      IDA will call this function only once.
//      If this function returns PLGUIN_SKIP, IDA will never load it again.
//      If this function returns PLUGIN_OK, IDA will unload the plugin but
//      remember that the plugin agreed to work with the database.
//      The plugin will be loaded again if the user invokes it by
//      pressing the hotkey or selecting it from the menu.
//      After the second load the plugin will stay on memory.
//      If this function returns PLUGIN_KEEP, IDA will keep the plugin
//      in the memory. In this case the initialization function can hook
//      into the processor module and user interface notification points.
//      See the hook_to_notification_point() function.
//
//      In this example we check the input file format and make the decision.
//      You may or may not check any other conditions to decide what you do:
//      whether you agree to work with the database or not.
//
int init(void)
{
  if ( inf.filetype != f_PE )
    return PLUGIN_SKIP;
  
  // Get process ID
  g_IDA_pid       = GetCurrentProcessId();

  if (!Load_PsApi())
  {
    msg("Failed to load PsApi!\n");
    return PLUGIN_SKIP;
  }

  msg("%s\n", comment);  

  return PLUGIN_KEEP;
}


//--------------------------------------------------------------------------
//      Terminate.
//      Usually this callback is empty.
//      The plugin should unhook from the notification lists if
//      hook_to_notification_point() was used.
//
//      IDA will call this function when the user asks to exit.
//      This function won't be called in the case of emergency exits.
void term(void)
{
  Unload_PsApi();
}

//--------------------------------------------------------------------------
//
//      The plugin method
//
//      This is the main function of plugin.
//
//      It will be called when the user selects the plugin.
//
//              arg - the input argument, it can be specified in
//                    plugins.cfg file. The default is zero.
//
//
void run(int arg)
{

  BOOL rc;
  // Fill get module handle
  g_IDAdebug_hMod = GetModuleHandle(strDebuggerModuleName);
  switch(arg)
  {
    case 1:
      rc = hooksStartHook(g_IDA_pid, g_IDAdebug_hMod);
      msg(rc ? "DAP enabled\n" : "DAP could not be enabled\n");
      break;
    case 2:
      rc = hooksEndHook(g_IDA_pid, g_IDAdebug_hMod);
      msg( rc ? "DAP disabled\n" : "DAP could not be disabled\n");
      break;
  }
}


//--------------------------------------------------------------------------
//
//      PLUGIN DESCRIPTION BLOCK
//
//--------------------------------------------------------------------------

extern "C" plugin_t PLUGIN = {
  IDP_INTERFACE_VERSION,
  0,                    // plugin flags
  init,                 // initialize

  term,                 // terminate. this pointer may be NULL.

  run,                  // invoke plugin

  comment,              // long comment about the plugin
                        // it could appear in the status line
                        // or as a hint

  help,                 // multiline help about the plugin

  "debug active process",  // the preferred short name of the plugin
  "Alt-0"              // the preferred hotkey to run the plugin
};
