#include "idadap_hooks.h"


DWORD                 g_DAP = 0;
DEBUG_EVENT           g_DE;
TCHAR                 g_Pattern[MAX_PATH];
TCHAR                 g_DllName[MAX_PATH];
TCHAR                 g_ProcName[MAX_PATH];

BOOL                  g_bIsDll = FALSE;
PROCESS_INFORMATION   g_pi;

std::map<DWORD, std::string> g_dllmap; 


/////////////////////////////////////////////////////////////////////////////////////////
//
// Entries to be hooked
// This strucure is defined in hooklib.h and is used by
//
tHookedApiArray DebugApiHookTable[] =
{
  DefineHookEntry(CreateProcess, hookedCreateProcess),
  DefineHookEntry(ContinueDebugEvent, hookedContinueDebugEvent),
  DefineHookEntry(WaitForDebugEvent, hookedWaitForDebugEvent)
};


void DllMapCB(DWORD mod, LPCTSTR name)
{
  g_dllmap[mod] = name;
}

void CreateDllMap()
{
  g_dllmap.clear();
  EnumProcessModulesCB(g_pi.dwProcessId, DllMapCB);
}

//--------------------------------------------------------------------------
//  ContinueDebugEvent() .......
//
BOOL __stdcall hookedContinueDebugEvent(
  DWORD dwProcessId,       // process to continue
  DWORD dwThreadId,        // thread to continue
  DWORD dwContinueStatus   // continuation status
)
{
  if (g_DAP)
    return TRUE;
  return ContinueDebugEvent(dwProcessId, dwThreadId, dwContinueStatus);
}


//--------------------------------------------------------------------------
//
// WaitForDebugEvent() will call the system waitfordebugevent only when g_DAP is 0.
// Otherwise it will return a cached DebugEvent value (basically of type CREATE_PROCESS_INFO)
//
BOOL __stdcall hookedWaitForDebugEvent(
  LPDEBUG_EVENT lpDebugEvent,  // debug event information
  DWORD dwMilliseconds         // time-out value
)
{
  // fake return wanted?
  if (g_DAP)
  {
    // basically...first waitfordebugevent would return CREATE_PROCESS...
    // that's why I'm not checking for debug event code...
    *lpDebugEvent = g_DE;
    g_DAP = 0; // no more fake return values
    return TRUE;
  }

  BOOL rc = WaitForDebugEvent(lpDebugEvent, dwMilliseconds);

  if (g_bIsDll && rc) switch (lpDebugEvent->dwDebugEventCode)
  {
    case LOAD_DLL_DEBUG_EVENT:
    {
      TCHAR ModuleName[MAX_PATH];
      DWORD modulebase = (DWORD) lpDebugEvent->u.LoadDll.lpBaseOfDll;

      // Try to get DLL's name from module handle
      if (!GetDebugeeModuleName(g_pi.hProcess, 
                                lpDebugEvent->u.LoadDll.lpImageName,
                                lpDebugEvent->u.LoadDll.fUnicode, ModuleName,
                                sizeof(ModuleName)))
      {
        // try another method
        if (g_dllmap.find(modulebase) == g_dllmap.end())
          break;
        _tcscpy(ModuleName, g_dllmap[modulebase].c_str());
      }
      msg(_T("my_dll_loaded:%s\n"), ModuleName);
      break;
    }
  }
  return rc;
}


//--------------------------------------------------------------------------
//
// This call makes DAP possible! I check for Currentdirectory param
// if it was [mem] then I will fetch the process from memory then attach it to the debugger
// I will fake return some values that could have been returned by true CreateProcess()
// I will get these values from a pre-call to WaitForDebugEvent
// Because I consumed a future call to WaitForDebugEvent, I'ld signal a flag to tell WFDE() 
// to return a cached value
//
//
BOOL __stdcall hookedCreateProcess(
  LPCTSTR lpApplicationName,                 // name of executable module
  LPTSTR lpCommandLine,                      // command line string
  LPSECURITY_ATTRIBUTES lpProcessAttributes, // SD
  LPSECURITY_ATTRIBUTES lpThreadAttributes,  // SD
  BOOL bInheritHandles,                      // handle inheritance option
  DWORD dwCreationFlags,                     // creation flags
  LPVOID lpEnvironment,                      // new environment block
  LPCTSTR lpCurrentDirectory,                // current directory name
  LPSTARTUPINFO lpStartupInfo,               // startup information
  LPPROCESS_INFORMATION lpProcessInformation // process information
)
{
  BOOL rc;
  DWORD pid, hModule;
  LPTSTR lpOurparam;
  LPTSTR match;
  bool (*matchFunc)(LPCTSTR, LPCTSTR);
  HANDLE hProcess;

  // user wants us to fetch this process from memory ?
  // Syntax (respect order)
  // [mem] [dll:pattern] [proc:pattern]
  // if [mem] is specified then the process will be picked from memory
  // [dll] pattern of the dll to be picked
  // [proc] pattern of the process to be picked
  //
  // Example: [mem] [dll:*\temp*\lib444.*] [proc:?:\win*\tem*\setup.exe]
  //

  lpOurparam = (LPTSTR)lpCurrentDirectory; // lpCommandLine;

  if (lpOurparam && _tcsstr(lpOurparam, _T("[mem]")))
  {
    // DLL specified ?
    if (match = _tcsstr(lpOurparam, _T("[dll:")))
    {
      _stscanf(match, _T("[dll:%[^]]"), g_DllName);
      g_bIsDll = TRUE;
    }
    else
      g_bIsDll = FALSE;

    // pattern match?
    if (match = _tcsstr(lpOurparam, _T("[proc:")))
    {
      _stscanf(match, _T("[proc:%[^]]"), g_ProcName);
      match     = (LPTSTR) &g_ProcName;
      matchFunc = MatchPattern;
    }
    else
    {
      match     = (LPTSTR) lpApplicationName;
      matchFunc = NULL; // use default comparator
    }

    // Find the process ID in memory
    if (!FindModule(match, 
               match, 
               &pid, 
               &hModule,
               FALSE,
               matchFunc))
      return FALSE;

    hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pid);
    if (!hProcess)
      return FALSE;

    // Debug the active process
    if (!DebugActiveProcess(pid))
    {
      CloseHandle(hProcess);
      return FALSE;
    }

    // signal that we need to return couple of fake values
    g_DAP = 1;

    // expect to get CREATE_PROCESS_DEBUG_INFO
    WaitForDebugEvent(&g_DE, INFINITE);

    // although g_DE.u.CreateProcessInfo gives us an hProcess, I still need another handle
    // I can either duplicate it, or OpenProcess()
    // that is because IdaDbg closes both ProcessInfo.hProcess and DebugEvent.u.ProcessCreateInfo.hProcess (which makes them two handles)
    lpProcessInformation->hThread     = INVALID_HANDLE_VALUE;
    lpProcessInformation->hProcess    = hProcess;
    lpProcessInformation->dwProcessId = pid;
    lpProcessInformation->dwThreadId  = g_DE.dwThreadId;

    g_pi = *lpProcessInformation;

    if (g_bIsDll)
      CreateDllMap();

    // success
    return TRUE;
  }

  // Normal process creation
  rc =  CreateProcess(
                 lpApplicationName, 
                 lpCommandLine, 
                 lpProcessAttributes, 
                 lpThreadAttributes,
                 bInheritHandles,
                 dwCreationFlags,
                 lpEnvironment,
                 lpCurrentDirectory,
                 lpStartupInfo,
                 lpProcessInformation
                );
  g_pi = *lpProcessInformation;
  g_DAP = 0;
  return rc;
}



//--------------------------------------------------------------------------
//
// Hooks import entries inside win32_user.plw
//
BOOL hooksStartHook(DWORD processId, HMODULE hModule)
{
  eHookApiErrors rc =
         HookApiVA(processId, 
                  (DWORD)hModule, 
                  DebugApiHookTable, 
                  sizeof(DebugApiHookTable)/sizeof(tHookedApiArray),
                  false);
  return (rc == hava_success);
}

//--------------------------------------------------------------------------
//
// Unhooks import entries inside win32_user.plw
//
BOOL hooksEndHook(DWORD processId, HMODULE hModule)
{
  eHookApiErrors rc =
         HookApiVA(processId, 
                  (DWORD)hModule, 
                  DebugApiHookTable, 
                  sizeof(DebugApiHookTable)/sizeof(tHookedApiArray), true
                  );
  return (rc == hava_success);
}
