#include "idadap_utils.h"

//
// Originally written by Sean Stanley
// Modified by lallous
//
bool MatchPattern(LPCTSTR elem, LPCTSTR pat)
{
  bool rc;
  // pattern = match all
  if (_tcsicmp(pat, "*") == 0)
    rc = true;
  // string empty but pattern is not empty
  else if ( (!*elem && *pat))
    rc = false;
  else if (!*elem)
    rc = true;
  // string empty ?
  else
  {
    switch (*pat)
    {
      case _TUCHAR('*'):
        if (MatchPattern(elem, pat+1))
          rc = true;
        else
          rc = MatchPattern(elem+1, pat);
        break;
      case _TUCHAR('?'):
        rc = MatchPattern(elem+1, pat+1);
        break;
      default:
        if (*elem == *pat)
          rc = MatchPattern(elem+1, pat+1);
        else
          rc = false;
    }
  }
  return rc;
}

////////////////////////////////////////////////////////////////////////////////////////////
// ;)
void UnicodeToAnsi(LPWSTR WideStr, LPSTR AnsiStr)
{
  CHAR buf[MAX_PATH];
  LPSTR p = (LPSTR) &buf;
  
  if ((LPVOID)WideStr != (LPVOID)AnsiStr)
    p = AnsiStr;

  int n = WideCharToMultiByte(0, 0, WideStr, -1, p, MAX_PATH, 0, 0);
  
  if (p != AnsiStr)
    memcpy(AnsiStr, p, n);
}


////////////////////////////////////////////////////////////////////////////////////////////
// ;)
BOOL GetDebugeeModuleName(
  const HANDLE hProcess, 
  const LPVOID lpImageName, 
  BOOL Unicode,
  LPVOID Buffer,
  int nSize)
{
  DWORD nbRW;
  LPVOID lpRemoteImageName;

  // no image name ?
  if (lpImageName == NULL)
    return FALSE;

  // see where image name points to
  if (!ReadProcessMemory(hProcess, 
                         (LPCVOID)lpImageName, 
                         &lpRemoteImageName, 
                         4, 
                         &nbRW))
    return FALSE;

  // No image name pointer ?
  if (lpRemoteImageName == NULL)
    return FALSE;

  // now read image name
  if (!ReadProcessMemory(hProcess, lpRemoteImageName, Buffer, nSize, &nbRW))
    return FALSE;
  
  if (Unicode)
    UnicodeToAnsi((LPWSTR)Buffer, (LPSTR)Buffer);

  return TRUE;
}