/*
  d_psapi.cpp is copyright lallousx86 <lallousx86@yahoo.com>
  You may freely use/modify/distribute this library as long as you keep/give appropriate credits.


  Use d_psapi library if you do not have the MS the Platform SDK
  because psapi.h and psapi.lib are already there.
*/

#include "d_psapi.h"


HMODULE h_psApi = NULL;

t_EnumProcesses          EnumProcesses;
t_EnumProcessModules     EnumProcessModules;
t_GetModuleBaseName      GetModuleBaseName;
t_GetModuleFileNameEx    GetModuleFileNameEx;

#define DynamicGetProcAddress(modname, Modifier) \
    p = GetProcAddress(h_psApi, #modname Modifier); \
    if (!p) return FALSE; \
    modname = (t_##modname)p;


//----------------------------------------------------------------------------------
//
//
//
BOOL Load_PsApi()
{
  if (h_psApi)
    return TRUE;

  PVOID p;

  h_psApi = LoadLibrary("psapi.dll");
  if (!h_psApi)
    return FALSE; 

  DynamicGetProcAddress(EnumProcesses, "");
  DynamicGetProcAddress(EnumProcessModules, "");
  DynamicGetProcAddress(GetModuleBaseName, "A");
  DynamicGetProcAddress(GetModuleFileNameEx, "A");

  return TRUE;
}
#undef DynamicgetProcAddress


//-------------------------------------------------------------------------------------
//
//
//
void Unload_PsApi()
{
  if (h_psApi)
    FreeLibrary(h_psApi);
}