#ifndef __D_PSAPI_INC
#define __D_PSAPI_INC

#include <windows.h>

typedef struct _PROCESS_MEMORY_COUNTERS {
    DWORD cb;
    DWORD PageFaultCount;
    SIZE_T PeakWorkingSetSize;
    SIZE_T WorkingSetSize;
    SIZE_T QuotaPeakPagedPoolUsage;
    SIZE_T QuotaPagedPoolUsage;
    SIZE_T QuotaPeakNonPagedPoolUsage;
    SIZE_T QuotaNonPagedPoolUsage;
    SIZE_T PagefileUsage;
    SIZE_T PeakPagefileUsage;
} PROCESS_MEMORY_COUNTERS;

typedef PROCESS_MEMORY_COUNTERS *PPROCESS_MEMORY_COUNTERS;

typedef BOOL (__stdcall *t_EnumProcesses)(
  DWORD *lpidProcess,  // array of process identifiers
  DWORD cb,            // size of array
  DWORD *cbNeeded      // number of bytes returned
);

typedef BOOL (__stdcall *t_EnumProcessModules)(
  HANDLE hProcess,      // handle to process
  HMODULE *lphModule,   // array of module handles
  DWORD cb,             // size of array
  LPDWORD lpcbNeeded    // number of bytes required
);


typedef DWORD (__stdcall *t_GetModuleFileNameEx)(
  HANDLE hProcess,    // handle to process
  HMODULE hModule,    // handle to module
  LPTSTR lpFilename,  // path buffer
  DWORD nSize         // maximum characters to retrieve
);

typedef DWORD (__stdcall *t_GetModuleBaseName)(
  HANDLE hProcess,    // handle to process
  HMODULE hModule,    // handle to module
  LPTSTR lpBaseName,  // base name buffer
  DWORD nSize         // maximum characters to retrieve
);

typedef BOOL (__stdcall *t_GetProcessMemoryInfo)(
  HANDLE Process,                          // handle to process
  PPROCESS_MEMORY_COUNTERS ppsmemCounters, // buffer
  DWORD cb                                 // size of buffer
);


BOOL   Load_PsApi();
void   Unload_PsApi();

extern t_EnumProcesses          EnumProcesses;
extern t_EnumProcessModules     EnumProcessModules;
extern t_GetModuleBaseName      GetModuleBaseName;
extern t_GetModuleFileNameEx    GetModuleFileNameEx;
#endif