#ifndef __HOOKLIB__INC
#define __HOOKLIB__INC


#include <windows.h>
#include <tchar.h>

#include "d_psapi.h"

//
// Define a debug version of the hook table struct
// The debug version includes the function name as a string
// while the release version only shows the function pointers
//
#ifdef _MYDEBUG
#define DefineHookEntry(original, hook) { #original, (DWORD)&original, (DWORD)&hook, NULL }
#else
#define DefineHookEntry(original, hook) { (DWORD)&original, (DWORD)&hook, NULL }
#endif

typedef struct
{
  #ifdef _MYDEBUG
  LPSTR  FunctionName;
  #endif
  DWORD  OriginalEP;
  DWORD  PatchedEP;
  DWORD  VA;
} tHookedApiArray;


/////////////////////////////////////////////////////////////////////////////////////////
typedef enum
{
  hava_success = 0,   // no error
  hava_noimport,      // could not find import data section
  hava_openprocess,   // could not open process
  hava_readprocess,   // could not read process memory
  hava_notall,        // not all entries patched
  hava_changeprotection, // could not change page protection
  hava_writeprocess, // could not write process memory
  hava_nomemforimports // no memory to hold import data values
} eHookApiErrors;

/////////////////////////////////////////////////////////////////////////////////////////
BOOL FindModule(
  LPCTSTR procName,
  LPCTSTR modName,
  PDWORD _uProcessId,
  PDWORD _hModule,
  BOOL BaseNames = TRUE,
  bool (*match) (LPCTSTR, LPCTSTR) = NULL);

/////////////////////////////////////////////////////////////////////////////////////////
BOOL FindModuleByProcessId(
  DWORD _ProcessID,
  LPCTSTR modName,
  PDWORD _hModule);

/////////////////////////////////////////////////////////////////////////////////////////
eHookApiErrors HookApiVA(
   const DWORD ProcessID, 
   const DWORD hModule, 
   tHookedApiArray *haa, 
   const DWORD nEntries, 
   const BOOL unhook = FALSE);

/////////////////////////////////////////////////////////////////////////////////////////
BOOL EnumProcessModulesCB(DWORD 
  ProcessID,
  void (*cbEnum)(DWORD, LPCTSTR)
  );

#endif