// IDB2PAT.H

// defining __NOT_ONLY_PRO_FUNCS__ keeps the STL stuff from freaking about min/max
// #define __NOT_ONLY_PRO_FUNCS__       //Not necessary on VC++ v6
#include <ida.hpp>
#include <idp.hpp>
#include <loader.hpp>
#include <kernwin.hpp>
#include <bytes.hpp>
#include <name.hpp>
#include <entry.hpp>
#include <funcs.hpp>
#include <expr.hpp>
#include <fpro.h>
#include <diskio.hpp>
#include <string.h>

// vector must be included first because of Rogue Wave STL
#include <vector>
#include <map>

// Minumum number of bytes a function needs in order to be patterned
#define MIN_SIG_LENGTH 10

// These things need to be shorts rather than #def or enum since
// AskUsingForm_c() requires shorts.

const short CHKBX_DO_NADA = 0x0000;     // Null for no boxes checked
const short CHKBX_DO_LIBS = 0x0001;     // Include library functions
const short CHKBX_DO_SUBS = 0x0002;     // Include Auto-Generated Names "sub_*"
const short CHKBX_NO_LIBS = 0x0004;     // Exclude library functions
const short CHKBX_DO_TEMP = 0x0008;     // Not used

const short RADIO_NON_FUNC = 0x0000;    // non auto-generated
const short RADIO_LIB_FUNC = 0x0001;    // library functions
const short RADIO_PUB_FUNC = 0x0002;    // exported functions
const short RADIO_ALL_FUNC = 0x0003;    // all functions
const short RADIO_USR_FUNC = 0x0004;    // user selected function

const short RADIO_IS_ERROR = -1;

// Structure for passing user options
typedef struct tagPATOPTION {
    short radio;
    short chkbx;
} PATOPTION;



#ifndef NOPROTO
// Source File: "crc16.cpp"
// prototype for CCITT CRC16 function
unsigned short crc16(unsigned char *,unsigned short);

// Source File: "idb2pat.cpp"
// prototype for the find_ref_loc() function.
ea_t find_ref_loc(ea_t, ea_t);

// prototype for the set varible bytes function.
void set_v_bytes (std::vector<bool>&, int, int);

// prototype for the make_pattern() function.
void make_pattern(func_t*, FILE*, PATOPTION*);

// prototype for the dialog
PATOPTION* opt_diaolg(PATOPTION*);

// prototype for get pattern file dialog.
FILE* get_pat_file(void);

// prototype for the primary run() function.
void run(int);

#endif
