class Debugger				// Debugger class for Idbg
{
private:

#define MAXBPX 100

struct BREAKPOINT_INFO
{
 	DWORD	address;
	char	backup;
	bool	enabled;
	int     type;
	DWORD   reg;
//	condition;
};

	DEBUG_EVENT DebugEv;
	CONTEXT ctxt;
	BYTE int3;
	BREAKPOINT_INFO		bpi[MAXBPX];
	int			hProc;
	STARTUPINFO		startinfo;
	PROCESS_INFORMATION	procinfo;
	HANDLE 			hProcess;
	HANDLE			hThread;
	DWORD			threadid;


	//DWORD WINAPI DbgEngine( LPVOID param );
	
public:
	Debugger();			// Standard constructor
	//Debugger( double wert );	// Constructor and parameter
	~Debugger();			// Destructor
	bool LoadFile( char * Filename );		// Create a suspended process
	bool Suspend();			// Suspend execution
	bool Resume();			// Resume execution
	bool Bpx( DWORD address, int type);		// Set Breakpoint
	bool Bc( DWORD address );
	//void SetDbgFlags();
	void GetContext( CONTEXT * context );
	void SetContext( CONTEXT * context );
	void WaitEvent(DWORD duration);
	bool OnBreakpoint();
	bool OnCreateProcess();
	bool OnTrace();
	bool OnExitProcess();
	bool Cont();
	void Trace();
	void Cleanup();
	void Start(LPTHREAD_START_ROUTINE lpThread, int nPriority);
	bool DumpRegion(int address, DWORD length, char * filename);
	bool Inject(int address, char * filename);
	bool IsBreakpoint(int address);
	void ListBreakpoints();
	int GetBpxType(int address);
	DWORD ReadDword(int address);
};

int Debugger::GetBpxType(int address)
{
int i;

		//msg("BPX() i= %d addr= %08X\n",i,breakpoint[i].address);
		for (i=0;i<MAXBPX;i++)
		{
			if ( bpi[i].address == address ) return bpi[i].type;
		}
return 0xFFFFFFFF;
}
bool Debugger::IsBreakpoint(int address)
{
int i;

		//msg("BPX() i= %d addr= %08X\n",i,breakpoint[i].address);
		for (i=0;i<MAXBPX;i++)
		{
			if ( bpi[i].address == address ) return true;
		}
		//msg("clearing breakpoint at %08X (bpi %08X)\n",address,i);
return false;
}

DWORD Debugger::ReadDword(int address)
{
DWORD old,buf;		
	VirtualProtectEx(procinfo.hProcess,(void *)address,1,PAGE_EXECUTE_READWRITE,&old);
	ReadProcessMemory(procinfo.hProcess,(void *)address,/*(LPVOID)*/&buf,4,NULL);
	//msg("memread: %d, address: %08X, buf: %08X\n",result,address,buf);
	VirtualProtectEx(procinfo.hProcess,(void *)address,1,old,&old);
return buf;
}

bool Debugger::DumpRegion(int address, DWORD length, char * filename)
{
bool result;
DWORD old;
HGLOBAL buf;
HANDLE hFile;
DWORD written = 0;

		buf = GlobalAlloc(GMEM_FIXED, length);
//		msg("Filename is: %s\n",filename);
		//msg("BPX() i= %d addr= %08X\n",i,breakpoint[i].address);
//		msg("Setting breakpoint at %08X (bpi %08X)\n",address,i);
		VirtualProtectEx(procinfo.hProcess,(void *)address,1,PAGE_EXECUTE_READWRITE,&old);
		result = ReadProcessMemory(procinfo.hProcess,(void *)address,(LPVOID)buf,length,NULL);
		//msg("memread %d\n",result);
		VirtualProtectEx(procinfo.hProcess,(void *)address,1,old,&old);
		if (!result) return result;
//		msg("Creating.. %s\n",filename);
		hFile = CreateFile(filename,GENERIC_READ | GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
		if (hFile != INVALID_HANDLE_VALUE)
		{
			if ( WriteFile(hFile,buf,length,&written,NULL) )
				msg("Dumped %08X bytes at %08X to file %s\n",length,address,filename);
			else msg("Failed to dump!\n");
		}
		CloseHandle(hFile);
		GlobalFree(buf);
return TRUE;
}

bool Debugger::Inject(int address, char * filename)
{
bool result;
DWORD old;
DWORD length;
HGLOBAL buf;
HANDLE hFile;
DWORD read = 0;


		hFile = CreateFile(filename,GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, 0);
		if (hFile != INVALID_HANDLE_VALUE)
		{
			length = GetFileSize(hFile,NULL);
		//	//msg("len %08X\n",length);
			buf = GlobalAlloc(GMEM_FIXED, length);

			if ( ReadFile(hFile,buf,length,&read,NULL ) )
			{
		//		//msg("Read %08X bytes from %s\n",length,filename);
				VirtualProtectEx(procinfo.hProcess,(void *)address,1,PAGE_EXECUTE_READWRITE,&old);
				result = WriteProcessMemory(procinfo.hProcess,(void *)address,(LPVOID)buf,length,NULL);
				VirtualProtectEx(procinfo.hProcess,(void *)address,1,old,&old);
				CloseHandle(hFile);
				GlobalFree(buf);
				if (!result)
				{
					msg("failed...\n");
					return result;
				}
			}
			else msg("Failed to read!\n");
		}
		else return false;
msg("Data has been injected (%08X)\n",address);
return TRUE;
}

void Debugger::Cleanup()
{
	//TerminateThread(hThread,666);
	//msg("dbg thread %d\n",CloseHandle(hThread));
	//msg("process thread %d\n",CloseHandle( procinfo.hThread ));
}

void Debugger::Start(LPTHREAD_START_ROUTINE lpThread, int nPriority)
{
	hThread=CreateThread(NULL,NULL,lpThread,NULL,NULL,&threadid);
	SetThreadPriority( hThread,nPriority);
}

void Debugger::GetContext( CONTEXT * context )
{
	GetThreadContext(procinfo.hThread,context);
}

void Debugger::SetContext( CONTEXT * context )
{
	SetThreadContext(procinfo.hThread,context);
}

bool Debugger::Bpx( DWORD address, int type )
{
DWORD old;
int i;
bool result;

		//msg("BPX() i= %d addr= %08X\n",i,breakpoint[i].address);
		//while ( bpi[i].address != 0xFFFFFFFF ) i++;
		for (i=0;i<MAXBPX;i++)
		{
			if ( bpi[i].address == 0xFFFFFFFF ) break;
		}
		bpi[i].type=type;
		//msg("Setting breakpoint at %08X (bpi %08X)\n",address,i);
		VirtualProtectEx(procinfo.hProcess,(void *)address,1,PAGE_EXECUTE_READWRITE,&old);
		ReadProcessMemory(procinfo.hProcess,(void *)address,&bpi[i].backup,1,NULL);
		result = WriteProcessMemory(procinfo.hProcess,(void *)address,&int3,1,NULL);
		if (result) bpi[i].address = address;
		VirtualProtectEx(procinfo.hProcess,(void *)address,1,old,&old);
		return result;
}

bool Debugger::Bc( DWORD address )
{
DWORD old;
int i=0;
bool result;

		//msg("addy %08X\n",address);
		//while ( bpi[i].address != address ) i++;
		//while( (bpi[i].address != address) && (i<MAXBPX) ) i++;
		//bpi[i].address = 0xFFFFFFFF;

		for (i=0;i<MAXBPX;i++)
		{
			if ( bpi[i].address == address )
			{
				bpi[i].address = 0xFFFFFFFF;
				break;
			}
		}

//		msg("clearing breakpoint at %08X (bpi %08X)\n",address,i);
		GetThreadContext(procinfo.hThread,&ctxt);
		ctxt.Eip-=1;
		SetThreadContext(procinfo.hThread,&ctxt);
		VirtualProtectEx(procinfo.hProcess,(void *)address,1,PAGE_EXECUTE_READWRITE,&old);
		result = WriteProcessMemory(procinfo.hProcess,(void *)address,&bpi[i].backup,1,NULL);
		VirtualProtectEx(procinfo.hProcess,(void *)address,1,old,&old);
		return result;
}

void Debugger::ListBreakpoints()
{
int i;

	msg("List of breakpoints:\n");
	for(i=0;i<MAXBPX; i++)
		if ( bpi[i].address != 0xFFFFFFFF)
	{
		msg("%02X: %08X type %d\n",i,bpi[i].address,GetBpxType(bpi[i].address));
	}
}

Debugger::Debugger()
{
int i;
	for(i=0;i<MAXBPX; i++) {bpi[i].address=0xFFFFFFFF;}
	int3 = 0xcc;
	ctxt.ContextFlags = CONTEXT_FULL | CONTEXT_DEBUG_REGISTERS;
}

bool Debugger::LoadFile( char* Filename )
{
	//msg("bool Debugger::LoadFile( char* Filename )\n");
	//msg("Creating suspended process %s\n",Filename);
	GetStartupInfo( &startinfo );
	//| CREATE_SUSPENDED
	hProc = CreateProcess(Filename,0,0,0,0,DEBUG_PROCESS | DEBUG_ONLY_THIS_PROCESS , 0, 0, &startinfo, &procinfo);
	//msg("Return value: %08X\n",hProc);
	hProcess=procinfo.hProcess;
	if (hProc == 0)
	   return FALSE;
	else
	   return TRUE;
}

bool Debugger::Suspend()
{
	msg("bool Debugger::Suspend()\n");
	if ( SuspendThread( hProcess ) == 0xFFFFFFFF )
		return FALSE;
return TRUE;
}

bool Debugger::Resume()
{
	msg("bool Debugger::Resume()\n");
	if ( ResumeThread( hProcess ) == 0xFFFFFFFF )
		return FALSE;
return TRUE;
}

/*
Debugger::Debugger( double wert )
{
	m_dWert = wert;
}
*/

Debugger::~Debugger()
{
	
}

void Debugger::WaitEvent(DWORD duration)
{
	WaitForDebugEvent(&DebugEv, duration);	
}

bool Debugger::Cont()
{
//char * lpMsgBuf;

		return ContinueDebugEvent(DebugEv.dwProcessId, DebugEv.dwThreadId, DBG_CONTINUE);
 /*
FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    NULL,
    GetLastError(),
    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
    (LPTSTR) &lpMsgBuf,
    0,
    NULL 
);
msg(lpMsgBuf);
//MessageBox( NULL, lpMsgBuf, "GetLastError", MB_OK|MB_ICONINFORMATION );
*/		
		
}
/*
void SetRegister(ulong newval, int reg)
{
		Dbg.GetContext(&context);
		switch (reg)
		{
			case EAX:
				context.Eax = newval;
				break;
			case EBX:
				context.Ebx = newval;
				break;
			case ECX:
				context.Ecx = newval;
				break;
			case EDX:
				context.Edx = newval;
				break;
			case ESI:
				context.Esi = newval;
				break;
			case EDI:
				context.Edi = newval;
				break;
			case EBP:
				context.Ebp = newval;
				break;
			case ESP:
				context.Esp = newval;
				break;
			case EIP:
				context.Eip = newval;
				jumpto(context.Eip);
				break;
		}
		Dbg.SetContext(&context);
		UpdateRegs(context);
}
*/
void Debugger::Trace()
{
		GetThreadContext(procinfo.hThread,&ctxt);
		ctxt.EFlags |= 0x100;
		SetThreadContext(procinfo.hThread,&ctxt);
		jumpto(ctxt.Eip);
		//msg("EIP: %08X\n",ctxt.Eip);
}


bool Debugger::OnBreakpoint()
{
	    if ( DebugEv.dwDebugEventCode == EXCEPTION_DEBUG_EVENT ) 
	    	if ( DebugEv.u.Exception.ExceptionRecord.ExceptionCode == EXCEPTION_BREAKPOINT ) 
	    		return true;
	    return false;
}
bool Debugger::OnExitProcess()
{
	    if ( DebugEv.dwDebugEventCode == EXIT_PROCESS_DEBUG_EVENT ) return true;
return false;
}

bool Debugger::OnCreateProcess()
{
	    if ( DebugEv.dwDebugEventCode == CREATE_PROCESS_DEBUG_EVENT ) 
	    		return true;
	    return false;
}

bool Debugger::OnTrace()
{
	    if ( DebugEv.dwDebugEventCode == EXCEPTION_DEBUG_EVENT ) 
	    	if ( DebugEv.u.Exception.ExceptionRecord.ExceptionCode == EXCEPTION_SINGLE_STEP ) 
		{			
	    		return true;
	    	}
	    return false;  
}

