/*//////////////////////////////////////////////////////////////////////
                           Necessary Includes
//////////////////////////////////////////////////////////////////////*/

#include "stdafx.h"

#include "ida.hpp"
#include "idp.hpp"
#include "loader.hpp"
#include "diskio.hpp"

#include "debugger.cpp"

#define EFL_C		0
#define EFL_P		0x4
#define EFL_A		0x10
#define EFL_Z		0x40
#define EFL_S		0x80
#define EFL_T		0x100
#define EFL_I		0x200
#define EFL_D		0x400
#define EFL_O		0x800

#define BPX_OEP		0	//Original EntryPoint
#define BPX_RET		1	//Internal
#define BPX_ONS		2	//OneShot (clear bpx when triggered)
#define BPX_INT3	3	//Regular Int3 bpx

#define EAX		0
#define EBX		1
#define ECX		2
#define EDX		3
#define ESI		4
#define EDI		5
#define EBP		6
#define ESP		7
#define EIP		8
#define AL		9
#define AH		10
#define AX		11
#define BL		12
#define BH		13
#define BX		14
#define CL		15
#define CH		16
#define CX		17
#define DL		18
#define DH		19
#define DX		20
#define SI		21
#define DI		22
#define BP		23
#define SP		24
#define IP		25




DWORD WINAPI DbgEngine( LPVOID param );

Debugger Dbg;
callui_t IdbgCallui;

DWORD retbpx;
char *filename;
char *idbgc;
DWORD OEP;

char idbgversion[]="v0.001";

volatile bool bATrace = false;
volatile bool bDbgEngine = true;
volatile bool bRunning = false;
volatile bool bBreak = false;
volatile int iTriggeredBpx = 0;



/*//////////////////////////////////////////////////////////////////////
                  EXTERNALLY VISIBLE CODE STARTS HERE
//////////////////////////////////////////////////////////////////////*/


//----------------------------------------------------------------------

/*----------------------------------------------------------------------
FUNCTION        :   plugin_main
DISCUSSION      :
    The entry point for this plugin
PARAMETERS      :
    argc - The number of commmand line arguments
    argv - The array of commmand line arguments
RETURNS         :
    0 - Life is good and everything processed fine.
    1 - There was a general problem.
    2 - The module either did not have symbols or did not have symbols
        that supported line information.
----------------------------------------------------------------------*/

bool ApiCall(int address)
{
	if (address>=0x70000000) return true;
return false;
}

void ToggleEflagsBit(DWORD mask)
{
CONTEXT context;
		context.ContextFlags = CONTEXT_FULL | CONTEXT_DEBUG_REGISTERS;
		Dbg.GetContext(&context);		
		context.EFlags ^= mask;
		Dbg.SetContext(&context);
}

void RunProcess()
{
	bRunning=true;
}

void SetRegister(int reg, ulong newval)
{
CONTEXT context;

		context.ContextFlags = CONTEXT_FULL | CONTEXT_DEBUG_REGISTERS;
		Dbg.GetContext(&context);
		switch (reg)
		{
			case EAX:
				context.Eax = newval;
				break;
			case EBX:
				context.Ebx = newval;
				break;
			case ECX:
				context.Ecx = newval;
				break;
			case EDX:
				context.Edx = newval;
				break;
			case ESI:
				context.Esi = newval;
				break;
			case EDI:
				context.Edi = newval;
				break;
			case EBP:
				context.Ebp = newval;
				break;
			case ESP:
				context.Esp = newval;
				break;
			case EIP:
				context.Eip = newval;
				jumpto(context.Eip);
				break;
		}
		Dbg.SetContext(&context);
}


void DumpRegsToScreen()
{
CONTEXT context;
		context.ContextFlags = CONTEXT_FULL | CONTEXT_DEBUG_REGISTERS;
		Dbg.GetContext(&context);		
		msg("EAX=%08X EBX=%08X ECX=%08X EDX=%08X\n"  \
		    "ESI=%08X EDI=%08X EBP=%08X ESP=%08X\n" \
		    "EIP=%08X        " \
		    "C=%d P=%d A=%d Z=%d S=%d I=%d D=%d O=%d\n\n", \
		    context.Eax,context.Ebx,context.Ecx,context.Edx, \
		    context.Esi,context.Edi,context.Ebp,context.Esp, \
		    context.Eip, \
		    (context.EFlags & EFL_C), \
		    (context.EFlags & EFL_P) >> 2, \
		    (context.EFlags & EFL_A) >> 4, \
		    (context.EFlags & EFL_Z) >> 6, \
		    (context.EFlags & EFL_S) >> 7, \
		    (context.EFlags & EFL_I) >> 9, \
		    (context.EFlags & EFL_D) >> 10, \
		    (context.EFlags & EFL_O) >> 11 \
		    );
}


char *substr(char *str,char *token,int len)
{
int i;
char *temp=token;
	for (i = 0;i <= len;i++) token[i] = toupper(str[i]);//*(token+i) = *(str+i);
	*(token+len)='\0';
return temp;
}

int strlen20(char *str)
{
if ( strchr(str,' ') == NULL )
	return (int)( strchr(str,'\0') - str );
return (int)( strchr(str,' ') - str );
}


int argcount(char * str)
{
int count=0;

if (*str==' ') while(*(++str)==' ');

	while(*str!='\0')
	{
		if ( (*str==' ') && (*(str+1)!=' ') && (*(str+1)!='\0') )
			count++;
		str++;
	}
return count;
}

char *argstr(char *str, char *token, int argnum)
{
int curarg=0;
char buf[280];

if (*str==' ') while(*(++str)==' ');
if (argnum==0) return strcpy( token, substr(str,buf,strlen20(str)) );
while(curarg<argnum)
{
	while ( (*str!=' ') && ( (*(str+1)!=' ') || (*(str+1)!='\0')) ) str++;
	if (*str==' ') while(*(++str)==' ');
	curarg++;
}
	
//msg(substr(str,buf,strlen20(str)));
return strcpy( token, substr(str,buf,strlen20(str)) );
}

FILE *OpenIdl(char *idl)
{
	return fopen(idl,"rt");
}

bool GetCmdLine(FILE *fl,char *buf)
{
int i=0;	
char c;
	while((c=getc(fl))!=EOF && c!='\n')
	{
		*(buf+i)=c;
		i++;
	}
	*(buf+i)='\0';
	//msg("%c\n",c);
	if (*(buf)=='x') return false;
return true;
}

void CloseIdl(FILE *fl)
{
	fclose(fl);
}

bool ProcessLine(FILE *fl)
{
char token[280];
int numargs;
char buf[280];

	if (!GetCmdLine(fl,buf)) return false;
	msg("%s\n",buf);
	numargs=argcount(buf);
	//msg("numargs: %d\n",numargs);
	if (numargs==0)
	{
		//if ( strcmp("ATR",argstr(buf,token,0)) ==0)
		//	bATrace^=0xFFFFFFFF;
		if( strcmp("TRACEINTO",argstr(buf,token,0)) ==0)
		{
			Dbg.Trace();
			Dbg.Cont();
		}
	}
	else if (numargs==1)
	{
		//msg("1 arg\n");
		if ( strcmp("BPX",argstr(buf,token,0)) ==0)
			Dbg.Bpx( strtoul(argstr(buf,token,1),NULL,0), BPX_INT3 );
	}
return true;
}

DWORD WINAPI DbgEngine(LPVOID param )
{
//DEBUG_EVENT DebugEv;
//msg("input path: %s\ninput filename: %s\n",get_input_file_path(),get_root_filename());
//filename = askfile_c(TRUE, "*.exe", "Please choose the file to trace:");
filename = get_input_file_path();
if ( ( filename == NULL ) | ( !Dbg.LoadFile(filename) ) )
{
	ExitThread(0);
}

OEP=inf.beginEA;
CONTEXT context;
int bpxtype;
FILE *fl;
bool initdone=false;

context.ContextFlags = CONTEXT_FULL | CONTEXT_DEBUG_REGISTERS;
bDbgEngine=true;

idbgc = askfile_c(TRUE, "*.idl", "Open IDL script:");

fl=OpenIdl(idbgc);
//msg("%s\n",buf);
//CloseIdl(fl);


while (bDbgEngine)
{ 
 
// Wait for a debugging event to occur. The second parameter indicates 
// that the function does not return until a debugging event occurs. 
 
    Dbg.WaitEvent(1000); 

    if ( iTriggeredBpx!=0 ) 
    {
    	Dbg.Bpx(iTriggeredBpx,BPX_INT3);
    	iTriggeredBpx=0;
    }

    if ( Dbg.OnBreakpoint() )
    {
    	Dbg.GetContext(&context);
	context.Eip--;
        //if ( context.Eip == OEP ) 
        if ( Dbg.IsBreakpoint(context.Eip) ) 
        { 
		msg("bp triggered at %08X type %d\n",context.Eip,bpxtype);
		bpxtype=Dbg.GetBpxType(context.Eip);
		if(bpxtype == BPX_OEP) //|| (bpxtype == BPX_RET) )
		{
			Dbg.Bc(context.Eip);
			initdone=true;
		}
		else if(bpxtype == BPX_RET) Dbg.Bc(context.Eip);
		else if (bpxtype == BPX_INT3)
		{
		 	Dbg.Bc(context.Eip);
			bATrace=false;
			bRunning=false;
			iTriggeredBpx=context.Eip;		
		}
		jumpto(context.Eip);

		if (bpxtype>=0) Dbg.SetContext(&context);
	//	if (!bATrace) DumpRegsToScreen();
	//		else {Dbg.Trace(); Dbg.Cont();}
        }
	else    	
	Dbg.Cont();
     }

     else if ( Dbg.OnCreateProcess() )
     {
	if ( Dbg.Bpx(inf.beginEA, BPX_OEP) == false );// msg("bpx failed\n");
		//else msg("bpx %08X\n",inf.beginEA);
        Dbg.Cont(); 
     }

     else if ( Dbg.OnTrace() )
     {
		msg("tracing\n");
	    	Dbg.GetContext(&context);
		if ( ApiCall(context.Eip) )
		{
			retbpx=Dbg.ReadDword(context.Esp);
			Dbg.Bpx(retbpx, BPX_RET);
			Dbg.Cont();
		}
		else
		{
     			jumpto(context.Eip);

			if( (!bATrace) && (!bRunning) ) /*DumpRegsToScreen()*/;
				else {Dbg.Trace(); Dbg.Cont();}

        	}
     }
     else if( Dbg.OnExitProcess() )
     {
     	bDbgEngine=false;
     	msg("Process terminated!\n");
     }
     
     if(initdone)
     {
     	if (ProcessLine(fl)) ;
     	else
     	{
     		initdone=false;
     		bDbgEngine=false;
     	}
     }
     else Dbg.Cont();
     jumpto(context.Eip);

}
msg("Debug-Engine terminated.\n");
ExitThread(0);
delete &Dbg;
return true;
}

void plugin_main(int)
{

//Dbg.Start(DbgEngine,THREAD_PRIORITY_ABOVE_NORMAL);
Dbg.Start(DbgEngine,THREAD_PRIORITY_NORMAL);


/*

char answer[280]="";
char token[280];
char filename[256];
int numargs;




void ProcessLine()
{
while (AskUsingForm_c(askform, myhelp, &answer, &answer))
{ 
	//msg("String parser:\n");
	numargs=argcount(answer);
	//msg("numargs: %d\n",numargs);
	if (numargs==0)
	{
		if ( strcmp("ATR",argstr(answer,token,0)) ==0)
			bATrace^=0xFFFFFFFF;
		else if ( strcmp("HELP",argstr(answer,token,0)) ==0)
			msg(cmdhelp);
		else if ( strcmp("BL",argstr(answer,token,0)) ==0)
			Dbg.ListBreakpoints();
		else if ( strcmp("GO",argstr(answer,token,0)) ==0)
			bRunning=true;
		else if ( strcmp("BRK",argstr(answer,token,0)) ==0)
		{
			bRunning=false;
			bBreak=true;
		}

	}
	else if (numargs==1)
	{
		if ( strcmp("BPX",argstr(answer,token,0)) ==0)
			Dbg.Bpx( strtoul(argstr(answer,token,1),NULL,0), BPX_INT3 );
	}
	else if (numargs==2)
	{
		if ( strcmp("R",argstr(answer,token,0)) ==0)
		{
		      if (strcmp("FL",argstr(answer,token,1)) ==0)
		      {
			if( strcmp("Z",argstr(answer,token,2)) ==0 )
				ToggleEflagsBit(EFL_Z);
			else if( strcmp("A",argstr(answer,token,2)) ==0 )
				ToggleEflagsBit(EFL_A);
			else if( strcmp("I",argstr(answer,token,2)) ==0 )
				ToggleEflagsBit(EFL_I);
			else if( strcmp("O",argstr(answer,token,2)) ==0 )
				ToggleEflagsBit(EFL_O);
			else if( strcmp("C",argstr(answer,token,2)) ==0 )
				ToggleEflagsBit(EFL_C);
			else if( strcmp("P",argstr(answer,token,2)) ==0 )
				ToggleEflagsBit(EFL_P);
			else if( strcmp("S",argstr(answer,token,2)) ==0 )
				ToggleEflagsBit(EFL_S);
			else if( strcmp("D",argstr(answer,token,2)) ==0 )
				ToggleEflagsBit(EFL_D);
		      }
		      else if (strcmp("EAX",argstr(answer,token,1)) ==0)
		      SetRegister(EAX,strtoul(argstr(answer,token,2),NULL,0));
		      else if (strcmp("EBX",argstr(answer,token,1)) ==0)
		      SetRegister(EBX,strtoul(argstr(answer,token,2),NULL,0));
		      else if (strcmp("ECX",argstr(answer,token,1)) ==0)
		      SetRegister(ECX,strtoul(argstr(answer,token,2),NULL,0));
		      else if (strcmp("EDX",argstr(answer,token,1)) ==0)
		      SetRegister(EDX,strtoul(argstr(answer,token,2),NULL,0));
		      else if (strcmp("ESI",argstr(answer,token,1)) ==0)
		      SetRegister(ESI,strtoul(argstr(answer,token,2),NULL,0));
		      else if (strcmp("EDI",argstr(answer,token,1)) ==0)
		      SetRegister(EDI,strtoul(argstr(answer,token,2),NULL,0));
		      else if (strcmp("EBP",argstr(answer,token,1)) ==0)
		      SetRegister(EBP,strtoul(argstr(answer,token,2),NULL,0));
		      else if (strcmp("ESP",argstr(answer,token,1)) ==0)
		      SetRegister(ESP,strtoul(argstr(answer,token,2),NULL,0));
		      else if (strcmp("EIP",argstr(answer,token,1)) ==0)
		      SetRegister(EIP,strtoul(argstr(answer,token,2),NULL,0));

		      //strtoul( string, NULL, 0 )
		DumpRegsToScreen();
		} 
		else if ( strcmp("INJECT",argstr(answer,token,0)) ==0)
		{
		argstr(answer,token,2);
		strcpy(filename,token);
		Dbg.Inject( strtoul(argstr(answer,token,1),NULL,0),  \
			    filename );
		}
	} 
	else if (numargs==3)
	{
		if ( strcmp("DUMP",argstr(answer,token,0)) ==0)
		argstr(answer,token,3);
		strcpy(filename,token);
		Dbg.DumpRegion( strtoul(argstr(answer,token,1),NULL,0),  \
			        strtoul(argstr(answer,token,2),NULL,0),  \
			        filename);
	}
	//for(i=0;i<=numargs;i++)
	//msg("arg %d -> %s\n",i,argstr(answer,token,i));
}
}
bDbgEngine=false;
*/
}

/*//////////////////////////////////////////////////////////////////////
                      IDA PRO INTERFACE START HERE
//////////////////////////////////////////////////////////////////////*/
//--------------------------------------------------------------------------
//
//      initialize plugin
//
//      IDA will call this function only once.
//      If this function returns PLGUIN_SKIP, IDA will never load it again.
//      If this function returns PLUGIN_OK, IDA will unload the plugin but
//      remember that the plugin agreed to work with the database.
//      The plugin will be loaded again if the user invokes it by
//      pressing the hotkey or selecting it from the menu.
//      After the second load the plugin will stay on memory.
//
//      In this example we check the input file format and make the decision.
//      You may or may not check any other conditions to decide what you do:
//      whether you agree to work with the database or not.
//
void initdata()
{
bATrace = false;
bDbgEngine = true;
bRunning = false;
iTriggeredBpx = 0;
}

int init(void)
{

  if ( inf.filetype != f_PE ) 
  {
	msg("Idbg: cannot use plugin on non PE files!\n");
	return PLUGIN_SKIP; // only for PE files
  }

initdata();
msg("Idbg %s: loaded\n",idbgversion);
return PLUGIN_KEEP;
//return PLUGIN_OK;
}

//--------------------------------------------------------------------------
//      terminate
//      usually this callback is empty
//
//      IDA will call this function when the user asks to exit.
//      This function won't be called in the case of emergency exits.

void term(void)
{

}

char comment[] = "Idbg";

char help[] =
"\n";

//--------------------------------------------------------------------------
// This is the preferred name of the plugin module in the menu system
// The preferred name may be overriden in plugins.cfg file

char wanted_name[] = "Idbg";


// This is the preferred hotkey for the plugin module
// The preferred hotkey may be overriden in plugins.cfg file
// Note: IDA won't tell you if the hotkey is not correct
//       It will just disable the hotkey.

char wanted_hotkey[] = "SHIFT-I"; // Ctrl-F12 is used to draw function call graph now
                           // No hotkey for PDB files, but since it is not
                           // used very often, it is tolerable

//--------------------------------------------------------------------------
//
//      PLUGIN DESCRIPTION BLOCK
//
//--------------------------------------------------------------------------

extern "C" plugin_t PLUGIN =
{
  IDP_INTERFACE_VERSION,
  0,                    // plugin flags
  init,                 // initialize

  term,                 // terminate. this pointer may be NULL.

  plugin_main,          // invoke plugin

  comment,              // long comment about the plugin
                        // it could appear in the status line
                        // or as a hint

  help,                 // multiline help about the plugin

  wanted_name,          // the preferred short name of the plugin
  wanted_hotkey         // the preferred hotkey to run the plugin
};

