;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                       ;;
;;;;;   View Vector Table ;;
;;;;            [yAtEs]   ;;
;;;     02/Jul/01         ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

.MODEL SMALL

.DATA

vectaddr dw 0
intnum   db 0
intmsg   db 10,13,"Interrupt #","$"
space    db "       $"
intromsg db 10,13,"Vector Table Contents",10,13,"-+-+-+-+-+-+-+-+-+-+-",10,13,"$"

.STACK


.CODE

MAIN  PROC

mov ax,@data
mov ds,ax    ; init data segment

mov ah,09
mov dx,offset intromsg
int 21h

grab_vector:

 mov ah,09
 mov dx,offset intmsg
 int 21h

 mov dl,intnum
 call WRITE_HEX ; write interrupt number
 mov dl,' '
 call WRITE_CHAR

 mov ah,09
 mov dx,offset space
 int 21h

xor bx,bx
mov es,bx   ; use the extra segment to get to 0000:0000
xor bx,bx

mov bx,DS:[vectaddr]
add bx,2   ; move 2 places in and get the CS first

mov ax,ES:[bx]

mov dl,ah
call WRITE_HEX   ; output cs
mov dl,al
call WRITE_HEX   ; output cs

mov dl,':'
call WRITE_CHAR

mov bx,DS:[vectaddr]
mov ax,ES:[bx]   ; get ip
mov dl,ah
call WRITE_HEX
mov dl,al
call WRITE_HEX


mov ah,09
mov dx,offset space
int 21h

mov dl,0
call WRITE_HEX   ; output CS as 0 since this is where the vector table
mov dl,0         ;  is always located.
call WRITE_HEX

mov dl,':'
call WRITE_CHAR

mov cx,vectaddr

mov dl,ch
call WRITE_HEX   ; output how far into the table we are
mov dl,cl
call WRITE_HEX

inc vectaddr
inc vectaddr  ; increase the vector address by 2 words
inc vectaddr  ;  for next int CS:IP
inc vectaddr

mov al,intnum  
cmp al,40h     ; have we got enough info yet?
je end_loop

inc intnum

jmp grab_vector

end_loop:
xor ax,ax

mov ah,4Ch
int 21h  ; exit

MAIN  ENDP



;_____________________________________________________________
PUBLIC WRITE_HEX
;_____________________________________________________________
WRITE_HEX       PROC
 push cx
 push dx
 mov dh,dl
 mov cx,4
 shr dl,cl
 call WRITE_HEX_DIGIT
 mov dl,dh
 and dl,0fh
 call WRITE_HEX_DIGIT
 pop dx
 pop cx
 ret
WRITE_HEX       ENDP
;_____________________________________________________________ 


;_____________________________________________________________
PUBLIC WRITE_HEX_DIGIT
;_____________________________________________________________
WRITE_HEX_DIGIT PROC

push dx
cmp dl,10
jae HEX_LETTER
add dl,"0"
jmp short WRITE_DIGIT
HEX_LETTER:
add dl,"A"-10
WRITE_DIGIT:
call WRITE_CHAR
pop dx
ret

WRITE_HEX_DIGIT ENDP
;_____________________________________________________________



;_____________________________________________________________
PUBLIC WRITE_CHAR
;_____________________________________________________________
WRITE_CHAR      PROC
push ax
push dx
mov ah,2
int 21h
pop dx
pop ax
ret
WRITE_CHAR      ENDP


END MAIN
;_____________________________________________________________





