; ------------------------------------------------------------------------------
; it can be entered from three different modes: V86, ring-3 PM and ring-0 PM.

; no matter where we're coming from though, the client registers will always be
; set up the same way.
; for 'D':
;    EDI: flat start address of block
;    ECX: length of block (or 0 if emulating old PAGEIN)
;    ESI: filename (or 0 if emulating old PAGEIN)

Callback:
.entryV86CB:
	pushad
	mov	edi,0xF0000		; start of ROM BIOS
	mov	ecx,0x10000		; length of area we search through
	mov	al,0xCC			; opcode of INT3
	cld
	repnz	scasb			; may cause page fault
	jecxz	.useClientStack		; damn, let's hack the stack instead

	dec	edi			; adjust EDI
	shld	ecx,edi,28		; ECX: client CS
	shrd	ebx,edi,4		; EBX: client IP
	shr	ebx,28
	jmp short .setPAGEIN_INT3

.useClientStack:
	movzx	ecx,word [ebp+CRS.SS]	; get client SS
	shrd    edi,ecx,28		; convert to linear address
	movzx   ebx,word [ebp+CRS.ESP]	; get client SP
	dec	bx			; 1 byte below the stack
	add	edi,ebx			; linear address of our INT3
	stosb				; may cause page fault

.setPAGEIN_INT3:
	mov	[edx+oPAGEIN_INT3],ebx	; store address of our INT3
	jmp short .setCSEIP

.entryPMCB:
	pushad
	mov	ecx,[edx+wSelector_WINICE_Code]	; set client CS:EIP to an INT3
	mov     ebx,jPAGEIN_INT3-WINICE_DELTA

.setCSEIP:
        mov     [ebp+CRS.CS],ecx
	mov	[ebp+CRS.EIP],ebx
	jmp short .service

.entryPMR0:
	call	.delta
.delta:
	sub	dword [esp],.delta	; geee, why does NASM not let me do it
	add	dword [esp],jPAGEIN_INT3; in one expression...
	pushad				; simulate Client Register Structure
	mov	ebp,esp			; on the stack

.service:
;	cmp	dword [ebp+CRS.EAX],byte SERVICE_VERSION
;	jnz	.1
;	mov	dword [ebp+CRS.EAX],ICEDUMP_VERSION
;	popad
;	retn
;.1
	cmp	dword [ebp+CRS.EAX],byte SERVICE_DUMP
	jz	near Service_Dump

	cmp	dword [ebp+CRS.EAX],byte SERVICE_LOAD
	jz	near Service_Load

	cmp	dword [ebp+CRS.EAX],byte SERVICE_SUSPENDX
	jz	near Service_SuspendResume

	cmp	dword [ebp+CRS.EAX],byte SERVICE_SUSPEND
	jz	near Service_SuspendResume

	cmp	dword [ebp+CRS.EAX],byte SERVICE_RESUME
	jz	near Service_SuspendResume

;	cmp	dword [ebp+CRS.EAX],byte SERVICE_KILL
;	jz	near Service_Kill

	cmp	dword [ebp+CRS.EAX],byte SERVICE_CDPLAYER
	jz	near Service_CDPlayer

	cmp	dword [ebp+CRS.EAX],byte SERVICE_UPDATE
	jz	near Service_Update

	popad
	retn
