;-------------------------------------------------------------------------------
; PAGEIN B <Bhrama window name>
;-------------------------------------------------------------------------------
Parse_Bhrama:
	lea	edi,[ebp+Error_V86]
	test	byte [ebp+dClient_EFLAGS+2],2	; is client in V86 mode?
	jnz	near Parser.errorMsg

	lea	edi,[ebp+Error_PM16]
	lar	eax,[ebp+dClient_CS]		; is client 32 bit?
	bt	eax,22
	jnc	near Parser.errorMsg

	lea	edi,[ebp+Error_PMR0]
	test	byte [ebp+dClient_CS],3	; is client in ring-0?
	jz	near Parser.errorMsg

	lea	edi,[ebp+Error_API]
	call	GetAPIs
	jc	near Parser.errorMsg

	mov	[ebp+dClient_EDI],ebp	; winice base
	mov	[ebp+dClient_ESI],esi	; bhrama server's window name
	mov	eax,[ebp+dClient_EIP]	; use current EIP
	mov	[ebp+Procdump.dumpinfo+BhramaComStruc.EIP],eax

	lea	ecx,[ebp+Procdump]
	lea	eax,[ebp+jPAGEIN_INT3]
	mov	[ebp+dClient_EIP],ecx	; set client (E)IP
	mov	[ebp+oPAGEIN_INT3],eax	; set address of final INT3

	xor	eax,eax
	inc	eax

	mov	[ebp+fPAGEIN_InProgress],eax	; set internal Winice flag to 1
	mov	[ebp+fExecuteMoreCommands],ah	; set internal Winice flag to 0

	popad
	retn


; ------------------------------------------------------------------------------
; this is where we call Procdump based on Stone's example
; ------------------------------------------------------------------------------
Procdump:
	call	[edi+API.oGetCurrentProcessID]
	mov	[edi+.dumpinfo+BhramaComStruc.PID],eax
;	mov	[edi+.dumpinfo+BhramaComStruc.EIP],0x0
;	mov	[edi+.dumpinfo+BhramaComStruc.OptL1],0x00000000
;	mov	[edi+.dumpinfo+BhramaComStruc.OptL2],0x01000001
;	mov	[edi+.dumpinfo+BhramaComStruc.OptL3],0x01010001
;	mov	[edi+.dumpinfo+BhramaComStruc.OptL4],0x00010000
;	mov	[edi+.dumpinfo+BhramaComStruc.OptL5],0x00000000

; LookUp for ProcDump Server.
	push	esi
	push	byte 0
	call	[edi+API.oFindWindowA]
	test	eax,eax
	jz	.return

; Send Dump Message to ProcDump Server.
.sendmsg:
	lea	ebx,[edi+.Service]
	push	ebx
	push	byte 0
	push	byte WM_COPYDATA
	push	eax			; ProcDump's hwnd
	call	[edi+API.oSendMessageA]

.return:
	add	edi,jPAGEIN_INT3
	jmp	edi

	align 4
.Service:	dd 1
.DataLength:	dd BhramaComStruc_size
.DataPointer:	dd .dumpinfo		; reloc

.dumpinfo:
	istruc BhramaComStruc
	at BhramaComStruc.version,	dd 3
	at BhramaComStruc.PID,		dd 0
	at BhramaComStruc.EIP,		dd 0
	at BhramaComStruc.OptL1,	dd 0x00000000
	at BhramaComStruc.OptL2,	dd 0x01000101
	at BhramaComStruc.OptL3,	dd 0x01010001
	at BhramaComStruc.OptL4,	dd 0x00030000
	at BhramaComStruc.OptL5,	dd 0x00000000
	iend
