;-------------------------------------------------------------------------------
; PAGEIN D <address> [<length> <file name>]
;-------------------------------------------------------------------------------
Parse_Dump:
	push	byte SERVICE_DUMP
	pop	dword [ebp+dClient_EAX]

	lea	edi,[ebp+.Error_BadAddress]
	call	pExpression2Integer	; parse <address>
	jb	near Parser.errorMsg

	mov	[ebp+dClient_EDI],eax	; store start address of block

	call	pSkipWhiteSpace		; skip to <length>
	jz	.emulate		; let's emulate the old behaviour

	lea	edi,[ebp+.Error_BadLength]
	call	pExpression2Integer	; parse <length>
	jb	near Parser.errorMsg

	mov	dl,byte [ebp+OD_TOGGLE_EXPERT_MODE.Emode]
	cmp	dl,'E'			; see if in expert mode	
	jne	.modeD

	mov	[ebp+dClient_ECX],eax	; store length of block

	lea	edi,[ebp+.EmodeFileName]
	mov	[ebp+dClient_ESI],edi	; store ptr to filename
	add	edi,[ebp+.EmodeExtPtr]	; get offset of the extension
	call	EmodeSub.IncDumpNum
	jmp	.setCB

.modeD:

	call	pSkipWhiteSpace		; skip to <file name>
	jnz	.setDumpInfo

.emulate:
	xor	eax,eax			; zero length, old PAGEIN is emulated
	xor	esi,esi			; no filename, old PAGEIN is emulated

.setDumpInfo:
	mov	[ebp+dClient_ESI],esi	; store pointer to file name
.setDumpLength:
	mov	[ebp+dClient_ECX],eax	; store length of block

.setCB:
	call	SetCB
	jc	near Parser.error

.success:
	xor     eax,eax			; wow, saves 2 bytes
	inc	eax			; thanks G-Rom ;-)

	mov     [ebp+fPAGEIN_InProgress],eax	; set internal Winice flag to 1
	mov     [ebp+fExecuteMoreCommands],ah	; set internal Winice flag to 0

	popad
	retn

.Error_BadAddress	db 'invalid address.',0
.Error_BadLength	db 'invalid length.',0

.EmodeViewFilename: db 'Current auto-dump filename: '
.EmodeFileName: db 'C:\MEMDUMP.00/',0		; watch out for .EmodeExtPtr

; this should padd up to OPT_EMODE_FILENAMELEN and leave extra space
; for dump-number
TIMES OPT_EMODE_FILENAMELEN-($-.EmodeFileName)+1+OPT_EMODE_NUMLEN	db 0

.EmodeExtPtr:	dd 11


;-------------------------------------------------------------------------------
; this is the actual dumper code that's executed in ring-0.
;-------------------------------------------------------------------------------
Service_Dump:
	mov	esi,[ebp+CRS.ESI]	; get pointer to file name
	test	esi,esi			; emulate old PAGEIN?
	jz	.emulate

	mov	eax,R0_OPENCREATFILE
	mov	ebx,0x2012		; read/write|share:deny all|no INT24
;	mov	ecx,0x20		; archive
	movzx	ecx,bh
;	mov	edx,0x12		; replace/open|create
	movzx	edx,bl
	VxDCall IFSMgr_Ring0_FileIO
	jb	.return

	mov	ebx,eax			; store file handle

.emulate:
	mov	esi,[ebp+CRS.EDI]	; get start address of block

.loop:
	mov	edi,esi
	shr	edi,12			; get current page number
	mov	eax,edi			; save page number for later use
	inc	edi			; get next page number
	shl	edi,12			; get linear start address of next page
	sub	edi,esi			; get length of block on current page
	mov	ecx,[ebp+CRS.ECX]	; get remaining length
	cmp	edi,ecx			; EDI: bytes to dump from current page
	ja	.1

	mov	ecx,edi			; dump from one page at a time
.1:

	call	IsPageCommitted
	jz	.skipPage

	mov	al,[esi]		; PAGEIN!

	jecxz	.return			; emulate old PAGEIN?

	mov	eax,R0_WRITEFILE
	push	ebx			; save file handle
	mov	edx,esi
	sub	edx,[ebp+CRS.EDI]	; EDX: absolut file pointer
	VxDCall IFSMgr_Ring0_FileIO
	pop	ebx			; restore file handle
	jb	.close

.skipPage:
	jecxz	.return			; emulate old PAGEIN?

	add	esi,ecx
	sub	[ebp+CRS.ECX],ecx	; are we done?
	jnz	.loop

.close:
	mov	eax,R0_CLOSEFILE
	VxDCall IFSMgr_Ring0_FileIO

.return:
	popad
	retn				; client will return to an INT3
