;-------------------------------------------------------------------------------
; PAGEIN L <address> <length> <file name>
;-------------------------------------------------------------------------------
Parse_Load:
	push	byte SERVICE_LOAD
	pop	dword [ebp+dClient_EAX]

	lea	edi,[ebp+.Error_BadAddress]
	call	pExpression2Integer	; parse <address>
	jb	near Parser.errorMsg

	mov	[ebp+dClient_EDI],eax	; store start address of block

	lea	edi,[ebp+.Error_NoLength]
	call	pSkipWhiteSpace		; skip to <length>
	jz	near Parser.errorMsg

	lea	edi,[ebp+.Error_BadLength]
	call	pExpression2Integer	; parse <length>
	jb	near Parser.errorMsg

	mov	[ebp+dClient_ECX],eax	; store length of block

	lea	edi,[ebp+.Error_NoFile]
	call	pSkipWhiteSpace		; skip to <file name>
	jz	near Parser.errorMsg

	mov	[ebp+dClient_ESI],esi	; store pointer to file name

	call	SetCB
	jc	near Parser.error

	xor     eax,eax
	inc	eax

	mov     [ebp+fPAGEIN_InProgress],eax	; set internal Winice flag to 1
	mov     [ebp+fExecuteMoreCommands],ah	; set internal Winice flag to 0

	popad
	retn

.Error_BadAddress	db 'invalid address.',0
.Error_NoLength		db 'specify length.',0
.Error_BadLength	db 'invalid length.',0
.Error_NoFile		db 'specify filename.',0


;-------------------------------------------------------------------------------
; this is the actual file loader code that's executed in ring-0.
;-------------------------------------------------------------------------------
Service_Load:
	mov	esi,[ebp+CRS.ESI]	; get pointer to file name
	mov	eax,R0_OPENCREATFILE
	mov	ebx,0x2040		; read only|share:deny none|no INT24
;	mov	ecx,0x20		; archive
	movzx	ecx,bh
	mov	edx,0x01		; open|fail
	VxDCall IFSMgr_Ring0_FileIO
	jb	.return

	mov	ebx,eax			; store file handle
	mov	esi,[ebp+CRS.EDI]	; get start address of block

.loop:
	mov	edi,esi
	shr	edi,12			; get current page number
	mov	eax,edi			; save page number for later use
	inc	edi			; get next page number
	shl	edi,12			; get linear start address of next page
	sub	edi,esi			; get length of block on current page
	mov	ecx,[ebp+CRS.ECX]	; get remaining length
	cmp	edi,ecx			; EDI: bytes to read into current page
	ja	.1

	mov	ecx,edi			; dump from one page at a time
.1:

	call	IsPageCommitted
	jz	.skipPage

;	mov	edi,0xFF800000		; linear start address of page tables
;	lea	edx,[edi+4*eax]		; EAX: current page number
;	shr	edx,12			; EDX: current directory number

;       pushfd
;	cli
;	push	dword [edi+4*edx]	; save PDE
;	push	dword [edi+4*eax]	; save PTE
;	or	byte [edi+4*edx],0x2	; make page directory writable
;	or	byte [edi+4*eax],0x2	; make page writable
;	add	esp,byte 8
;	popfd
;	sub	esp,byte 12

	mov	al,[esi]		; PAGEIN!

	mov	eax,R0_READFILE
	push	ebx			; save file handle
	mov	edx,esi
	sub	edx,[ebp+CRS.EDI]	; EDX: absolut file pointer
	VxDCall IFSMgr_Ring0_FileIO
	pop	ebx			; restore file handle
	jb	.close

.skipPage:
	add	esi,ecx
	sub	[ebp+CRS.ECX],ecx	; are we done?
	jnz	.loop

.close:
	mov	eax,R0_CLOSEFILE
	VxDCall IFSMgr_Ring0_FileIO

.return:
	popad
	retn				; client will return to an INT3
