;-------------------------------------------------------------------------------
; PAGEIN O (Execute command for help)
;-------------------------------------------------------------------------------
Parse_Option:				; OPTION parser for sub-sub commands
	call	pSkipWhiteSpace		; skip to subcommand
	jz	Option_HELP

	lodsb				; get subcommand
	and	al,0x5F			; upcase
	
	cmp	al,'N'
	jz	near O_SCREENDUMP

	cmp	al,'D'
	jz	near O_MEMDUMP

Option_HELP:
	lea	esi,[ebp+.helpON]
	call	pPrintToCommandWindow

	lea	esi,[ebp+.helpONf]
	call	pPrintToCommandWindow

	lea	esi,[ebp+.helpONd]
	call	pPrintToCommandWindow

	lea	esi,[ebp+.helpONv]
	call	pPrintToCommandWindow

	lea	esi,[ebp+.helpOD]
	call	pPrintToCommandWindow

	lea	esi,[ebp+.helpODf]
	call	pPrintToCommandWindow

	lea	esi,[ebp+.helpODd]
	call	pPrintToCommandWindow

	lea	esi,[ebp+.helpODv]
	call	pPrintToCommandWindow

;	lea	esi,[ebp+.helpODl]
;	call	pPrintToCommandWindow

	jmp	Parser.return

.helpON:	db 'PAGEIN O N              - toggle screendump expert mode on/off',0
.helpONf:	db 'PAGEIN O N F <filename> - alter base filename',0
.helpONd:	db 'PAGEIN O N D <number>   - alter current dump number',0
.helpONv:	db 'PAGEIN O N V            - show current screendump options',0

.helpOD:	db 'PAGEIN O D              - toggle memdump expert mode on/off',0
.helpODf:	db 'PAGEIN O D F <filename> - alter base filename',0
.helpODd:	db 'PAGEIN O D D <number>   - alter current dump number',0
.helpODv:	db 'PAGEIN O D V            - show current memdump options',0
;.helpODl:	db 'PAGEIN O D L <number>   - alter default dump length',0

O_SCREENDUMP:
	call	pSkipWhiteSpace		; skip to real params
	jz	ON_TOGGLE_EXPERT_MODE
	
	lodsb				; get subcommand
	and	al,0x5F			; upcase
	
	cmp	al,'D'
	jz	near ON_SET_DUMP_NUMBER
	
	cmp	al,'F'
	jz	near ON_SET_DUMP_BASEFILENAME

	cmp	al,'V'
	jz	near ON_VIEW_SCREENDUMP_OPTIONS

	jmp	Option_HELP

ON_TOGGLE_EXPERT_MODE:
	xor	byte [ebp+ON_TOGGLE_EXPERT_MODE.Emode],1

	lea	esi,[ebp+.msgEXPERT_MODE]
	call	pPrintToCommandWindow

	jmp	Parser.return	

.msgEXPERT_MODE:db 'Screendump expert mode (Enabled/Disabled): '
.Emode:		db 'D',0

ON_SET_DUMP_NUMBER:
	call	pSkipWhiteSpace		; skip to real params
	jz	near Option_HELP

	lea	edi,[ebp+Parse_ScreenDump.EmodeFileName]
	add	edi,[ebp+Parse_ScreenDump.EmodeExtPtr]
	call	EmodeSub.SetDumpNum

	jmp	Parser.return

ON_SET_DUMP_BASEFILENAME:
	call	pSkipWhiteSpace		; skip to real params
	jz	near Option_HELP

	lea	edi,[ebp+Parse_ScreenDump.EmodeFileName]
	lea	ebx,[ebp+Parse_ScreenDump.EmodeExtPtr]	; num ptr
	call	EmodeSub.SetBaseFileName

	jmp	near Parser.return

ON_VIEW_SCREENDUMP_OPTIONS:
	lea	esi,[ebp+ON_TOGGLE_EXPERT_MODE.msgEXPERT_MODE]
	call	pPrintToCommandWindow

	lea	esi,[ebp+Parse_ScreenDump.EmodeFileName]
	call	pPrintToCommandWindow

	lea	esi,[ebp+Parse_ScreenDump.modeMsg]
	call	pPrintToCommandWindow
	jmp	Parser.error


O_MEMDUMP:
	call	pSkipWhiteSpace		; skip to real params
	jz	OD_TOGGLE_EXPERT_MODE
	
	lodsb				; get subcommand
	and	al,0x5F			; upcase
	
	cmp	al,'D'
	jz	near OD_SET_DUMP_NUMBER
	
	cmp	al,'F'
	jz	near OD_SET_DUMP_BASEFILENAME

	cmp	al,'V'
	jz	near OD_VIEW_DUMP_OPTIONS

	jmp	Option_HELP

OD_TOGGLE_EXPERT_MODE:
	xor	byte [ebp+OD_TOGGLE_EXPERT_MODE.Emode],1

	lea	esi,[ebp+.msgEXPERT_MODE]
	call	pPrintToCommandWindow

	jmp	near Parser.return	

.msgEXPERT_MODE:db 'Memdump expert mode (Enabled/Disabled): '
.Emode:		db 'D',0

OD_SET_DUMP_NUMBER:
	call	pSkipWhiteSpace		; skip to real params
	jz	near Option_HELP

	lea	edi,[ebp+Parse_Dump.EmodeFileName]
	add	edi,[ebp+Parse_Dump.EmodeExtPtr]
	call	EmodeSub.SetDumpNum

	jmp	Parser.return

OD_SET_DUMP_BASEFILENAME:
	call	pSkipWhiteSpace		; skip to real params
	jz	near Option_HELP

	lea	edi,[ebp+Parse_Dump.EmodeFileName]
	lea	ebx,[ebp+Parse_Dump.EmodeExtPtr]	; num ptr
	call	EmodeSub.SetBaseFileName
	
	jmp	Parser.return


OD_VIEW_DUMP_OPTIONS:

	lea	esi,[ebp+OD_TOGGLE_EXPERT_MODE.msgEXPERT_MODE]
	call	pPrintToCommandWindow

	lea	esi,[ebp+Parse_Dump.EmodeFileName]
	call	pPrintToCommandWindow

	jmp	Parser.error


; Expert/Auto Mode subroutines
;
;48 bytes max filname length
OPT_EMODE_FILENAMELEN	EQU 48
OPT_EMODE_NUMLEN	EQU 3

EmodeSub:
.SetDumpNum:	; EDI = number space in filename, ESI = param
	push	esi
	mov	ecx,OPT_EMODE_NUMLEN
	mov	edx,ecx

.sdn_loop1:
	lodsb			; validate the param
	cmp	al,'0'
	jb	.sdn_store0

	cmp	al,'9'
	ja	.sdn_store0

	loop	.sdn_loop1

.sdn_store0:
	pop	esi
	sub	edx,ecx		; how many positions are actually valid
	or	ecx,ecx
	jz	.sdn_storeN

	mov	al,'0'
	rep	stosb		; 0-prepend if the number is smaller than 3-pos
	
.sdn_storeN:
	mov	ecx,edx
	or	ecx,ecx		; do we have ANY valid numbers ? =)
	jz	.sdn_end

	rep	movsb

.sdn_end:
	dec	edi		; need to dec once due to the auto-inc on dump
	dec	byte [edi] 
	retn


.SetBaseFileName:	; ESI = params, EDI = filename buf, EBX = num ptr
	push	edi
	xor	ecx,ecx		; get length

.sbf_loop1:
	lodsb
	cmp	al,'*'
	jne	.sbf_notstar

.sbf_star:
	or	ebx,ebx		; check if numptr already stored
	jz	.sbf_noovfl

	mov	[ebx],ecx	; set number ptr
	xor	ebx,ebx		; ptr set, flag it
	push	eax
	push	ecx
	mov	ecx,OPT_EMODE_NUMLEN - 1
	mov	al,'0'		; store init dump number, ie '000'
	rep	stosb
	dec	eax
	stosb
	pop	ecx
	pop	eax
	jmp	.sbf_noovfl

.sbf_notstar:
	inc	ecx
	cmp	ecx,OPT_EMODE_FILENAMELEN
	jbe	.sbf_noovfl

	xor	eax,eax		; filename length limit reached
	jmp	.sbf_star	; store the number ptr and init
	
.sbf_noovfl:
	or	al,al
	jz	.sbf_zero

	cmp	al,'*'
	jz	.sbf_loop1

	stosb
	jmp	.sbf_loop1

.sbf_zero:
	or	ebx,ebx		; if there was no * in the filename
	jnz	.sbf_star	; append dump number
	stosb			; store 0-term

;	cmp	ecx,OPT_EMODE_FILENAMELEN
;	jbe	.sbf_nameok

;	lea	esi,[ebp+.helpOFE]	; error - filename too long
;	call	pPrintToCommandWindow

.sbf_nameok:
	pop	esi
	call	pPrintToCommandWindow
	retn

;.helpOFE:	db 'Filename is too long and was trimmed. Edit source and recompile for larger filename buffer.',0
	

.IncDumpNum:	; EDI = dump number ptr
	mov	ecx,OPT_EMODE_NUMLEN
	add	edi,ecx
	dec	edi		; now we got a ptr to the last digit
	mov	esi,edi
	std			; and going in reverse
	mov	ah,1

.idn_loop1:
	lodsb
	add	al,ah
	mov	ah,1		; have to set ah=0
	dec	ah		; and clear AF
	aaa
	or	al,0x30
	stosb
	loop	.idn_loop1
	cld			; the rest of the code assumes DF=0 =)
	retn
