;-------------------------------------------------------------------------------
; PAGEIN N [<file>]
;-------------------------------------------------------------------------------
Parse_ScreenDump:
	mov	dl, byte [ebp+ON_TOGGLE_EXPERT_MODE.Emode]
	cmp	dl, 'E'			; see if in expert mode
	je	.modeE
;	jmp	.modeE			; for debugging purposes - REMOVE! ;)

	call	pSkipWhiteSpace		; skip to <file name>
	jz	near .modeToggle

	mov	[ebp+dClient_ESI],esi	; store pointer to file name
	jmp	short .continue

.modeE:
	lea	edi,[ebp+.EmodeFileName]
	mov	[ebp+dClient_ESI],edi	; store ptr to filename
	add	edi,[ebp+.EmodeExtPtr]	; get offset of the extension
	call	EmodeSub.IncDumpNum

.continue:
	push	byte SERVICE_DUMP
	pop	dword [ebp+dClient_EAX]

	mov	edi,[ebp+oVideoMem]
	mov	[ebp+dClient_EDI],edi	; store start address of block
	mov	esi,edi			; OK, let's just build screen dump
					; in-situ instead of doing VMM crap :)
	movzx	eax,byte [ebp+bDisplayNumOfLines]
	mov	ecx,eax			; need this in ecx for the outer loop
	mov	ebx,[ebp+dCurrentScreenWidth]
	imul	eax,ebx

	mov	dl, byte [ebp+.mode]
	cmp	dl, '0'
	je	.mode0

	cmp	dl, '2'
	je	near mode2_html	; code is a little further /fOSSiL/
					; to save some bytes on short jumps

	lea	eax,[eax+2*ecx]		; fixup for the extra cr/lf
	mov	[ebp+dClient_ECX],eax	; store length of block
	mov	ax,0x0A0D		; cr/lf

.getNextPatchDatum:
	push	ecx			; yeah, sloppy, i know :) /Ghiri/
	mov	ecx,ebx

.innerloop:
	movsb
	inc	esi
	loop	.innerloop		; parse and copy raw screen

	stosw				; put in cr/lf
	pop	ecx
	loop	.getNextPatchDatum

	jmp	short .setCB

.mode0:
	add	eax,eax

.setDumpLength:
	mov	[ebp+dClient_ECX],eax	; store length of block

.setCB:
	call	SetCB
	jc	near Parser.error

.success:
	xor     eax,eax
	inc	eax

	mov     [ebp+fPAGEIN_InProgress],eax	; set internal Winice flag to 1
	mov     [ebp+fExecuteMoreCommands],ah	; set internal Winice flag to 0

	popad
	retn


.modeToggle:
	mov	al, byte [ebp+.mode]	; 3-pos toggle /fOSSiL/
	inc	al
	cmp	al, '3'
	jb	.modeToggle_n0

	mov	al, '0'

.modeToggle_n0:
	mov	byte [ebp+.mode], al
	lea	esi,[ebp+.modeMsg]
	call	pPrintToCommandWindow
	jmp	Parser.error

.modeMsg:	db 'Screen dumper set to mode '
.mode:		db '1',0

.EmodeViewFilename: db 'Current auto-dump filename: '
.EmodeFileName: db 'C:\DEFAULT.00/',0		; watch out for .EmodeExtPtr

; this should pad up to OPT_EMODE_FILENAMELEN and leave extra space
; for dump-number
TIMES OPT_EMODE_FILENAMELEN-($-.EmodeFileName)+1+OPT_EMODE_NUMLEN	db 0

.EmodeExtPtr:	dd 11


;----------------------------------
; /fOSSiL/  RAW-->HTML
; Let the games begin...
;----------------------------------
mode2_html:
	mov	edx, ecx
	; move the buffer as far as possible
	shl	eax, 1
	add	edi, 0a000h
	sub	edi, eax
	push	edi		; save the future source buf
	push	esi		; future destination
	xchg	ecx, eax
	repnz	movsb

	pop	edi
	lea	eax, [ebp+.begin]	; write html header
	call	.write
	pop	esi

	; ebx = Width, edx = Height
	mov	ecx, edx

.loop1:	
	lea	eax, [ebp+.line1]	; write row header part 1
	call	.write

	xor	eax, eax
	lodsw
	push	eax			; we will need it
	shr	eax, 12
	call	.wclr		; write backcolor

	lea	eax, [ebp+.line2]
	call	.write		; write row header part 2
	pop	eax

	push	ecx
	mov	ecx, ebx
	jmp	.loop2_nl

.loop2:
	lodsw

.loop2_nl:
	ror	eax, 8
	cmp	ah, al			; check current color
	je	.loop2_nc
	call	.setcolor		; set font color
	mov	ah, al			; save current color

.loop2_nc:
	rol	eax, 8

	call	.wchar		; xlat and write char out
	loop	.loop2

	pop	ecx

	lea	eax, [ebp+.endline]	; write endline
	call	.write

	loop	.loop1

	lea	eax, [ebp+.end]	; write end block
	call	.write

	sub	edi, [ebp+oVideoMem]
	mov	eax, edi
	mov	[ebp+dClient_ECX],eax	; store length of block

	call	SetCB
	jc	near Parser.error

	xor     eax,eax			; wow, saves 2 bytes
	inc	eax			; thanks G-Rom ;-)

	mov     [ebp+fPAGEIN_InProgress],eax	; set internal Winice flag to 1
	mov     [ebp+fExecuteMoreCommands],ah	; set internal Winice flag to 0

	popad
	retn

.write:
	push	esi
	mov	esi, eax

.w_loop:
	lodsb
	or	al, al
	jz	.w_done

	stosb
	jmp	.w_loop

.w_done:
	pop	esi
	retn

.setcolor:
	push	eax
	lea	eax, [ebp+.setclr1]	; write <FONT...
	call	.write

	mov	eax, [esp]
	call	.wclr			; write color code

	lea	eax, [ebp+.setclr2]
	call	.write			; write end tag

	pop	eax
	retn

.wclr:
	mov	edx, eax
	mov	eax, 'AF00'
	mov	dh, 3
	shl	dl, 5		; check and adjust intensity
	jnc	.wc_loop	; CF=0 when intensity low

	add	al, 5

.wc_loop:
	shl	dl, 1		; test next bit
	jc	.wc_nr1

	ror	eax, 16		; switch to '00', also clc
;	clc			; left for clarity, if it helps =)

.wc_nr1:
	stosw
	jc	.wc_nr2

	ror	eax, 16			; put it back now

.wc_nr2:
	dec	dh
	jnz	.wc_loop

	retn

.wchar:
	; some lame char xlat
	; unfortunately, a nessecity for HTML
	push	esi
	push	eax
	mov	dl, al
	lea	esi, [ebp+.xltab]

.ch_next:
	lodsb
	cmp	dl, al
	jz	.chout

	or	al, al
	jz	.ch_nomatch

.ch_skip:	
	lodsb
	or	al, al
	jnz	.ch_skip

	jmp	.ch_next

.ch_nomatch:	
	cmp	dl, 32		; no matching xlat entry found
	jb	.chout		; check if 32-127 ascii code

	cmp	dl, 127		; and if not, print ' '
	ja	.chout

	mov	al, dl
	stosb
	jmp	.ch_end

.chout:
	mov	eax, esi	; we've moved on to 1->many char xlat
	call	.write	; so now we have to print strings

.ch_end:
	pop	eax
	pop	esi
	retn

.begin	db '<HTML><BODY>',13,10
	db '<TABLE bgcolor="black"><TR><TD><TABLE border="0">',13,10,0

.end	db '</TABLE></TD></TABLE>',13,10
	db '</BODY></HTML>',0

.line1		db '<TR bgcolor="#',0
.line2		db '"><TD><PRE>',0
.endline	db '</TD>',13,10,0

.setclr1	db '<FONT color="#',0
.setclr2	db '">',0

.xltab	db 16,'>',0,	17,'&lt;',0,	24,'^',0,	25,'v',0
	db 30,'^',0,	31,'v',0,	196,'-',0,	'<','&lt;',0
	db 0,' ',0
