;-------------------------------------------------------------------------------
; PAGEIN S <PID>|<TID>
; PAGEIN X <PID>|<TID>
; PAGEIN R <PID>|<TID>
;-------------------------------------------------------------------------------
Parse_SuspendX:
	call	GetAPIs
	jc	near Parser.error

	lea	edi,[ebp+Error_V86]
	test	byte [ebp+dClient_EFLAGS+2],2	; is client in V86 mode?
	jnz	near Parser.errorMsg

	lea	edi,[ebp+Error_PM16]
	lar	eax,[ebp+dClient_CS]	; is client 32 bit?
	bt	eax,22
	jnc 	near Parser.errorMsg

	lea	edi,[ebp+Error_NoID]
	call	pExpression2Integer	; parse <pid>|<tid>
	jb	near Parser.errorMsg

; save client EAX/EDI/CS/EIP
	push	dword [ebp+dClient_EAX]
	pop	dword [ebp+.EAX]

	push	dword [ebp+dClient_EDI]
	pop	dword [ebp+.EDI]

	push	dword [ebp+dClient_CS]
	pop	dword [ebp+.CS]

	push	dword [ebp+dClient_EIP]
	pop	dword [ebp+.EIP]

; set up registers for service
	push	byte SERVICE_SUSPENDX
	pop	dword [ebp+dClient_EAX]

	mov	[ebp+dClient_EDI],ebp	; winice base
	mov	[ebp+dClient_ESI],eax	; store pid or tid

	call	SetCB
	jc	near Parser.error

	mov     byte [ebp+fExecuteMoreCommands],0; set internal Winice flag to 0
	popad
	retn

	align 4
.EAX:	dd 0
.EDI:	dd 0
.CS:	dd 0
.EIP:	dd 0


Parse_Suspend:
	push	byte SERVICE_SUSPEND
	pop	dword [ebp+dClient_EAX]
	jmp	short Parse_PidTid

Parse_Resume:
	push	byte SERVICE_RESUME
	pop	dword [ebp+dClient_EAX]

Parse_PidTid:
	call	GetAPIs
	jc	near Parser.error

	lea	edi,[ebp+Error_V86]
	test	byte [ebp+dClient_EFLAGS+2],2	; is client in V86 mode?
	jnz	near Parser.errorMsg

	lea	edi,[ebp+Error_PM16]
	lar	eax,[ebp+dClient_CS]	; is client 32 bit?
	bt	eax,22
	jnc 	near Parser.errorMsg

	lea	edi,[ebp+Error_NoID]
	call	pExpression2Integer	; parse <pid>|<tid>
	jb	near Parser.errorMsg

	mov	[ebp+dClient_EDI],ebp	; winice base
	mov	[ebp+dClient_ESI],eax	; store pid or tid

	call	SetCB
	jc	near Parser.error

.success:
	xor     eax,eax
	inc	eax

	mov     [ebp+fPAGEIN_InProgress],eax	; set internal Winice flag to 1
	mov     [ebp+fExecuteMoreCommands],ah	; set internal Winice flag to 0

	popad
	retn


Service_SuspendResume:
	mov	esi,[ebp+CRS.EDI]	; winice base

	lea	ebx,[esi+.K32_Error]
	call	GetK32Info
	jc	near .error

	cmp	dword [esi+.Win32ServiceTable],byte 0	; init phase completed?
	jnz	.has_pointer

	push 	byte 0x2A		; vwin32.vxd ID
	pop	eax
	VMMCall Get_DDB
	mov	eax,[ecx+0x38]		; get Win32 Services Table pointer
	lea	ebx,[esi+.W32_Error]
	or	eax,eax			; is it initialized ?
	jz	near .error

	mov	[esi+.Win32ServiceTable],eax

.has_pointer:
	mov	eax,[ebp+CRS.ESI]	; get xID
	cmp	eax,0xF0000000
	jb	.is_dbase

	mov	ecx,[esi+dK32XOR]	; ECX: obfuscator
	cmp	ecx,byte 0		; is obfuscator initialized?
	lea	ebx,[esi+.Obf_Error]
	jz	.error

	xor	eax,ecx			; EAX: Thread or Process Database

.is_dbase:
	push	eax			; save it for later use
	shr	eax,12			; convert it to page number
	lea	ebx,[esi+.Mem_Error]
	call	IsPageCommitted		; can we access the corresponding page?
	pop	eax			; back to linear address
	jz	.error

	lea	ebx,[esi+.Obj_Error]
;	cmp	eax,0x80000000		; PDB/TDB are above private arena
;	jb	.error
	bt	eax,31
	jnc	.error

	xor	ecx,ecx

	mov	bl,[esi+R3TID]
	cmp	byte [eax],bl
	jz	.handle_thread

	mov	bl,[esi+R3PID]
	cmp	byte [eax],bl
	jnz	.error

.is_process:
	mov	ecx,[eax+0x50]		; get ThreadList
	mov	ecx,[ecx]		; get Thread_Ref pointer

.more_threads:
	mov	eax,[ecx+8]		; get Thread Database        
	mov	ecx,[ecx]		; prefetch next Thread_Ref

.handle_thread:
	call	SuspendResumeThread        
	jnc	.continue

	lea	ebx,[esi+.Sch_Error]
	push	ebx
	VMMCall _Trace_Out_Service

.continue:
	jecxz	.return			; was it last/only thread to deal with?
	jmp	short .more_threads

.error:
	push	ebx
	VMMCall _Trace_Out_Service

.return:
	cmp	dword [ebp+CRS.EAX],byte SERVICE_SUSPENDX
	jnz	.done

; restore client EAX/EDI/CS/EIP
	push	dword [esi+Parse_SuspendX.EAX]
	pop	dword [ebp+CRS.EAX]

	push	dword [esi+Parse_SuspendX.EDI]
	pop	dword [ebp+CRS.EDI]

	push	dword [esi+Parse_SuspendX.CS]
	pop	dword [ebp+CRS.CS]

	push	dword [esi+Parse_SuspendX.EIP]
	pop	dword [ebp+CRS.EIP]

.done:
	popad
	retn

	align 4
;------------------------------------------------------------------------------
.Win32ServiceTable	dd 0
.K32_Error db 'unsupported Windows version, failed to determine Kernel32 info.',CRLF_0
.Sch_Error db 'failed to suspend/resume thread #EAX.',CRLF_0
.Obj_Error db 'object #EAX is not a valid thread or process object.',CRLF_0
.Obf_Error db 'obfuscator is not yet initialized.',CRLF_0
.W32_Error db 'vwin32.vxd has not completed initialization yet.',CRLF_0
.Mem_Error db 'page #EAX is not committed. verify command line.',CRLF_0
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
; in:  EAX: thread, EBP: Client registers, ESI: Winice Base
; out: clc: ok, stc: error
;------------------------------------------------------------------------------
SuspendResumeThread:        
	pushad
	cmp	eax,0xF0000000		; check if it's ThreadId
	jb	.is_dbase

	xor	eax,[esi+dK32XOR]	; EAX = Thread Database

.is_dbase:
	lea	edx,[esi+.sfClient]	; get fake client regs
	mov	edi,[esi+Service_SuspendResume.Win32ServiceTable]
	mov	ebx,[esi+R3TCB.SuspendCount]
	mov	ecx,[esi+R3TCB.R0TCB]

.select:
	cmp	dword [ebp+CRS.EAX],byte SERVICE_SUSPENDX
	jz	.suspendx

	cmp	dword [ebp+CRS.EAX],byte SERVICE_SUSPEND
	jz	.suspend

	cmp	dword [ebp+CRS.EAX],byte SERVICE_RESUME
	jz	.resume

.error:
	stc
	popad
	retn

.success:
	clc
	popad
	retn

.suspend:
	test	byte [ebp+CRS.CS],3	; skip this test if called from ring-0
	jz	.suspendx

	push	edi
	VMMCall Get_Cur_Thread_Handle
	cmp	edi,[eax+ecx]		; do not suspend the current one
	pop	edi
	jz	.error

.suspendx:
;	cmp	dword [eax+ebx],byte 0	; test suspension counter
;	jnz	.success		; already suspended?

	push	esi
	mov	esi,[esi+R3TCB.Flags]
	test	byte [eax+esi],0x40	; thread created suspended?
	pop	esi
	jnz	.s_update_r3

	push	esi
	mov	esi,[esi+R3TCB.Flags]
	test	byte [eax+esi+3],0x10
	pop	esi
	jnz	.error

	push	ebx			; save suspension counter index
	push	eax			; save TDB, EAX will get trashed

	push	dword [eax+ecx]		; ring0TCB
	push	byte 0			; fake VM handle
	push	edx			; Client Regs        
	mov	esi,[esi+VWIN32_W32_SuspendThread]
	lea	esi,[edi+esi*8+8]
	call	[esi]

	cmp	eax,byte -1
	pop	eax			; restore EAX
	pop	ebx			; restore suspension counter index
	jz	.error

.s_update_r3:
	inc	dword [eax+ebx]		; increment suspension counter

	jmp	short .success

.resume:
	cmp	dword [eax+ebx],byte 0	; test suspension counter
	jz	.success		; already running?

	push	esi
	mov	esi,[esi+R3TCB.Flags]
	test	byte [eax+esi],0x40	; thread created suspended?
	pop	esi
	jnz	.r_update_r3

	push	esi
	mov	esi,[esi+R3TCB.Flags]
	test	byte [eax+esi+3],0x10
	pop	esi
	jnz	.error

	push	ebx
	push	eax

	push    dword [eax+ecx]		; Ring0 Thread handle
	push	byte 0			; fake VM handle
	push	edx			; fake Client Registers     
	mov	esi,[esi+VWIN32_W32_ResumeThread]
	lea	esi,[edi+esi*8+8]
	call	[esi]

	cmp	eax,byte -1			; error?
	pop	eax
	pop	ebx
	jz	near .error

.r_update_r3:
	dec	dword [eax+ebx]		; decrement suspension counter

	clc
	popad
	retn

	align 4
.sfClient TIMES 8  dd 'SGER'
