;-------------------------------------------------------------------------------
; PAGEIN U <file>
;-------------------------------------------------------------------------------
Parse_Update:
	movb	dword [ebp+dClient_EAX],SERVICE_UPDATE	; store service #

	mov	[ebp+dClient_EDI],ebp	; winice base
	mov	[ebp+dClient_ESI],esi	; store pointer to file name
	call	SetCB
	jc	near Parser.error

	xor     eax,eax
	inc	eax
	mov     [ebp+fPAGEIN_InProgress],eax	; set internal Winice flag to 1
	mov     [ebp+fExecuteMoreCommands],ah	; set internal Winice flag to 0

	popad
	retn


;-------------------------------------------------------------------------------
; this is the actual Dyn Updater code that's executed in ring-0.
; Some cut-n-pasted Owl's code is here
;-------------------------------------------------------------------------------
UPDATE_CODE_MAX 	EQU 0x3000
UPDATE_CODE_ADDR	EQU PAGEIN_PATCH_ORIGIN + UPDATE_CODE_MAX

Service_Update:
	mov	esi,[ebp+CRS.ESI]	; get pointer to file name
	mov	ebp,[ebp+CRS.EDI]

	mov	eax,R0_OPENCREATFILE
	mov	ebx,0x2040		; read only|share:deny none|no INT24
;	mov	ecx,0x20		; archive
	movzx	ecx,bh
	movb	edx,0x01		; open|fail
	VxDCall	IFSMgr_Ring0_FileIO
	jc	near .FileError
	
	mov	ebx,eax			; store file handle

; read patch header info - Init RVA, hdr size
; let's hope we dont get a stack fault
	salloc	IcedumpHdr_size			; some stack space
	mov	eax,R0_READFILE
	movb	ecx,IcedumpHdr_size		; bytes to read
	xor	edx,edx				; file ofs
	mov	esi,edi				; buffer
	VxDCall	IFSMgr_Ring0_FileIO
; eax has error code, if any
	sfree	IcedumpHdr_size
	jc	.FileErrorClose

; no stack 'pushing' till stated otherwise =)
	mov	edx,[edi+IcedumpHdr.Init]
	movzx	ecx,word [edi+IcedumpHdr.Len]
	mov	eax,[edi+IcedumpHdr.SiVer]
	mov	edi,[edi+IcedumpHdr.ID]
; stack 'pushing' allowed from here

	lea	esi,[ebp+.szBadImgError]
	cmp	edi,ICEDUMP_ID
	jne	.ErrorClose

	lea	esi,[ebp+.szBadVerError]
	cmp	eax,WINICE_VERSION
	jne	.ErrorClose

	mov	eax,R0_GETFILESIZE
	VxDCall	IFSMgr_Ring0_FileIO
	jc	.FileError

	lea	esi,[ebp+.szSizeError]
	sub	eax,ecx
	cmp	eax,UPDATE_CODE_MAX
	ja	.ErrorClose

; now we need to do some cleanup (ie. restore int vectors)
; before loading a new version
	call	Cleanup

	xchg	eax,ecx
	push	ecx

; move the code, so read-in code wont overlap
	lea	esi,[ebp+UpdateMoved]
	lea	edi,[ebp+UPDATE_CODE_ADDR]
	mov	ecx,UpdateMoved.End-UpdateMoved
	rep	movsb
	
	pop	ecx	; adjusted size

; do some sanity checking
; it's not much, but at least something
	lea	esi,[ebp+.szBadInitError]
	cmp	edx,PAGEIN_PATCH_ORIGIN
	jb	.ErrorClose
	cmp	edx,UPDATE_CODE_ADDR
	ja	.ErrorClose

;	cmp	edx,PAGEIN_PATCH_ORIGIN
;	jne	.ErrorClose

	; transfer control to dyn patcher
	jmp	near UPDATE_CODE_ADDR

.return:
	popad
	retn				; client will return to an INT3

.FileErrorClose:
	call	.FileClose
.FileError:
	movzx	eax,ax
	lea	esi,[ebp+UpdateMoved.szFileError]
	push	esi
.error:
	VMMCall	_Trace_Out_Service
	jmp	short .return

.ErrorClose:
	push	esi
	call	.FileClose
	jmp	short .error
	
.FileClose:
	push	eax
	mov	eax,R0_CLOSEFILE
	VxDCall	IFSMgr_Ring0_FileIO
	pop	eax
	retn

.szBadImgError	db 'old or invalid image.',CRLF_0
.szBadVerError	db 'image is for another version of SoftICE.',CRLF_0
.szSizeError	db 'file is too large.',CRLF_0
.szBadInitError	db 'bad Init offset in update file.',CRLF_0

; Moved portion of the Dyn Update code
; be careful with it =)

%define UpdateOfs(o)	(UPDATE_CODE_ADDR + ((o) - UpdateMoved))

; EAX = hdr size, EBX = file handle, ECX = adjusted size, EDX = Init RVA
UpdateMoved:

	push	edx	; save Init RVA

; read patch data
; ECX already has the adjusted size
	lea	edx,[eax+PATCH_STATIC_SIZE]	; file ofs
	sub	ecx,PATCH_STATIC_SIZE		; size of data
	mov	eax,R0_READFILE
; buffer
	lea	esi,[ebp+PAGEIN_PATCH_ORIGIN+PATCH_STATIC_SIZE]
	VxDCall	IFSMgr_Ring0_FileIO
	jc	.FileErrorClose

; now do Init (again ;)
	pop	edx			; Init RVA
	add	edx,ebp			; get flat Init addr
	call	edx

.close:
	mov	eax,R0_CLOSEFILE
	VxDCall	IFSMgr_Ring0_FileIO

.return:
	popad
	retn				; client will return to an INT3

.FileErrorClose:
	pop	edx			; clean stack

	movzx	eax,ax
	lea	edx,[ebp+UpdateOfs(.szFileError)]
	push	edx
	VMMCall	_Trace_Out_Service
	jmp	short .close

.szFileError	db 'File I/O Error - #EAX', CRLF_0

.End:
