; for v3.22, v3.23, v3.24, v3.25, v4.00, v4.01
; some symbols to make the code more readable

%ifndef INCLUDED_ICEDUMP_INC
%define INCLUDED_ICEDUMP_INC

%define ICEDUMP_ID 'IDMP'

%define VERSION_TO_ASCII(v) '0'+((v) >> 8),'.','0'+(((v) >> 4) & 0xf),'0'+((v) & 0xf)

%ifndef WINICE_VERSION
%error please %define WINICE_VERSION
%endif

%if WINICE_VERSION = 0x322

	%assign PAGEIN_PATCH_ORIGIN 0xB7210

	INIT_CALL	EQU 0x000F6
	PAGEIN_CMDLINE	EQU 0x1DAE9
	PAGEIN_PARSER	EQU 0x1DAEE
	CRS_END		EQU 0x86206
	IGNOREFAULTS1	EQU 0x0755E
	IGNOREFAULTS2	EQU 0x07562
	PCI_VENDORS	EQU 0xB4898

	WINICE_DELTA	EQU 0x00005	; special Winice code/data segment base

	pSaveRegs	EQU 0x861F3
	pRestoreRegs	EQU 0x8628A

	%include "w9xice322.inc"

%elif WINICE_VERSION = 0x323

	%assign PAGEIN_PATCH_ORIGIN 0xBA4CC

	INIT_CALL	EQU 0x000F6
	PAGEIN_CMDLINE	EQU 0x1DF91
	PAGEIN_PARSER	EQU 0x1DF96
	CRS_END		EQU 0x895DE
	IGNOREFAULTS1	EQU 0x0761A
	IGNOREFAULTS2	EQU 0x0761E
	PCI_VENDORS	EQU 0xB7D80

	WINICE_DELTA	EQU 0x00005	; special Winice code/data segment base

	pSaveRegs	EQU 0x895CB
	pRestoreRegs	EQU 0x89662

	%include "w9xice323.inc"

%elif WINICE_VERSION = 0x324

	%assign PAGEIN_PATCH_ORIGIN 0xB8314

	INIT_CALL	EQU 0x000F6
	PAGEIN_CMDLINE	EQU 0x1DF65
	PAGEIN_PARSER	EQU 0x1DF6A
	CRS_END		EQU 0x87386
	IGNOREFAULTS1	EQU 0x0761A
	IGNOREFAULTS2	EQU 0x0761E
	PCI_VENDORS	EQU 0xB5BC8

	WINICE_DELTA	EQU 0x00005	; special Winice code/data segment base

	pSaveRegs	EQU 0x87373
	pRestoreRegs	EQU 0x8740A

	%include "w9xice324.inc"

%elif WINICE_VERSION = 0x325

	%assign PAGEIN_PATCH_ORIGIN 0xBB68C

	INIT_CALL	EQU 0x000F6
	PAGEIN_CMDLINE	EQU 0x1E2B4
	PAGEIN_PARSER	EQU 0x1E2B9
	CRS_END		EQU 0x89D0E
	IGNOREFAULTS1	EQU 0x07635
	IGNOREFAULTS2	EQU 0x07639
	PCI_VENDORS	EQU 0xB8F40

	WINICE_DELTA	EQU 0x00005	; special Winice code/data segment base

	pSaveRegs	EQU 0x89CFB
	pRestoreRegs	EQU 0x89D92

	%include "w9xice325.inc"

%elif WINICE_VERSION = 0x400

	%assign PAGEIN_PATCH_ORIGIN 0xC6C7C

	INIT_CALL	EQU 0x0ACE6
	PAGEIN_CMDLINE	EQU 0x295DB
	PAGEIN_PARSER	EQU 0x295E0
	CRS_END		EQU 0x952E2
	IGNOREFAULTS1	EQU 0x12271
	IGNOREFAULTS2	EQU 0x12275
	PCI_VENDORS	EQU 0xC4530

	WINICE_DELTA	EQU 0x0ABF5	; special Winice code/data segment base

	pSaveRegs	EQU 0x952CF
	pRestoreRegs	EQU 0x95366

	%include "w9xice400.inc"

%elif WINICE_VERSION = 0x401

	%assign PAGEIN_PATCH_ORIGIN 0xBBBCC

	INIT_CALL	EQU 0x00116
	PAGEIN_CMDLINE	EQU 0x1E5C6
	PAGEIN_PARSER	EQU 0x1E5CB
	CRS_END		EQU 0x8A232
	IGNOREFAULTS1	EQU 0x0761D
	IGNOREFAULTS2	EQU 0x07621
	PCI_VENDORS	EQU 0xB9480

	WINICE_DELTA	EQU 0x00025	; special Winice code/data segment base

	pSaveRegs	EQU 0x8A21F
	pRestoreRegs	EQU 0x8A2B6

	%include "w9xice401.inc"

%else
%error unsupported version: WINICE_VERSION
%endif

; common stuff

; Bhrama related stuff
WM_COPYDATA			EQU 0x004A
SYNCHRONIZE			EQU 0x00100000
STANDARD_RIGHTS_REQUIRED	EQU 0x000F0000
PROCESS_TERMINATE		EQU 0x0001
PROCESS_CREATE_THREAD		EQU 0x0002
PROCESS_VM_OPERATION		EQU 0x0008
PROCESS_VM_READ			EQU 0x0010
PROCESS_VM_WRITE		EQU 0x0020
PROCESS_DUP_HANDLE		EQU 0x0040
PROCESS_CREATE_PROCESS		EQU 0x0080
PROCESS_SET_QUOTA		EQU 0x0100
PROCESS_SET_INFORMATION		EQU 0x0200
PROCESS_QUERY_INFORMATION	EQU 0x0400
PROCESS_ALL_ACCESS        	EQU (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + 0x0FFF)

;GetCurrentProcessID	EQU 0x0
;FindWindowA		EQU 0x0
;SendMessageA		EQU 0x0

struc BhramaComStruc
.version	resd 1	; Internal Check (03h)
.PID		resd 1	; Target PID
.EIP		resd 1	; EntryPoint to Set after DUMP
.OptL1		resd 1	; Internal ProcDump Options Dword1
.OptL2		resd 1	; Internal ProcDump Options Dword2
.OptL3		resd 1	; Internal ProcDump Options Dword3
.OptL4		resd 1	; Internal ProcDump Options Dword4
.OptL5		resd 1	; Internal ProcDump Options Dword5
endstruc

;PMCB_SEG	EQU 'PMCS'
;PMCB_OFF	EQU 'PMCO'

;V86CB_SEG	EQU 'VMCS'
;V86CB_OFF	EQU 'VMCO'

R0_OPENCREATFILE	EQU 0xD500
R0_READFILE		EQU 0xD600
R0_WRITEFILE		EQU 0xD601
R0_CLOSEFILE		EQU 0xD700
R0_GETFILESIZE		EQU 0xD800

;SERVICE_VERSION	EQU 0x0000
SERVICE_DUMP		EQU 0x0001
SERVICE_LOAD		EQU 0x0002
SERVICE_SUSPEND		EQU 0x0003
SERVICE_SUSPENDX	EQU 0x0004
SERVICE_RESUME		EQU 0x0005
SERVICE_KILL		EQU 0x0006
SERVICE_CDPLAYER	EQU 0x0007
SERVICE_UPDATE		EQU 0x0008

%define	CRLF_0	13,10,0

; Client Register Structure as passed to V86/PM CallBacks
struc CRS
.EDI		resd 1		; 0
.ESI		resd 1		; 4
.EBP		resd 1		; 8
.res0		resd 1		; C
.EBX		resd 1		; 10
.EDX		resd 1		; 14
.ECX		resd 1		; 18
.EAX		resd 1		; 1C
.Error		resd 1		; 20
.EIP		resd 1		; 24
.CS		resw 1		; 28
.res1		resw 1		; 2C
.EFlags		resd 1		; 30
.ESP		resd 1		; 34
.SS		resw 1		; 38
.res2		resw 1
.ES		resw 1		; 3C
.res3		resw 1
.DS		resw 1		; 40		
.res4		resw 1
.FS		resw 1		; 44
.res5		resw 1
.GS		resw 1		; 48
.res6		resw 1
.Alt_EIP	resd 1		; 4C
.Alt_CS		resw 1		; 50
.res7		resw 1
.Alt_EFlags	resd 1
.Alt_ESP	resd 1
.Alt_SS		resw 1
.res8		resw 1
.Alt_ES		resw 1
.res9		resw 1
.Alt_DS		resw 1
.res10		resw 1
.Alt_FS		resw 1
.res11		resw 1
.Alt_GS		resw 1
.res12		resw 1
endstruc

; macros for stack allocation with proper alignment
%macro salloc 1
	sub	esp,((%1) + 3) & 0xFFFFFFFC
	mov	edi,esp
%endmacro

%macro sfree 1
	lea	esp,[esp + (((%1) + 3) & 0xFFFFFFFC)]
%endmacro

; size optimization macros
%macro movb 2
	%if (%2 > 127 || %2 < -128)
		%error immediate argument to MOVB does not fit in 1 byte
	%endif
	push	byte %2
	pop	%1
%endmacro

; MSCDEX structures
struc CdReq
.Len		resb 1	; length of hdr
.SubUnit	resb 1	; subunit code
.Cmd		resb 1	; command code
.Status		resw 1	; status
.Reserved	resb 8
endstruc

struc CdIoctlReq
.Len		resb 1	; length of hdr
.SubUnit	resb 1	; subunit code
.Cmd		resb 1	; command code
.Status		resw 1	; status
.Reserved	resb 8
.MediaDesc	resb 1	; media descriptor byte
.XferOfs	resw 1	; transfer addr offset part
.XferSeg	resw 1	; transfer addr segment part
.XferSize	resw 1	; transfer block size
.Sector		resw 1	; starting sector #
.VolumeId	resd 1	; DWORD ptr to requested vol ID if error 0FH
.CtrlCode:
endstruc

struc CdPlayReq
.AddrMode	resb 1	; addressing mode
.Sector		resd 1	; starting sector number
.Count		resd 1	; number of sectors to play
endstruc

struc CdDiskInfo
.Code		resb 1	; control block code
.TrackLo	resb 1	; lowest track #
.TrackHi	resb 1	; highest track #
.LeadOut	resd 1	; starting point of the lead-out track
endstruc

struc CdTrackInfo
.Code		resb 1	; control block code
.Track		resb 1	; track #
.Start		resd 1	; starting point of the track
.Ctrl		resb 1	; track control info
endstruc

struc IcedumpHdr
.ID		resd 1	; Icedump patch ID
.Len		resw 1	; header size
.PatchVer	resw 1	; Icedump patcher version
.Ver		resd 1	; Icedump version
.SiVer		resd 1	; target SoftIce version
.InitCall	resd 1	; RVA of Call to Init
.Org		resd 1	; Patch Origin (start of static data)
.Init		resd 1	; Init RVA (entry-point)
endstruc

struc FPU_Status_PM32
.Control	resw 1
.reserved1	resw 1

.StatusLo	resb 1
.StatusHi	resb 1
.reserved2	resw 1

.Tag		resw 1
.reserved3	resw 1

.oInstruction	resd 1

.sInstruction	resw 1
.OpCode		resw 1

.oOperand	resd 1

.sOperand	resw 1
.reserved4	resw 1
endstruc

struc FPU_STx
.ST0		rest 1
.ST1		rest 1
.ST2		rest 1
.ST3		rest 1
.ST4		rest 1
.ST5		rest 1
.ST6		rest 1
.ST7		rest 1
endstruc

%endif
