PatchData istruc IcedumpHdr
	at IcedumpHdr.ID,	dd ICEDUMP_ID		; speaks for itself
	at IcedumpHdr.Len,	dw PATCH_HEADER_SIZE	; header size
	at IcedumpHdr.PatchVer,	dw 1111h		; Icedump patcher version
	at IcedumpHdr.Ver,	dd ICEDUMP_BUILD	; Icedump version
	at IcedumpHdr.SiVer,	dd WINICE_VERSION	; target SoftICE version
	at IcedumpHdr.InitCall,	dd INIT_CALL		; RVA of Call to Init
	at IcedumpHdr.Org,	dd StaticData		; Patch Origin (start of static data)
	at IcedumpHdr.Init,	dd Init			; Init RVA (entry-point)
iend
; insert any extra data here
; i.e. Credits string
; but keep below 64k =)
	db 'IceDump ',VERSION_TO_ASCII(ICEDUMP_BUILD),' for SoftICE ',VERSION_TO_ASCII(WINICE_VERSION),0
.End:

PATCH_HEADER_SIZE EQU (PatchData.End - PatchData)
%assign PATCH_ORIGIN_ADJUSTED (PAGEIN_PATCH_ORIGIN - PATCH_HEADER_SIZE)

	ORG PATCH_ORIGIN_ADJUSTED

; non-updatable (static) part of the code

StaticData:
StaticV86CB:
	jmp	near Callback.entryV86CB
.JmpOfs	EQU	$-4
.Addr	dd 	0

StaticPMCB:
	jmp	near Callback.entryPMCB
.JmpOfs	EQU	$-4
.Addr	dd	0

%assign PATCH_STATIC_SIZE ($-StaticData)

; updatable part of code
Init:
	pushad
	call	.delta
.delta:
	pop	edx
	sub	edx,.delta		; edx has base of WINICE now

; c_PAGEIN calls parser and passes cmdline in ESI
	mov	byte  [edx+PAGEIN_CMDLINE],0xBE
	mov	dword [edx+PAGEIN_PARSER+1],Parser-PAGEIN_PARSER-5

; client registers saving inside c_PAGEIN_
	mov	byte  [edx+CRS_END],0xC3

; change page fault protected area
	lea	eax,[edx+Init]
	mov	[edx+IGNOREFAULTS1],eax
	lea	eax,[edx+End]
	mov	[edx+IGNOREFAULTS2],eax

; make PCI vendor name table empty
	or	dword [edx+PCI_VENDORS],byte -1

; reloc ProcDump's structure offset
	add	[edx+Procdump.DataPointer],edx

; allocate callbacks used to transition into ring-0
	; /fOSSiL/ Dynamic patch change
	mov	eax,[edx+StaticPMCB.Addr]
	or	eax,eax
	jnz	.gotPMCB		; already allocated

	lea	esi,[edx+StaticPMCB]
	VMMCall	Allocate_PM_Call_Back
	jnb	.gotPMCB

	xor	eax,eax			; oops...

.gotPMCB:
	mov	[edx+StaticPMCB.Addr],eax	; store the addr
	mov	[edx+StaticPMCB.JmpOfs],dword Callback.entryPMCB - StaticPMCB.Addr

	mov	eax,[edx+StaticV86CB.Addr]
	or	eax,eax
	jnz	.gotV86CB		; already allocated

	lea	esi,[edx+StaticV86CB]
	VMMCall	Allocate_V86_Call_Back
	jnb	.gotV86CB

	xor	eax,eax			; oops...

.gotV86CB:
	mov	[edx+StaticV86CB.Addr],eax	; store the addr
	mov	[edx+StaticV86CB.JmpOfs],dword Callback.entryV86CB - StaticV86CB.Addr


; redirect the INT1, INT3, INT4 and INT5 handlers so that checking for their
; offset differences would no longer work... of course this is going to start
; just another cat and mouse game ;-)
; code assumes that noone has tweaked winice's IDT entries yet
; real fool-proof code should check for 32 bit int/task gates

	pushfd
	cli
	cld

	; /fOSSiL/ Dynamic patch change
	mov	ecx,INT_HANDLER_MASK
	lea	edi,[edx+.OldHandlerTab]

	push	eax			; make space for IDTR
	sidt	[esp-2]			; (CIH's method)
	pop	esi			; get IDT base

.nextINT:
	mov	ebx,[edi]		; get oOldHandlerX offset
	or	ebx,ebx			; table is 0-terminated
	jz	.allINTsDone

	lodsd
	shl	eax,16
	lodsw
	lodsw
	ror	eax,16

	shr	ecx,1			; check if we redirect this INT
	jnc	.nextINT		; no bit shifted into CF

	sub	eax,edx
	sub	eax,ebx			; EBX: oOldHandlerX offset
	sub	eax,byte 4
	mov	[edx+ebx],eax

	mov	eax,[edi+INT_HANDLER_DELTA]	; get NewHandlerX offset
	add	eax,edx				; calc flat address

	mov	[esi-8],ax
	shr	eax,16
	mov	[esi-2],ax

	add	edi,byte 4
	jmp	.nextINT

.allINTsDone:
	popfd
	popad
	retn

; /fOSSiL/ Dynamic patch change

; we redirect ints 1,3,4,5 - set the corresponding bits
INT_HANDLER_MASK EQU 111010b	; Int vectors bitmask

; Handler address tables, 0-terminated
.OldHandlerTab: dd .oOldHandler_Int1, .oOldHandler_Int3, .oOldHandler_Int4, .oOldHandler_Int5, 0
.NewHandlerTab: dd .NewHandler_Int1, .NewHandler_Int3, .NewHandler_Int4, .NewHandler_Int5, 0
INT_HANDLER_DELTA EQU .NewHandlerTab - .OldHandlerTab

.NewHandler_Int1:
; for paranoids: insert here garbage but non-destructive code
	jmp	$
.oOldHandler_Int1	EQU $-4

; some space between the new handlers, change it as you see fit
TIMES 1 db 0

.NewHandler_Int3:
; for paranoids: insert here garbage but non-destructive code
	jmp	$
.oOldHandler_Int3	EQU $-4

; some space between the new handlers, change it as you see fit
TIMES 2 db 0

.NewHandler_Int4:
; for paranoids: insert here garbage but non-destructive code
	jmp	$
.oOldHandler_Int4	EQU $-4

; some space between the new handlers, change it as you see fit
TIMES 3 db 0

.NewHandler_Int5:
; for paranoids: insert here garbage but non-destructive code
	jmp	$
.oOldHandler_Int5	EQU $-4
