;-------------------------------------------------------------------------------
; this is the new PAGEIN parser that accepts the following syntax:
;
; PAGEIN D <address> [<length> <file name>]
; PAGEIN B <Bhrama window name>
; PAGEIN S <PID>|<TID>
; PAGEIN X <PID>|<TID>
; PAGEIN R <PID>|<TID>
; PAGEIN N [<file>]
; PAGEIN P <address> pPrWsUcC
; PAGEIN L <address> <length> <file name>
; PAGEIN E tT
; PAGEIN O (Execute command for help)
; PAGEIN F <FPU register number> <floating point value>
; PAGEIN C [<track>]
; PAGEIN U <file>
;-------------------------------------------------------------------------------

Parser:
	pushad

	call	.delta
.delta:
	pop	ebp
	sub	ebp,.delta

	call	pSaveRegs		; save the client registers
	call    pSkipWord		; skip over "PAGEIN"
	jb	near Parse_Help

	lodsb				; get subcommand
	and	al,0x5F			; upcase

; first check for commands that can live without parameters
	cmp	al,'N'
	jz	near Parse_ScreenDump

	cmp	al,'O'
	jz	near Parse_Option	; go to options submenu

	cmp	al,'C'
	jz	near Parse_CDPlayer

	call	pSkipWhiteSpace		; skip to real arguments
	jz	near Parse_Help

; now parse those that take at least one parameter
	cmp	al,'D'
	jz	near Parse_Dump

	cmp	al,'B'
	jz	near Parse_Bhrama

	cmp	al,'S'
	jz	near Parse_Suspend

	cmp	al,'X'
	jz	near Parse_SuspendX

	cmp	al,'R'
	jz	near Parse_Resume

;	cmp	al,'K'
;	jz	near Parse_Kill

	cmp	al,'P'
	jz	near Parse_PageFlag

	cmp	al,'L'
	jz	near Parse_Load

	cmp	al,'E'
	jz	near Parse_EFlags

	cmp	al,'F'
	jz	near Parse_FPU

	cmp	al,'U'
	jz	near Parse_Update

	jmp	Parse_Help

.errorMsg:
	mov	esi,edi
	call	pPrintToCommandWindow

.error:
	call	pRestoreRegs		; restore the client registers

.return:
	popad
	retn
