; /fOSSiL/ Dynamic patch change
; This is the cleanup code for dynamic patching
; we will restore Int vectors
Cleanup:
	pushad
	call	.delta
.delta:
	pop	edx
	sub	edx,.delta

	pushfd
	cli
	cld

	mov	ecx,INT_HANDLER_MASK
	lea	edi,[edx+Init.OldHandlerTab]

	push	eax		; make space for IDTR
	sidt	[esp-2]		; (CIH's method)
	pop	esi		; get IDT base

.nextINT:
	mov	ebx,[edi]	; get oOldHandlerX offset
	or	ebx,ebx		; table is 0-terminated
	jz	.allINTsDone

	lodsd
	lodsd
	shr	ecx, 1		; check if we redirect this INT
	jnc	.nextINT	; no bit shifted into CF

.restoreINT:
	lea	eax,[edx+ebx+4]	; calc flat vector addr
	add	eax,[edx+ebx]	; EBX: oOldHandlerX offset
	mov	[esi-8],ax
	shr	eax,16
	mov	[esi-2],ax

	add	edi,byte 4
	jmp	short .nextINT

.allINTsDone:
	popfd
	popad
	retn


GetAPIs:
	push	esi
	push	ecx
	push	eax

	xor	ecx,ecx

.loop:
	lea	eax,[ebp+8*ecx+API]
	cmp	dword [eax+4],byte 0
	jz	.success

	cmp	dword [eax],byte 0
	jnz	.next

	mov	esi,[eax+4]
	add	esi,ebp
	call	pExpression2Integer
	jb	near .error

	mov     [ebp+8*ecx+API],eax

.next:
	inc	ecx
	jmp	short .loop

.success:
	pop	eax
	pop	ecx
	pop	esi

	clc
	retn

.error:
	pop	eax
	pop	ecx
	pop	esi

	stc
	retn

	align 4
API:
.oGetCurrentProcessID:	dd 0
			dd .GetCurrentProcessID
.oFindWindowA:		dd 0
			dd .FindWindowA
.oSendMessageA:		dd 0
			dd .SendMessageA
.oOpenProcess:		dd 0
			dd .OpenProcess
.oResumeThread:		dd 0
			dd .ResumeThread
.oSuspendThread:	dd 0
			dd .SuspendThread
.oExitThread:		dd 0
			dd .ExitThread
;.oExitProcess:		dd 0
;			dd .ExitProcess
;.oTerminateThread	dd 0
;			dd .TerminateThread
;.oTerminateProcess	dd 0
;			dd .TerminateProcess

; null record, do not remove
			dd 0
			dd 0

.GetCurrentProcessID:	db 'GetCurrentProcessID',0
.FindWindowA:		db 'FindWindowA',0
.SendMessageA:		db 'SendMessageA',0
.OpenProcess:		db 'OpenProcess',0
.ResumeThread:		db 'ResumeThread',0
.SuspendThread:		db 'SuspendThread',0
.ExitThread:		db 'ExitThread',0
;.ExitProcess:		db 'ExitProcess',0
;.TerminateThread:	db 'TerminateThread',0
;.TerminateProcess:	db 'TerminateProcess',0


;------------------------------------------------------------------------------
; in: esi: winice base
;------------------------------------------------------------------------------
GetK32Info:
	push	eax
	push	ecx
	push	edi

; get the IDs first
	cmp	dword [esi+R3PID],byte 0
	jnz	.flags

	mov	ecx,64
	mov	edi,[esi+API.oOpenProcess]
	mov	al,0x38			; cmp byte [eax],PID

.1:
	repnz	scasb
	jecxz	.error

	cmp	byte [edi-2],0x80	; cmp byte [eax],PID
	jz	.1a

	cmp	byte [edi-2],0x83	; cmp dword [eax],PID
	jnz	.1

.1a:
	cmp	word [edi+3],0x576A	; push 0x57
	jnz	.1

	movzx	eax,byte [edi]
	mov	[esi+R3PID],eax
	inc	al
	mov	[esi+R3TID],eax

; get R3TCB.SuspendCount and R3TCB.Flags
.flags:
	cmp	dword [esi+R3TCB.Flags],byte 0
	jnz	.r0tcb

	mov	ecx,64
	mov	edi,[esi+API.oResumeThread]
	mov	al,0x8B			; mov eax,[edi+R3TCB.SuspendCount]

.2:
	repnz	scasb
	jecxz	.3

	cmp	byte [edi],0x87		; mov eax,[edi+R3TCB.SuspendCount]
	jnz	.2

	cmp	word [edi+5],0xC085	; test eax,eax
	jnz	.2

	push	dword [edi+1]
	pop	dword [esi+R3TCB.SuspendCount]

	movzx	eax,byte [edi+11]
	mov	[esi+R3TCB.Flags],eax
	jmp	short .5

.error:
	pop	edi
	pop	ecx
	pop	eax

	stc
	retn

.3:
	mov	ecx,64
	mov	edi,[esi+API.oResumeThread]
	mov	al,0x8D			; lea edi,[eax+R3TCB.SuspendCount]

.4:
	repnz	scasb
	jecxz	.error

	cmp	byte [edi],0xB8		; lea edi,[eax+R3TCB.SuspendCount]
	jnz	.4

	cmp	word [edi+5],0x0F8B	; mov ecx,[edi]
	jnz	.4

	push	dword [edi+1]
	pop	dword [esi+R3TCB.SuspendCount]

	movzx	eax,byte [edi+13]
	mov	[esi+R3TCB.Flags],eax
.5:

; get R3TCB.R0TCB, VWIN32_W32_SuspendThread and VWIN32_W32_ResumeThread
.r0tcb:
	cmp	dword [esi+R3TCB.R0TCB],byte 0
	jnz	.success

	mov	ecx,64
	mov	edi,[esi+API.oSuspendThread]
	mov	al,0x83			; cmp eax,0xFFFFFFFF

.6:
	repnz	scasb
	jecxz	.error

	cmp	word [edi],0xFFF8	; cmp eax,0xFFFFFFFF
	jnz	.6

	dec	edi
	mov	eax,[edi-4]		; get call's destination
	add	edi,eax

	mov	ecx,64
	mov	al,0x8B			; mov eax,[eax+R3TCB.R0TCB]

.7:
	repnz	scasb
	jecxz	.error

	cmp	byte [edi],0x40		; mov eax,[eax+R3TCB.R0TCB]
	jnz	.7

	cmp	word [edi+2],0xC085	; test eax,eax
	jnz	.7

	movzx	eax,byte [edi+1]
	mov	[esi+R3TCB.R0TCB],eax

	movzx	eax,word [edi+8]
	mov	[esi+VWIN32_W32_SuspendThread],eax

	inc	eax
	mov	[esi+VWIN32_W32_ResumeThread],eax

.success:
	pop	edi
	pop	ecx
	pop	eax

	clc
	retn

	align 4
VWIN32_W32_ResumeThread		dd 0
VWIN32_W32_SuspendThread	dd 0

R3PID:		dd 0
R3TID:		dd 0

R3TCB:
.Flags		dd 0
.R0TCB		dd 0
.SuspendCount	dd 0


;------------------------------------------------------------------------------
; ebp: winice base
; out: ok: clc, error: stc
;------------------------------------------------------------------------------
; set up client CS:EIP to one of our callbacks
;------------------------------------------------------------------------------
SetCB:
	push	eax
	push	ebx
	push	ecx

	mov	eax,jPAGEIN_INT3-WINICE_DELTA

; get CB address
	mov	ebx,[ebp+StaticV86CB.Addr]
	movzx	ecx,bx
	shr	ebx,16

	test	byte [ebp+dClient_EFLAGS+2],2	; is client in V86 mode?
	jz	.PM

	test	ebx,ebx			; is callback valid?
	jnz	.setCSEIP

.testEIP:
	jecxz	.error

.setCSEIP:
	mov	[ebp+dClient_CS],ebx	; set client CS
.setEIP:
	mov	[ebp+dClient_EIP],ecx	; set client (E)IP

	mov	[ebp+oPAGEIN_INT3],eax	; set address of final INT3

	pop	ecx
	pop	ebx
	pop	eax

	clc
	retn

.PM:
; get CB address
	mov	ebx,[ebp+StaticPMCB.Addr]
	movzx	ecx,bx
	shr	ebx,16

	test	byte [ebp+dClient_CS],3	; is client in ring-0?
	jnz	.testEIP		; is callback valid?

	lea	ecx,[ebp+Callback.entryPMR0]
	lea	eax,[ebp+jPAGEIN_INT3]
	jmp	short .setEIP

.error:
	pop	ecx
	pop	ebx
	pop	eax

	stc
	retn


;------------------------------------------------------------------------------
; in:  EAX: page number,
; out: ZF set on error, cleared otherwise
; ------------------------------------------------------------------------------
; the following piece of code directly accesses the page tables and directories
; to figure out if a specific page has been committed or not. credits go to
; LiuTaoTao for the short code to calculate the offsets into the tables.
; ------------------------------------------------------------------------------
IsPageCommitted:
	push	edi
	push	edx
	mov	edi,0xFF800000		; linear start address of page tables
	lea	edx,[edi+4*eax]		; EAX: current page number
	shr	edx,12			; EDX: current directory number
	test	byte [edi+4*edx],0x1	; is page directory present?
	jz	.1
	test	byte [edi+4*eax+1],0x2	; is page committed?
.1:
	pop	edx
	pop	edi
	retn

;------------------------------------------------------------------------------
; global error messages (used at more than one place)
;------------------------------------------------------------------------------
Error_V86	db 'EFLAGS.VM=1, only win32 clients are supported.',0
Error_PM16	db 'CS.D=0, only win32 clients are supported.',0
Error_PMR0	db 'CS.DPL=0, only win32 clients are supported.',0
Error_API	db 'unable to resolve some win32 APIs, check winice.dat.',0
Error_NoID	db 'specify PID/TID.',0
