; for v3.22, v3.23, v3.24, v3.25, v4.00, v4.01
; some symbols to make the code more readable

%ifndef INCLUDED_ICEDUMP_INC
%define INCLUDED_ICEDUMP_INC

%define NTICEDUMP_VERSION 5

%define NTICEDUMP_ID 'IDMP'

%define VERSION_TO_ASCII(v) '0'+((v) >> 8),'.','0'+(((v) >> 4) & 0xf),'0'+((v) & 0xf)

%ifndef NTICE_VERSION
%error please %define NTICE_VERSION
%endif


%if NTICE_VERSION = 0x322

	%assign PAGEIN_PATCH_ORIGIN 0xE3C14

	PAGEIN_CMDLINE	EQU 0x1F124
	PAGEIN_PARSER	EQU 0x1F129

	dIGNOREFAULTS1	EQU 0x8E583
	dIGNOREFAULTS2	EQU 0x8E587

	PCI_VENDORS	EQU 0x60388

	CRS_END		EQU 0x37AE9

	pNticeInit	EQU 0x3AE8D
	pSaveRegs	EQU 0x37AD6
	pRestoreRegs	EQU 0x37B6D

	%include "ntice322.inc"

%elif NTICE_VERSION = 0x323

	%assign PAGEIN_PATCH_ORIGIN 0xE9F8C

	PAGEIN_CMDLINE	EQU 0x1F6A0
	PAGEIN_PARSER	EQU 0x1F6A5

	dIGNOREFAULTS1	EQU 0x90AAB
	dIGNOREFAULTS2	EQU 0x90AAF

	PCI_VENDORS	EQU 0x62D28

	CRS_END		EQU 0x38529

	pNticeInit	EQU 0x3B91B
	pSaveRegs	EQU 0x38516
	pRestoreRegs	EQU 0x385AD

	%include "ntice323.inc"

%elif NTICE_VERSION = 0x324

	%assign PAGEIN_PATCH_ORIGIN 0xE87E4

	PAGEIN_CMDLINE	EQU 0x1F6E0
	PAGEIN_PARSER	EQU 0x1F6E5

	dIGNOREFAULTS1	EQU 0x90B8B
	dIGNOREFAULTS2	EQU 0x90B8F

	PCI_VENDORS	EQU 0x62E50

	CRS_END		EQU 0x38631

	pNticeInit	EQU 0xF2BA0
	pSaveRegs	EQU 0x3861E
	pRestoreRegs	EQU 0x386B5

	%include "ntice324.inc"

%elif NTICE_VERSION = 0x325

	%assign PAGEIN_PATCH_ORIGIN 0xF8624

	PAGEIN_CMDLINE	EQU 0x1F6CB
	PAGEIN_PARSER	EQU 0x1F6D0

	dIGNOREFAULTS1	EQU 0x9DC8E
	dIGNOREFAULTS2	EQU 0x9DC92

	PCI_VENDORS	EQU 0x66C90

	CRS_END		EQU 0x3868D

	pNticeInit	EQU 0x102E20
	pSaveRegs	EQU 0x3867A
	pRestoreRegs	EQU 0x38711

	%include "ntice325.inc"

%elif NTICE_VERSION = 0x400

	%assign PAGEIN_PATCH_ORIGIN 0x1209F8

	PAGEIN_CMDLINE	EQU 0x203F7
	PAGEIN_PARSER	EQU 0x203FC

	dIGNOREFAULTS1	EQU 0xBD502
	dIGNOREFAULTS2	EQU 0xBD506

	PCI_VENDORS	EQU 0x74408

	CRS_END		EQU 0x394FD

	pNticeInit	EQU 0x12BE40
	pSaveRegs	EQU 0x394EA
	pRestoreRegs	EQU 0x39581

	%include "ntice400.inc"

%elif NTICE_VERSION = 0x401

	%assign PAGEIN_PATCH_ORIGIN 0x120A58

	PAGEIN_CMDLINE	EQU 0x20427
	PAGEIN_PARSER	EQU 0x2042C

	dIGNOREFAULTS1	EQU 0xBD562
	dIGNOREFAULTS2	EQU 0xBD566

	PCI_VENDORS	EQU 0x74458

	CRS_END		EQU 0x39541

	pNticeInit	EQU 0x12BEA0
	pSaveRegs	EQU 0x3952E
	pRestoreRegs	EQU 0x395C5

	%include "ntice401.inc"

%else
%error unsupported version: NTICE_VERSION
%endif


; Client Register Structure as passed to debug services ... Not NT standard
struc CRS
Client_EDI	resd 1		; 0
Client_ESI	resd 1		; 4
Client_EBP	resd 1		; 8
Client_res0	resd 1		; C
Client_EBX	resd 1		; 10
Client_EDX	resd 1		; 14
Client_ECX	resd 1		; 18
Client_EAX	resd 1		; 1C
Client_Error	resd 1		; 20
Client_EIP	resd 1		; 24
Client_CS	resw 1		; 28
Client_res1	resw 1		; 2C
Client_EFlags	resd 1		; 30
Client_ESP	resd 1		; 34
Client_SS	resw 1		; 38
Client_res2	resw 1
Client_ES	resw 1		; 3C
Client_res3	resw 1
Client_DS	resw 1		; 40
Client_res4	resw 1
Client_FS	resw 1		; 44
Client_res5	resw 1
Client_GS	resw 1		; 48
Client_res6	resw 1
Client_Alt_EIP	resd 1		; 4C
Client_Alt_CS	resw 1		; 50
Client_res7	resw 1
Client_Alt_EFlags	resd 1
Client_Alt_ESP	resd 1
Client_Alt_SS	resw 1
Client_res8	resw 1
Client_Alt_ES	resw 1
Client_res9	resw 1
Client_Alt_DS	resw 1
Client_res10	resw 1
Client_Alt_FS	resw 1
Client_res11	resw 1
Client_Alt_GS	resw 1
Client_res12	resw 1
endstruc

struc NTIcedumpHdr
.ID		resd 1	; nticedump patch ID
.Len		resw 1	; header size
.PatchVer	resw 1	; nticedump patcher version
.Ver		resd 1	; nticedump version
.SiVer		resd 1	; target SoftIce version
.VA     	resd 1	; RVA of Call to Init
endstruc

%define		ZwCreateFile			0*4
%define		ZwWriteFile			1*4
%define		ZwClose				2*4
%define		RtlAnsiStringToUnicodeString	3*4
%define		RtlInitAnsiString		4*4
%define		DbgPrint			5*4
%define		RtlFreeUnicodeString		6*4
%define		MmIsAddressValid		7*4
%define		ZwSetInformationFile		8*4
%define		KeAttachProcess			9*4
%define		KeDetachProcess			0xA*4

%define		MaxImportId		0xB

%define		NtSuspendThread		5
%define		NtResumeThread		6

%define		Srv_Version	0
%define		Srv_Dump	1
%define		Srv_Suspend	2
%define		Srv_Resume	3
%define		Srv_Bhrama	4
%define		Srv_DumpX	5
%define		MaxSrv		6

%define		CRLF_0			13,10,0

%endif
