%include "ntice.inc"
%include "ntddk.inc"

	BITS    32

NTICEDUMP_BUILD EQU 0x0004

PatchData istruc NTIcedumpHdr
	at NTIcedumpHdr.ID,		dd NTICEDUMP_ID		; speaks for itself
	at NTIcedumpHdr.Len,		dw PATCH_HEADER_SIZE	; header size
	at NTIcedumpHdr.PatchVer,	dw 0100h		; nticedump patcher version
	at NTIcedumpHdr.Ver,		dd NTICEDUMP_BUILD	; nticedump version
	at NTIcedumpHdr.SiVer,		dd NTICE_VERSION	; target SoftICE version
	at NTIcedumpHdr.VA,		dd Init      		; RVA of Call to Init
iend
; insert any extra data here
; i.e. Credits string
; but keep below 64k =)
	db 'IceDump ',VERSION_TO_ASCII(NTICEDUMP_BUILD),' for NTICE ',VERSION_TO_ASCII(NTICE_VERSION),0
.End:

PATCH_HEADER_SIZE EQU (PatchData.End - PatchData)
%assign PATCH_ORIGIN_ADJUSTED (PAGEIN_PATCH_ORIGIN - PATCH_HEADER_SIZE)


	ORG PATCH_ORIGIN_ADJUSTED

;-------------------------------------------------------------------------------
; Init will be called by NT. Takes 2 DWORDS as params. This call is
; responsible with the debug extension vector init, as well as "normal"
; NTICE initialization. It will replace original DriverEntry. The PE entry
; point will be set to point to this routine.
;-------------------------------------------------------------------------------
Init:
	push	dword [esp+8]		; push pRegistryPath
	push	dword [esp+8]		; push pDriverObject
	call	pNticeInit		; call NticeDeviceInit
	test	eax, eax		; EAX = STATUS_SUCCESS ?
	jl	near .return		; nope, branch error

	pushad				; save'em all

	call	.delta
.delta:
	pop	ebp			; EBP: Current Address
	sub	ebp, .delta		; 

.fixups:
	mov	ecx, MaxSrv		; initialize loop count
	lea	edi, [ebp+tInternalApiTable]	; EDI: pointer to internal API table

.next_service:
	add	dword [edi], ebp	; perform fixup
	add	edi, byte 4		; advance to next slot
	loop	.next_service		; more API's ?

.get_ntoskrnl_ptrs:
	lea	edi, [ebp+CallTable]	; EBX: pointer to Call Table
	lea	esi, [ebp+tImportNameTable]	; ESI: pointer to API Names
	mov	ecx, MaxImportId	; intialize loop count

.next_api:
	call	pExpression2Integer	; return EAX: API virtual address
	jb	.exit			; Fail extension commands initialization on error

	stosd				; store API pointer in Call table
	inc	esi			; step to next string
	loop	.next_api

.apply_patches:
	mov	ebx, cr0		; EBX: CR0
	push	ebx			; save it for later use
	btr	ebx, 16			; Clear Write Protect bit
	mov	cr0, ebx

	mov	byte  [ebp+CRS_END], 0xC3	; patch retn
	mov	byte  [ebp+PAGEIN_CMDLINE], 0xBE	; patch mov esi, imm32
	mov	dword [ebp+PAGEIN_PARSER+1], Parser - PAGEIN_PARSER - 5
	mov	dword [ebp+PCI_VENDORS], -1
	lea	eax,  [ebp+Init]
	mov	dword [ebp+dIGNOREFAULTS1], eax	; let ntoskrnl
	lea	eax,  [ebp+End]			; handle faults
	mov	dword [ebp+dIGNOREFAULTS2], eax	; in this range
	pop	ebx
	mov	cr0, ebx			;revert CR0 to normal state

.hook_idt:
	mov	dl, 0x60			; Interrupt Gate DPL = 3
	lea	edi, [ebp+Icall_handler]	; handler EIP = Icall_handler
	mov	eax, 0xFF			; target vector 0xFF
	call	pHookInt_IDT			; Hook IDT

.exit:
	popad					; restore all registers

.return:
	retn	8 ; return to OS (__stdcall always assumed for DriverEntry )


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------

Parser:
	pushad
	call	.delta
.delta:
	pop	ebp                                     ;
	sub	ebp, .delta

	call	pSaveRegs		; save client State
	call	pSkipWord		; skip over PAGEIN
	jb	Parse_Help

	lodsb
	and	al, 0x5F		; toupper
	cmp	al, 'D'
	jz	near Parse_Dump

	cmp	al, 'S'
	jz	Parse_Suspend

	cmp	al, 'R'
	jz	Parse_Resume

	cmp	al, 'B'
	jz	Parse_Bhrama

	jmp	short Parse_Help

.error:
	push	ebx
	call	pPrintErrorToCommandWindow

.exit:
	call	pRestoreRegs		; restore client state
	popad
	retn

Parse_Help:
	lea	ebx, [ebp+help_d]
	push	ebx
	call	pPrintErrorToCommandWindow

	lea	ebx, [ebp+help_s]
	push	ebx
	call	pPrintErrorToCommandWindow

	lea	ebx, [ebp+help_r]
	push	ebx
	call	pPrintErrorToCommandWindow

	lea	ebx, [ebp+help_v]
	push	ebx
	call	pPrintErrorToCommandWindow

	jmp	short Parser.exit

Parse_Suspend:
	mov	dword [ebp+dClient_EAX], Srv_Suspend
	lea	ebx, [ebp+nim_err]

Parse_Resume:
	lea	ebx , [ebp+nim_err]
	mov	dword [ebp+dClient_EAX], Srv_Resume

Parse_Bhrama:
	lea	ebx , [ebp+nim_err]
	mov	dword [ebp+dClient_EAX], Srv_Bhrama
	jmp	short Parser.error


Parse_Dump:
	call	pSkipWhiteSpace
	jz	.set_pth_mode

	lea	ebx, [ebp+evl_err]
	call	pExpression2Integer	; Parse address
	jb	near Parser.error

	mov	[ebp+dClient_EDI], eax	; store address in Client_EDI
	mov	dword [ebp+dClient_EAX], Srv_Dump	; srv code goes in EAX
	call	pSkipWhiteSpace
	jz	.emulate		; emulate old PAGEIN behaviour

	call	pExpression2Integer	; Parse Length
	jb	near Parser.error

	call	pSkipWhiteSpace		; advance to filename
	jnz	.cont			; ESI: pointer to file name

	jmp	Parser.exit

.set_pth_mode:
	mov	al, [ebp+.PathMode]
	xor	al, 1
	mov	[ebp+.PathMode], al
	lea	ebx, [ebp+msg_p0]
	jnz	.on

	lea	ebx, [ebp+msg_p1]
.on:
	jmp	Parser.error

.emulate:
	xor	eax, eax		; Zero length
	xor	esi, esi		; No file name
	jmp	.exprt_mode

.cont:
	cmp	byte [ebp+.PathMode], 1
	jz	.exprt_mode
	sub	esi, 4
	mov	dword [esi], '\??\'

.exprt_mode:
	mov	[ebp+dClient_ESI], esi	; pointer to filename
	mov	[ebp+dClient_ECX], eax	; store length
	call	CanResume		; are we allowed to play the game ?

.set_eip:
	test	dword [ebp+dClient_CS], 3	; ring-0 Client ?
	jz	.ring0

	mov	edi, [ebp+dClient_ESP]		; EDI: Client ESP
	mov	ecx, EntryPoint.end - EntryPoint; number of bytes to copy
	push	ecx
	lea	eax, [ebp+EntryPoint]		; EAX: source
	push	eax
	sub	edi, ecx			; EDI destination ( on client Stack )
	push	edi
	lea	ebx, [ebp+stk_err]
	call	pMemcopy			; memcpy with protection from faults  
	test	eax, eax
	jz	near Parser.error

	mov	ebx, edi			; EBX: new EIP
	lea	eax, [edi+2]			; EAX: INT3 location
	mov	[ebp+dClient_ESP], edi		; adjust client stack  
	jmp	.setup

.ring0:
	lea	eax, [ebp+EntryPoint.i3]	; INT3 location for ring-0 code
	lea	ebx, [ebp+EntryPoint]		; Get EIP

.setup:
	mov	[ebp+oPAGEIN_INT3], eax		; register INT3 location
	mov	[ebp+dClient_EIP], ebx		; set new client EIP
	xor	eax, eax
	inc	eax
	mov	[ebp+fPAGEIN_InProgress], eax	; set PAGEIN internal var
	mov	[ebp+fExecuteMoreCommands], ah	; leave ntice	
	popad
	ret

.PathMode	db 1


;-------------------------------------------------------------------------------
; Check if we are allowed to tweak client execution. In case of error, it
; will NOT return to the caller.
;-------------------------------------------------------------------------------
CanResume:
	call	pGetIRQLLevel		; Get current IRQL level
	lea	ebx, [ebp+irq_err]
	cmp	eax, 2			; IRQL > Dispatch_Level ?
	jnb	.error

	lea	ebx, [ebp+pge_err]
	cmp	byte [ebp+fClientMode], 3	; 32 bit client
	jnz	.error				; nope, bye

	lea	ebx, [ebp+int_err]
	test	byte [ebp+dClient_EFLAGS+1], 2	; interrupts enabled
	jz	.error				; nope, bye

	lea	ebx, [ebp+ctx_err]
	mov	eax, [ebp+dCurrentContext]
	cmp	eax, [ebp+dPopupContext]
	jnz	.error

	ret

.error:
	pop	eax		; Remove return address from stack
	jmp	Parser.error	; and branch command parser exit
				; That's it, return to NTICE, 
				; nothing to be done


;------------------------------------------------------------------------------------ 
EntryPoint:
	int	0xFF		; Initiate an extension call
.i3:
	int3			; Break back in NTICE
.end:

Icall_handler:
	ExceptionFrame2KeTrapFrameLite		HW_ERROR_CODE_OFF 
	call	.delta
.delta:
	pop	esi             		
	sub	esi, .delta                    	;

	mov	[ebp+KeTrapFrame.EAX], esi	; Save it in the trap frame
	add	esi, tInternalApiTable		; ESI: ptr to extension routines table
	sti             				
	call	[esi+eax*4]			; call requested service
	cli
	KeTrapFrame2ExceptionFrameLite		HW_ERROR_CODE_ON	
	iretd

;-------------------------------------------------------------------------------
SrvVer:
	ret

;-------------------------------------------------------------------------------
SrvDump:
	push	ebp				; save trape frame ptr		
	sub	esp, 8+8+24+8+4
	mov	ebp, esp
	mov	eax, [ebp+52]			; EAX : trape frame ptr
	mov	esi, [eax+KeTrapFrame.EAX]	; 
	lea	edi, [esi+CallTable]		; EDI: ntoskrnl import table	
	cmp	dword [eax+KeTrapFrame.ESI], 0	; Do we have a filename ptr ?
	jz	near .emulate			; If no , emulate old PAGEIN 
						; [ebp+52] == Trap frame ptr
						; [ebp+48] == FileHandle			      
						; EBP+40 == IoStatusBlock	                               
						; EBP+16 == Object Attributes
						; EBP+8  == AnsiString
						; EBP == UnicodeString		

	lea	eax, [ebp+16]			; get ptr to Object Attributes
	InitializeObjectAttributes  ebp , dword 0x40 , dword 0 , dword 0
	mov	eax, [ebp+52]			; EAX: ptr Trap frame
	push	dword [eax+KeTrapFrame.ESI]
	lea	eax, [ebp+8]			; OUT PANSI_STRING	
	push	eax
	call	[edi+RtlInitAnsiString]

	push	byte 1				; Allocate Destination String Buffer
	lea	eax, [ebp+8]			; IN PANSI_STRING
	push	eax
	push	ebp				; OUT PUNICODE_STRING
	call	[edi+RtlAnsiStringToUnicodeString]

	push	byte 0
	push	byte 0
	push	dword 0x850			       
	push	byte 5				; FILE_SUPERSEED
	push	byte 0				; no sharing
	push	dword 0x80			; FILE_ATTRIBUTE_NORMAL
	push	byte 0				; allocation size 0
	lea	eax, [ebp+40]			; EAX: PIO_STATUS_BLOCK
	push	eax
	lea	eax, [ebp+16]			; EAX: POBJECT_ATTRIBUTES
	push	eax
	push	dword 0x120116			; Desired Access
	lea	eax, [ebp+48]			; ptr File Handle
	push	eax
	lea	ebx, [esi+opn_err]
	call	[edi+ZwCreateFile]	
	test	eax, eax
	jl	.free_string

	push	byte 0				; No KEY
	push	byte 0				; Null File Offset
	mov	eax, [ebp+52]
	push	dword [eax+KeTrapFrame.ECX]	; Length
	push	dword [eax+KeTrapFrame.EDI]	; buffer address
	lea	eax, [ebp+40]			; PIO_STATUS_BLOCK
	push	eax
	push	byte 0				; null APC context 
	push	byte 0				; no APC
	push	byte 0				; no completion Event
	push	dword [ebp+48]			; File handle
	lea	ebx, [esi+wrt_err]
	call	[edi+ZwWriteFile]
	test	eax, eax
	jl	.free_close

	push	ebp
	call	[edi+RtlFreeUnicodeString]	; Free temp unicode storage space

	push	dword [ebp+48]
	call	[edi+ZwClose]			; Close the file
	jmp	short .return

.emulate:
	lea	ebx, [esi+npr_err]
	mov	esi, [ebp+52]			; ESI = ptr trap frame
	mov	esi, [esi+KeTrapFrame.EDI]	; ESI: pagein address    
	push	esi
	call	[edi+MmIsAddressValid]		; check if it is a valid address
	test	al, al
	jz	.error

	mov	eax, [esi]			; touch the page and bring it in

.return:
	add	esp, 8+8+24+8+4
	pop	ebp
	retn					; return to Icall_Handler

.free_close:
	push	dword [ebp+48]
	call	[edi+ZwClose]

.free_string:
	push	ebp
	call	[edi+RtlFreeUnicodeString]

.error:
	push	ebx				; EBX: ptr to error msg
	call	[edi+DbgPrint]			; print error msg 	
	pop	eax				; DbgPrint follows C calling convention
	jmp	short .return

;-------------------------------------------------------------------------------
SrvDumpX:
	
	ret

;-------------------------------------------------------------------------------
SrvSr:
	ret

;-------------------------------------------------------------------------------
SrvBhr:
	ret

;------------------------------------------------------------------------------
; The following call will be assembled only if target NTICE version is 322,
; which does not have a pGetIrqlLevel in the form we expect. This call can be
; guaranteed as safe only in NT 4.0, since it relies on the hardcoded value of
; KPCR base
; TRASHES EDI & EAX !

%if 	NTICE_VERSION = 0x322

pGetIRQLLevel:
	mov	edi, KPCRSelfPointer+KPCR.Irql
	call	pMOV_AL_EDI_safe
	movzx	eax, al
	retn

%endif

	align 4

tImportNameTable: 
	db 'ZwCreateFile',0
	db 'ZwWriteFile',0
	db 'ZwClose',0
	db 'RtlAnsiStringToUnicodeString',0
	db 'RtlInitAnsiString',0
	db 'DbgPrint',0
	db 'RtlFreeUnicodeString',0
	db 'MmIsAddressValid',0
	db 'ZwSetInformationFile',0
	db 'KeAttachProcess',0
	db 'KeDetachProcess',0

tKernel32NameTable:	  

CallTable:	TIMES MaxImportId     dd      'SRVC'

tInternalApiTable:
	dd      SrvVer                     ;0 - version
	dd      SrvDump                    ;1 - dump
	dd      SrvSr                      ;2 - suspend
	dd      SrvSr                      ;3 - resume
	dd	SrvBhr			   ;4 - bhrama
	dd	SrvDumpX		   ;5 - extended dump


;-------------------------------------------------------------------------------
; flag variables
;-------------------------------------------------------------------------------

; Flag variables are currently unavailable. The coder may be busy or off-line. 
; Try again later. Thank you !
			

;-------------------------------------------------------------------------------
; Error strings
;-------------------------------------------------------------------------------
int_err	db 'Interrupts must be enabled to use this extension.',0
irq_err	db 'IRQL must be below DISPATCH_LEVEL to use this extension.',0
stk_err	db 'Cannot use this extension because current thread`s stack is not present.',0
pge_err	db 'Paging is supported only in 32 bit modes.',0
ctx_err	db 'Cannot dump from this context. Revert to pop-up context.',0
arg_err	db 'Arguments required.',0
evl_err	db 'Cannot evaluate expression.',0
prc_err	db 'Cannot attach an invalid process. Check KPEB parameter.',0
opn_err	db 'Failed to create output file. Possible reason: wrong path name.',CRLF_0
wrt_err	db 'Failed to dump requested data. Possible reason: invalid memory range.',CRLF_0
npr_err	db 'Page at specified address is either Reserved or Not Committed.',CRLF_0
msg_p0	db 'Path Expert mode is now on',0
msg_p1	db 'Path Expert mode is now off',0
nim_err	db 'Command currently not implemented.',0


;-------------------------------------------------------------------------------
; Help strings
;-------------------------------------------------------------------------------
help_d	db 'PAGEIN D <address> [ <length> [<process>] <filename> ]',0
help_d1	db 'PAGEIN D',0
help_s	db 'PAGEIN S <KTEB>',0
help_r	db 'PAGEIN R <KTEB>',0
help_b	db 'PAGEIN B <Bhrama window name>',0
help_v	db 'nticedump Beta 1 build 0004  http://icedump.tsx.org.',0

End:
