#!/usr/bin/perl
#
# This Is Purl. Get With It.
#
# Title: Map2Map
# Purpose: Convert IDA Ouput MAP files into A format usable by msym.exe
# Use: "perl map2map.pl file.map > output.map", new file will be dumped to file
# Coding Time: 50 minutes
# Version: 0.2
# Elegence Score: Don't even Ask
#
# Coded By Gij
# 15/Jun/98

 if ( $#ARGV == -1 ) {
	print "\nGij's Map2Map\n";
	print "_-_-_-_-_-_-_\n\n";
	print "Use: perl map2map.pl file.map [-kill:str1,str2,strn]/[-minimal]\n\n";
	print "-kill: kills any symbol containing the specified string,\n";
	print "       Preceede With '^', to kill only symbols STARTING with that\n";
	print "       String.\n";
	print "       Append '\$', to kill only symbols that END with that string.\n";
        print "       Basicly, you can use an RE to eliminate labels by name. \n\n";
	print "-minimal: Kills All symbols starting with dword,word,byte,loc,sub,unk\n";

	exit;
 }

 foreach $_ (@ARGV) {
	if ( /-minimal/i ) {
		push @kill_list,"dword","word","loc","sub_","off","unk","byte";
	}
	elsif ( /-kill/i ) {
		@_=split(/[,:]/);
		@_= @_[ 1 .. $#_ ];
		push @kill_list,@_;
	}
 }

 open FH,$ARGV[0];  


 while ( <FH> ) {
	 if ( ! /^$/ ) {
		last;
	 }
 }

 
 if( ! /(\w+)\s+(\w+)\s+(\w+)\s+\w+\s+(\w+)/i ) {
	print "Error: Unkown File Format\n";
	exit;
 }
 else {
 	print " $1 $2 $3 $4\n\n";
 }


 while ( <FH> ) {
	 if ( ! /^$/ ) {
		last;
	 }
 }


 while ( ! eof FH ) {
        if ( /^$/ ) {	
		last;
 	}

	if( /([\dabcdef]+)H\s+[\dabcdef]+H\s+([\dabcdef]+)H\s+([\w\.]+)\s+(\w*)/i ) {
	print " $1 $2 $3 $4\n";
	}	
	$_ = <FH>;
 } 

 print "\n\n";

 while ( <FH> ) {
	 if ( ! /^$/ ) {
		last;
	 }
 }

 if( /(\w+)\s+(\w+)\s+(\w+)\s+(\w+)/i ) {
 	print " $1 $2 $3 $4\n\n";

 }
 else {
	print "Can't find start of publics\n";
	exit;
 }

 while ( <FH> ) {
	 if ( ! /^$/ ) {
		last;
	 }
 }

 while ( ! eof FH ) {
	if ( /^$/ ) {	
		last;
 	}

	if( /([\dabcdef]+)\:([\dabcdef]+)\s+(.+)/i ) {
		$temp_sym_name = $3;
		foreach $pat ( @kill_list ) {
			if ( $temp_sym_name =~ /$pat/i ) {
				goto READ_LINE;  		# argh, a goto, blorght'll kill me :)
			}
		}
	
		printf " %04x:%08x\t%s\n",hex $1,hex $2,$3;
	}
	else {
		print "Error: Where Are the Symbols?\n";
		exit;
	}

READ_LINE:
	$_ = <FH>;
 } 

 while ( <FH> ) {
	 if ( ! /^$/ ) {
		last;
	 }
 }

 print "\n";
 print;

 while ( ! eof FH ) {
	print;
	$_ = <FH>;
 } 




