unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ExtCtrls,d32lib;

type
  Tpatchform = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Edit1: TEdit;
    Panel3: TPanel;
    Edit2: TEdit;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Panel4: TPanel;
    Edit3: TEdit;
    GroupBox1: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  patchform: Tpatchform;
  
implementation

uses Unit1;

{$R *.DFM}

procedure Tpatchform.FormClose(Sender: TObject; var Action: TCloseAction);
begin
radiobutton1.enabled:=false;
radiobutton2.enabled:=false;
radiobutton3.enabled:=false;
form1.enabled:=true;
edit1.SetFocus;
end;

procedure Tpatchform.SpeedButton2Click(Sender: TObject);
begin
if editing then editing:=false;
close;
end;

procedure Tpatchform.SpeedButton1Click(Sender: TObject);
begin
// make sure that the entered numbers are fine
if not ishexnum(edit1.text) then
  begin
  mb('The Patch VA is an invalid hex number !',':(',mb_iconerror);
  exit;
  end;
if not ishexnum(edit2.text) then
  begin
  mb('The Patch Bytes are an invalid hex number !',':(',mb_iconerror);
  exit;
  end;
if not ishexnum(edit3.text) then
  begin
  mb('The Original Bytes are an invalid hex number !',':(',mb_iconerror);
  exit;
  end;
checknum:=length(edit2.text)/2; // check whether the patch bytes are even
if frac(checknum) <> 0 then
  begin
  mb('The digits of the Patch Bytes must be an EVEN number !','!!!',mb_iconerror);
  exit;
  end;
checknum:=length(edit3.text)/2; // check whether the original bytes are even
if frac(checknum) <> 0 then
  begin
  mb('The digits of the Original Bytes must be an EVEN number !','!!!',mb_iconerror);
  exit;
  end;
if length(edit2.text) <> length(edit3.text) then // check the length
  begin
  mb('The number of Original Bytes must be equal to the number of Patch Bytes !','!!!',mb_iconerror);
  exit;
  end;
// write the values in the listview
if editing then
  begin
  form1.listview1.items[currsel].subitems[0]:=edit1.text; // don't create a new item
  form1.listview1.items[currsel].subitems[1]:=edit3.text;
  form1.listview1.items[currsel].subitems[2]:=edit2.text;
  editing:=false;
  end
  else
  begin
  // create a new item
  if radiobutton1.checked then
    newitem:=form1.listview1.Items.Insert(currsel);
  if radiobutton2.checked then
    newitem:=form1.listview1.items.insert(currsel+1);
  if radiobutton3.checked then
    newitem:=form1.listview1.items.add;
  newitem.caption:='Patch';
  newitem.subitems.add(edit1.text);
  newitem.subitems.add(edit3.text);
  newitem.subitems.add(edit2.text);
  end;
close;
end;

procedure Tpatchform.FormShow(Sender: TObject);
begin
// setup the add postion
if not editing then
  begin
  radiobutton3.checked:=true;
  radiobutton3.enabled:=true;
  if form1.listview1.selcount > 0 then
    begin
    radiobutton1.enabled:=true;
    if currsel < form1.listview1.Items.Count-1 then radiobutton2.enabled:=true;
    end;
  end;
end;

end.
