unit Unit6;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Gauges, ExtCtrls, StdCtrls, Buttons,d32lib,pelib, ComCtrls;

type
  Tcompareform = class(TForm)
    Panel1: TPanel;
    Gauge1: TGauge;
    OpenDialog1: TOpenDialog;
    Edit1: TEdit;
    Edit2: TEdit;
    Panel2: TPanel;
    Panel3: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  compareform: Tcompareform;

implementation

uses Unit1;

{$R *.DFM}

function offset2va( tmp : dword ):dword;
var thesection       : byte;
    i                : byte;
begin
if tmp < peh.OptionalHeader.SizeOfHeaders then // it's in the Header
  begin
  result:=tmp+peh.OptionalHeader.ImageBase;
  exit;
  end;
// it's in any section...I hope
sectionh2:=PIMAGE_SECTION_HEADER(peh);
inc(pimage_nt_headers(sectionh2));
inc(sectionh2);
// in which section is tmp ?
thesection:=1;
for i:=2 to peh.FileHeader.NumberOfSections do
  begin
  if (tmp >= sectionh2.PointerToRawData) then thesection:=i;
  inc(sectionh2);
  end;
// calculate the VA
sectionh2:=PIMAGE_SECTION_HEADER(peh);
inc(pimage_nt_headers(sectionh2));
for i:=1 to thesection-1 do
  inc(sectionh2);
tmpnum:=sectionh2.VirtualAddress-sectionh2.PointerToRawData;
result:=tmp+tmpnum+peh.OptionalHeader.ImageBase;
end;

procedure Tcompareform.FormShow(Sender: TObject);
begin
edit1.text:='';
edit2.text:='';
gauge1.progress:=0;
form1.enabled:=false;
end;

procedure Tcompareform.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
form1.enabled:=true;
end;

procedure Tcompareform.SpeedButton2Click(Sender: TObject);
begin
close;
end;

procedure Tcompareform.SpeedButton3Click(Sender: TObject);
begin
opendialog1.filename:='';
opendialog1.Title:='Choose the Original File...';
if opendialog1.execute then
  edit1.text:=opendialog1.FileName;
end;

procedure Tcompareform.SpeedButton4Click(Sender: TObject);
begin
opendialog1.filename:='';
opendialog1.Title:='Choose the Modified File...';
if opendialog1.execute then
  edit2.text:=opendialog1.FileName;
end;

procedure Tcompareform.SpeedButton1Click(Sender: TObject);
var orgf,crkf    : TMemoryStream;
    porgb,pcrkb  : ^byte;
    orgb,crkb    : byte;
    position     : longint;
    base         : dword;
    changes      : longint;
begin
if edit1.text = edit2.text then
  begin
  mb('Please choose 2 different files !','!!!',mb_iconerror);
  exit;
  end;
// load the files into the memory and check a bit around them
orgf:=tmemorystream.create;
crkf:=tmemorystream.create;
orgf.LoadFromFile(edit1.text);
crkf.loadfromfile(edit2.text);
if orgf.Size <> crkf.Size then
  begin
  mb('Sorry...different filesizes aren''t supported !',':(',mb_iconerror);
  orgf.free;
  crkf.free;
  exit;
  end;
if (orgf.size = 0) then
  begin
  mb('Please don''t choose any files with a filesize of 0 !','!!!',mb_iconerror);
  orgf.free;
  crkf.free;
  exit;
  end;
// get the image base and the section header values (offset2va)
dosh := PIMAGE_DOS_HEADER(orgf.memory);
peh:= PIMAGE_NT_HEADERS(Longword(dosh) + Longword(dosh.e_lfanew));
if (dosh.e_magic <> image_dos_signature) or (peh.Signature <> image_NT_signature) then
  begin
  mb('The File Compare dos only support PE files !','!!!',mb_iconerror);
  orgf.free;
  crkf.free;
  exit;
  end;
sectionh:=PIMAGE_SECTION_HEADER(peh);
// let's have some pointer action
porgb:=orgf.Memory;
pcrkb:=crkf.memory;
gauge1.MaxValue:=orgf.size;
// the gauge makes the search routine very slow but it looks cooler !
application.processmessages;
// go through the whole file
changes:=0;
for position:=0 to orgf.size do
  begin
  orgb:=porgb^;
  crkb:=pcrkb^;
  if orgb <> crkb then
    begin
    newitem:=form1.listview1.items.add;
    newitem.caption:='Patch';
    newitem.subitems.add(inttohex(offset2va(position),8));
    newitem.subitems.add(inttohex(orgb,2));
    newitem.subitems.add(inttohex(crkb,2));
    inc(changes);
    if changes = maxpatchbytesnum then
      begin
      mb('Oh !!...The Number of Patches is limited to 500 !'#13+
         'The compare progress was aborted.',':(',mb_iconerror);
      orgf.free;
      crkf.free;
      application.processmessages;
      close;
      exit;
      end;
    end;
  inc(porgb);
  inc(pcrkb);
  gauge1.Progress:=position;//...faster :P
  end;
// clean up
orgf.free;
crkf.free;
application.processmessages;
close;
end;

end.
