unit Unit8;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons,d32lib;

type
  Tsrform = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Edit1: TEdit;
    Edit2: TEdit;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    GroupBox1: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    CheckBox1: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  srform: Tsrform;

implementation

uses Unit1;

{$R *.DFM}

procedure Tsrform.FormShow(Sender: TObject);
begin
form1.enabled:=false;
// setup the add postion
if not editing then
  begin
  radiobutton3.checked:=true;
  radiobutton3.enabled:=true;
  if form1.listview1.selcount > 0 then
    begin
    radiobutton1.enabled:=true;
    if currsel < form1.listview1.Items.Count-1 then radiobutton2.enabled:=true;
    end;
  end;
end;

procedure Tsrform.FormClose(Sender: TObject; var Action: TCloseAction);
begin
form1.enabled:=true;
radiobutton1.enabled:=false;
radiobutton2.enabled:=false;
radiobutton3.enabled:=false;
checkbox1.checked:=false;
edit1.text:='';
edit2.text:='';
edit1.SetFocus;
end;

procedure Tsrform.SpeedButton2Click(Sender: TObject);
begin
close;
end;

procedure Tsrform.SpeedButton1Click(Sender: TObject);
begin
// check the entered numbers
if length(edit1.text) <> length(edit2.text) then
  begin
  mb('The Number of Search Bytes must be equal to the number of Replace Bytes !',':(',mb_iconerror);
  exit;
  end;
if not ishexnum(edit1.text) then
  begin
  mb('The Search Bytes are an invalid hex number !',':(',mb_iconerror);
  exit;
  end;
if not ishexnum(edit2.text) then
  begin
  mb('The Replace Bytes are an invalid hex number !',':(',mb_iconerror);
  exit;
  end;
checknum:=length(edit1.text)/2;
if frac(checknum) <> 0 then
  begin
  mb('The digits of the Search Bytes must be an EVEN number !','!!!',mb_iconerror);
  exit;
  end;
checknum:=length(edit2.text)/2;
if frac(checknum) <> 0 then
  begin
  mb('The digits of the Replace Bytes must be an EVEN number !','!!!',mb_iconerror);
  exit;
  end;
// update the listview
if editing then
  begin  // don't create a new item
  if checkbox1.checked then
   form1.listview1.items[currsel].Caption:='Search & Replace (A)'
  else
   form1.listview1.items[currsel].caption:='Search & Replace (F)';
  form1.listview1.items[currsel].subitems[1]:=edit1.text;
  form1.listview1.items[currsel].subitems[2]:=edit2.text;
  editing:=false;
  end
  else
  begin
  // create a new item
  if radiobutton1.checked then
    newitem:=form1.listview1.Items.Insert(currsel);
  if radiobutton2.checked then
    newitem:=form1.listview1.items.insert(currsel+1);
  if radiobutton3.checked then
    newitem:=form1.listview1.items.add;
  if checkbox1.checked then
   newitem.caption:='Search & Replace (A)'
  else
   newitem.caption:='Search & Replace (F)';
  newitem.subitems.add('');
  newitem.subitems.add(edit1.text);
  newitem.subitems.add(edit2.text);
  end;
close;
end;

end.
