unit d32lib;

interface

uses windows;

const yodastamp : dword   = $61646f79;

function mb(MessageBoxtext:string;MessageBoxcaption:string;Messageboxattributes:integer=0) : integer;
// calculate the screen middle
function getmiddleX(winwidth:integer) :integer;
function getmiddleY(winheight:integer):integer;
// get the filesize
function getfsize(PathtoFile : string) : DWORD;
// anti exception
function ishexnum(targetnumber : string) : boolean;

implementation

function mb(MessageBoxtext:string;MessageBoxcaption:string;Messageboxattributes:integer=0) : integer;
begin
result:=Messagebox(0,pchar(MessageBoxtext),pchar(MessageBoxcaption),Messageboxattributes);
end;

function getmiddleX(winwidth:integer):integer;
var topx    : integer;
    middlex : real;
begin
topx:=getsystemmetrics(SM_CXSCREEN);
middlex:=(topx-255)/2;
topx:=round(middlex);
result:=topx;
end;

function getmiddleY(winheight:integer):integer;
var topy    : integer;
    middley : real;
begin
topy:=getsystemmetrics(sm_cyscreen);
middley:=(topy-winheight)/2;
topy:=round(middley);
result:=topy;
end;

function getfsize(PathtoFile : string) : DWORD;
var fileh : THandle;
begin
result:=$FFFFFFFF;
fileh:=createfile(pchar(pathtofile),GENERIC_read,FILE_SHARE_READ,nil,OPEN_EXISTING,0,0);
result:=getfilesize(fileh,nil);
closehandle(fileh);
end;

function ishexnum(targetnumber : string) : boolean;
var i          :   longint;
    tmpstring  :   string;
begin
result:=false;
if targetnumber='' then exit;
tmpstring:=targetnumber; // upcase the string without uppercase
targetnumber:='';
for i:=1 to length(tmpstring) do
  targetnumber:=targetnumber+upcase(tmpstring[i]);
// start the test
for i:=1 to length(targetnumber) do
  if ((targetnumber[i] < '0') or (targetnumber[i] > '9')) and ((targetnumber[i] < 'A') or (targetnumber[i] > 'F' ))
    then exit;
result:=true;
end;

end.

