	.586
	.model flat,stdcall

	includelib	e:\dev\masm\lib\kernel32.lib
	includelib	e:\dev\masm\lib\user32.lib
	includelib	e:\dev\masm\lib\comdlg32.lib
	includelib	e:\dev\masm\lib\comctl32.lib

	include		e:\dev\masm\include\kernel32.inc
	include		e:\dev\masm\include\user32.inc
	include		e:\dev\masm\include\comdlg32.inc
	include		e:\dev\masm\include\comctl32.inc
	include		e:\dev\masm\include\windows.inc

	IDD_DIALOG1	equ 103
	IDC_TEXTABOUT	equ 301

	IDC_SAVENAME	equ 104
	IDC_FILE	equ 103
	IDC_PLAYER	equ 105
	IDC_CASH	equ 106
	IDC_CAR		equ 107
	IDC_PLACE	equ 108
	IDC_SAVE	equ 123
	IDC_OPENSAVE	equ 124

	IDC_STATUS1	equ 140
	IDC_PROGRESS	equ 170

	IDI_ICON1	equ 999
.data
;
	lpOfn			label	byte
	ofn_lStructSize		dd	cbOfn ;number of bytes
	ofnhWndOwner		dd	0
	ofnhInstance		dd	0			;dialog box template id
	ofn_lpstrFilter		dd	offset szFilter		;filter strings
	ofn_lpstrCustomFilter	dd	0			;user-defined filter stings
	ofn_nMaxCustFilter	dd	0			;size of custom filter buffer
	ofn_nFilterIndex	dd	0			;index into the filter buffer
	ofn_lpstrFile		dd	offset lpFilename	;default file name buffer
	ofn_nMaxFile		dd	255			;size of the file name buffer
	ofn_lpstrFileTitle	dd	0			;file title buffer
	ofn_nMaxFileTitle	dd	0			;size of the file title buffer
	ofn_lpstrInitialDir	dd	0			;initial directory
	ofn_lpstrTitle		dd	offset szTitle		;dialog box title
	ofn_Flags		dd	4			;dialog box creation flags
	ofn_nFileOffset		dw	0			;file name offset in lpstrFile
	ofn_nFileExtension	dw	0			;file ext offset in lpstrFile
	ofn_lpstrDefExt		dd	0			;default extension
	ofn_lCustData		dd	0			;application-defined hook data
	ofn_lpfnHook		dd	0			;hook function
	ofn_lpTemplateName	dd	0			;dialog box template name
	cbOfn			equ $-lpOfn

	szTitle		db 'Open savegame',0

	szInvalidFile	db 'Invalid savegame format(size should be 948 bytes)!',0
	szCannotOpen	db 'Cannot open savegame!',0
	szException	db 'Internal error occured!',0
	szCaption	db '*CARMAGEDDON*',0
	szFilter	db 'SaveX(save?)',0
	lpKey		db 'save?',0,0
	lKey		equ $-lpKey-1

.data?
	hInst		dd ?
	lpFilename	db 255 dup(?)
	lpKeyData	db 3B4h dup(?)
	lKeyData	equ 3B4h
	hFile		dd ?
	hMap		dd ?
	lpMap		dd ?
.code
_start:
	push	0
	call	GetModuleHandleA	; module base
	mov	hInst, eax		; save it

	sub	edx,edx

	push	edx			; lParam WM_INITDIALOG
	push	offset DlgProc		; dialog proc
	push	edx			; parent handle
	push	IDD_DIALOG1		; ID
	push	eax			; module base
	call	DialogBoxParamA
_exit:
	push	-1
	call	ExitProcess		; exit

PUBLIC DlgProc
DlgProc proc STDCALL uses ebx edi esi, hWnd:DWORD, wmsg:DWORD, _wparam:DWORD, _lparam:DWORD

	movzx	eax,word ptr [wmsg]

	cmp	ax,WM_COMMAND
	je	_wmcommand
	cmp	ax,WM_INITDIALOG
	je	_initdlg
	cmp	ax,WM_DESTROY
	je	_wmdestroy
	cmp	ax,WM_CLOSE
	je	_wmdestroy

	sub	eax,eax
	ret				; message loop, return 0
_wmdestroy:
	push	0			; return 0
	push	hWnd			; dialog handle
	call	EndDialog		; close dialog box
	ret				; jmp _exit

_wmcommand:
	cmp	word ptr[_wparam],IDC_OPENSAVE
	je	_open_file

	cmp	word ptr[_wparam],IDC_SAVE
	je	_save_key
	
	cmp	word ptr[_wparam],2
	je	_wmdestroy

	ret
_open_file:
	push	hWnd
	pop	dword ptr[ofnhWndOwner]

	push	offset lpOfn		; adres struktury openfile
	call	GetOpenFileNameA
	test	eax,eax
	jne	_set_text

	push	0
	push	IDC_FILE
	push	hWnd
	call	SetDlgItemTextA
	ret
_set_text:
	push	offset lpFilename
	push	IDC_FILE
	push	hWnd
	call	SetDlgItemTextA

	sub	eax,eax
	push	eax
	push	FILE_ATTRIBUTE_NORMAL
	push	OPEN_EXISTING		; action
	push	eax
	push	eax
	push	GENERIC_READ + GENERIC_WRITE; access type
	push	offset lpFilename	; pointer to filename
	call	CreateFileA
	
	inc	eax
	je	_open_err
	dec	eax

	mov	hFile,eax
	push	eax

	push	0
	push	eax			; file handle
	call	GetFileSize

	pop	edx
	cmp	eax,3B4h
	jne	_invalid_file_format
	xchg	eax,ecx

	sub	eax,eax
	push	eax
	push	ecx			; low size+vs  
	push	eax			; high size   
	push	PAGE_READWRITE		; read&write  
	push	eax
	push	edx			; file handle
	call	CreateFileMappingA
	mov	hMap,eax

	sub	edx,edx

	push	edx			; # of bytes, 0= map entire file
	push	edx			; file offset low
	push	edx			; file offset high
	push	FILE_MAP_WRITE		; access flags - read&write
	push	eax
	call	MapViewOfFile

	mov	lpMap,eax


	xchg	eax,edi


	push	edi
	push	IDC_SAVENAME
	push	hWnd
	call	SetDlgItemTextA

	lea	eax,[edi+10h]
	push	eax
	push	IDC_CAR
	push	hWnd
	call	SetDlgItemTextA

	lea	eax,[edi+20h]
	push	eax
	push	IDC_PLAYER
	push	hWnd
	call	SetDlgItemTextA
	
	mov	eax,dword ptr[edi+28Ch]
	bswap	eax

	push	0
	push	eax
	push	IDC_CASH
	push	hWnd
	call	SetDlgItemInt

	push	0
	movzx	eax,byte ptr[edi+293h]
	push	eax
	push	IDC_PLACE
	push	hWnd
	call	SetDlgItemInt

	push	edi
	call	crc


	
	jmp	_return

_invalid_file_format:
	mov	eax,offset szInvalidFile
	jmp	_show

_open_err:
	mov	eax,offset szCannotOpen
_show:
	push	10h
	push	offset szCaption
	push	eax
	push	hWnd
	call	MessageBoxA
_return:	
	ret

_save_key:
	push	255
	push	offset lpFilename
	push	IDC_FILE
	push	hWnd
	call	GetDlgItemTextA
	test	eax,eax
	je	_no_file_selected


	mov	edi,lpMap

	push	0Fh			; save name
	push	edi
	push	IDC_SAVENAME
	push	hWnd
	call	GetDlgItemTextA

	lea	eax,[edi+10h]		; car
	push	0Fh
	push	eax
	push	IDC_CAR
	push	hWnd
	call	GetDlgItemTextA

	lea	eax,[edi+20h]		; player name
	push	0Fh
	push	eax
	push	IDC_PLAYER
	push	hWnd
	call	GetDlgItemTextA

	push	0
	push	0
	push	IDC_CASH
	push	hWnd
	call	GetDlgItemInt

;	and	eax,00FFFFFFh
;	mov	edx,eax
;	shl	eax,16
;	shr	edx,8
;	mov	al,dh
;	mov	ah,dl
;	and	eax,00FFFFFFh
	bswap	eax
	mov	dword ptr[edi+28Ch],eax	; cash

	push	0
	push	0
	push	IDC_PLACE
	push	hWnd
	call	GetDlgItemInt

	mov	byte ptr[edi+293h],al	; place

	push	edi
	call	crc

	mov	dword ptr[edi+3B0h],eax	; zapisz sume crc
	
	push	lpMap
	call	UnmapViewOfFile

	push	hMap
	call	CloseHandle

	push	hFile
	call	CloseHandle

_no_file_selected:
	ret

_initdlg:
	push	IDI_ICON1
	push	hInst
	call	LoadIconA

	push	eax
	push	1
	push	WM_SETICON
	push	hWnd
	call	SendMessageA

	push	offset szCaption
	push	hWnd
	call	SetWindowTextA

	ret
DlgProc	endp

; suma kontrolna nie jest wyliczana z oryginalnie wczytanego pliku
; tylko po malych przerobkach, ale plik save musi byc zapisany w
; formacie bez przerobek po bswap, czyli przed wyliczeniem sumy
; od offsetu 28Ch zmieniana jest kolejnosc bajtow, potem liczona
; jest suma, po czym znowu zamieniamy kolejnoscia bajty a sume
; crc zapisujemy pod 3B0h czyli ostatni DWORD pliku savegame

crc proc near
	pop	eax
	pop	edx
	push	eax

	push	edx
	call	correct

	push	edx

	sub	ebx,ebx			; inicjalizacja rejestrow
	sub	ecx,ecx			; pomocniczych
	sub	eax,eax			;
_next_byte:
	mov	cl,byte ptr[edx]	; kolejne bajty z savegame
	xor	cl,0BDh			;
	and	ecx,000000FFh		; zostaw tylko low byte
	add	ecx,eax
	mov	esi,ecx
	inc	edx
	shl	esi,19h
	shr	ecx,07h
	xor	eax,esi
	inc	ebx
	xor	eax,ecx
	cmp	ebx,3B0h		; sprawdz czy doszlismy do konca
	jb	_next_byte		; bufora

	call	correct

	ret
crc	endp

correct	proc near
	pop	ecx
	pop	edx
	push	ecx

	push	edx
	add	edx,28Ch

	push	73
	pop	ecx
endians_xchg:
	mov	ebx,dword ptr[edx+ecx*4-4]
	bswap	ebx			; dlaczego bswap mozna uzywac tylko do
					; xchg na reg32???
	mov	dword ptr[edx+ecx*4-4],ebx
	loop	endians_xchg

	pop	edx
	ret
correct	endp


end _start