;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; na wejsciu:									;
; st(0)		- liczba zmiennoprzecinkowa ktora bedzie konwertowana do hex	;
; ecx		- liczba cyfr po przecinku ktore beda uwzglednione		;
; na wyjsciu:									;
; eax		- calosci z liczby zmiennoprzcinkowej				;
; edx		- reszta od przecinka do ecx					;
; ograniczenia:									;
; przedzial DWORDa ze wzgledu na zastosowanie eax i edx				;
; zasmiecone rejestry:								;
; eax i edx gdzie jest zapisany wynik						;
; reszta pozostaje nienaruszona							;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

float2hex	proc near
	finit					; zainicjalizuj jednostke kooprocesora
	push	ax
	fstcw	word ptr [esp]			; status word
	pop	ax				; ax status word

	push	ax				; orginalne ustawienia statusu

	or	ax, 0000110000000000b		; obcinaj ale nie przyblizaj(thnx Ptasiek)

	;Status Register:
	;   ___________________________________________________________
	;  |___|___|___________|___|___|___|___|___|___|___|___|___|___|
	;    B   C3     TOP      C2  C1  C0  ES  SF  PE  UE  OE  ZE  IE 
	;    
	;  B     - FPU Busy
	;  C0-C3 - Condition Codes
	;  TOP   - Top of Stack Pointer
	;  ES    - Error Summary Status
	;  SF    - Stack Fault
	;  PE    - Precision Exception
	;  UE    - Underflow Exception
	;  OE    - Overflow Exception
	;  ZE    - Zero Divide Exception
	;  DE    - Denormailzed Operand Exception
	;  IE    - Invalid Operation Exception

	push	ax				; stos
	fldcw	word ptr [esp]			; status word
	pop	ax

	fldz					; zaladuj zero
	fxch					; xchg st(0),st(1)
	fadd	st(1),st(0)			; st(0)=st(1)
	
	frndint					; obcinaj reszte
	push	eax
	fist	dword ptr [esp]			; zapisz calosci
	pop	eax

	fsubp	st(1),st(0)

	jecxz	_skip_2nd_part

	push	10
	fild	dword ptr [esp]
	fild	dword ptr [esp]

	dec	ecx				; licznik
_repeat:
	fmul	st, st(1)
	loop	_repeat
	fxch
	fistp	dword ptr [esp]
	pop	edx

	fmulp					; mul&pop
_skip_2nd_part:
	frndint
	push	edx
	fistp	dword ptr [esp]			; zapisz reszte z liczby zmiennoprzecinkowej
	pop	edx
	fldcw	word ptr [esp]			; zaladuj orginalny ustawienia statusu
	add	esp,2				; nie zasmieca innych rejestrow

	ret
float2hex	endp
