	.386
	.model flat,stdcall
	locals
	jumps

	PAGE_READONLY			equ	2
	PAGE_READWRITE			equ	4     
	PAGE_WRITECOPY			equ	8     
	SECTION_QUERY			equ	1
	SECTION_MAP_WRITE		equ	2
	SECTION_MAP_READ		equ	4
	SECTION_MAP_EXECUTE		equ	8
	SECTION_MAP_EXTEND_SIZE		equ	10
	FILE_MAP_COPY			equ	SECTION_QUERY
	FILE_MAP_WRITE			equ	SECTION_MAP_WRITE
	FILE_MAP_READ			equ	SECTION_MAP_READ

	FILE_ATTRIBUTE_NORMAL		equ	080h
	OPEN_EXISTING			equ	3
	GENERIC_READ			equ	80000000h
	GENERIC_WRITE			equ	40000000h
	FILE_SHARE_READ			equ	0001h

	FILE_ATTRIBUTE_ARCHIVE		equ	00000020h

	callW	macro api
	extrn	api:proc
	call	api
	endm

	_junk	macro prefix
	jmp	$+4
	db	prefix
	db	NOT prefix+1
	endm

;DEBUG	equ	1
.data
	db	0
.code
_start:

;-file-attribs---------------------------------------------------------------------------------
	push	offset filename
	callW	GetFileAttributesA

	push	eax

clearattrib:
	push	FILE_ATTRIBUTE_ARCHIVE
	push	offset filename
	callW	SetFileAttributesA

open:
	sub	eax,eax
	push	eax
	push	FILE_ATTRIBUTE_NORMAL
	push	OPEN_EXISTING
	push	eax
	push	eax
	push	GENERIC_READ + GENERIC_WRITE
	push	offset filename
	callW	CreateFileA

	push	eax			; store file handle

;-get-file-size--------------------------------------------------------------------------------
	push	0
	push	eax			; file handle
	callW	GetFileSize

;-create-file-mapping--------------------------------------------------------------------------
_map:	sub	edx,edx
	pop	ecx
	push	ecx

	push	edx
	push	eax			; lSize
	push	edx			; hSize
	push	PAGE_READWRITE		; read&write  
	push	edx                            
	push	ecx
	callW	CreateFileMappingA

	push	eax

	sub	edx,edx

	push	edx			; map entire file
	push	edx
	push	edx
	push	FILE_MAP_WRITE		; read&write access
	push	eax
	callW	MapViewOfFile
	push	eax

	xchg	eax,edx
;-patching-------------------------------------------------------------------------------------
	IFDEF	DEBUG
	int	3
	ENDIF
	lea	edi,[edx+lpAddr1]
	mov	esi,offset _jmper
	mov	ecx,_jmperlen
	rep	movsb

	lea	edi,[edx+lpAddr2]
	mov	esi,offset _patch
	mov	ecx,_patchlen
	rep	movsb

;-close-file-----------------------------------------------------------------------------------
_close:
	callW	UnmapViewOfFile		; params already pushed
	callW	CloseHandle
;-restore-file-time-and-attribs----------------------------------------------------------------
	callW	CloseHandle

	push	offset filename
	callW	SetFileAttributesA
_no_error:
	push	-1
	callW	ExitProcess

;
;	ASPACK code:
;	popad			; restore ALL regs
;	jne	@return_to_host
;	mov	eax,000001h	; this code seems to be never
;	ret	0Ch		; executed
;@return_to_host:
;	push	offset lpRealEntrypoint
;	ret
_jmper:
	mov	eax,43D630h
	call	eax
	popad
	db	3 dup(90h)	; nop padding
_jmperlen	equ $-_jmper

_patch:
;	int 3			; for tests only
@2:
	call	_delta
_delta:	pop	ebp
	sub	ebp,offset _delta

	mov	ecx,_tablen	; liczba patchow
	lea	esi,[ebp+_table]; esi wsakzuje na tabele z offsetami patchow(VirtualAddress)
_apply_patch:
	lodsd			; zaladuj VA kolejnego patch-a
	xchg	eax,edi		; do edi
	lodsb			; bajt ktory wstawiamy
	stosb			; zapisz bajt pod zadany VA
	loop	_apply_patch	; powtorz

	lea	eax,[ebp+aq_102]
	push	eax
	mov	eax,43EF78h	; adres GetModuleHandle
	call	dword ptr[eax]

	lea	edx,[ebp+InitFile]
	push	edx
	push	eax
	mov	eax,43EF70h
	call	dword ptr[eax]

	lea	edi,[eax+0C4h]	; edi offset patcha
	lea	esi,[ebp+patch_data]
	db	6Ah		; push byte
	db	patch_len	; rozmiar
	pop	ecx
	rep	movsb		; uaktualnij patcha

	ret			; powroc
aq_102		db	'AQ32_102.DLL',0
InitFile	db	'InitFile',0

patch_data	db	2Bh,0DBh	; sub	ebx,ebx
		db	90h,90h		; 2xnop
		db	0C6h,45h,0FBh,0	; mov	byte ptr[ebp-5],0
		db	90h,90h		; 2xnop
		db	0C6h,45h,0FAh,0	; mov	byte ptr[ebp-6],0
		db	0EBh,48h	; jmp
patch_len	equ	$-patch_data


; table_entry struc
; patch_offset	dd ?
; patch_byte	db ?
; ends

_table:
	dd	4381C8h
	db	90h		; 82h >> 90h

	dd	437E30h
	db	90h		; 82h >> 90h

_tablen	equ ($-_table)/5	; DWORD+BYTE
_patchlen	equ $-_patch
@2l	equ	$-@2
;


_patcher_data:
filename	db 'examine.exe',0

lpAddr1		equ 1D4F1h
lpAddr2		equ 1CE30h


end _start