	.386p
	model flat,stdcall
	locals
	jumps

	UNICODE=0
	include e:\dev\tasm\import\w32s.inc

	IDD_DIALOG1	equ 103
	IDC_NAME	equ 105
	IDC_SERIAL	equ 106

	IDC_ABOUT	equ 322

	IDC_LOAD	equ 120
	IDC_TERMINATE	equ 121
	IDC_EXIT	equ 123
	IDC_STATUS	equ 107

	IDI_ICON1	equ 999

	extrn	GetCurrentThreadId		:proc
	extrn	SetWindowsHookExA		:proc
	extrn	CallNextHookEx			:proc
	extrn	IsCharAlphaNumericA		:proc
	extrn	GetSystemMenu			:proc
	extrn	InsertMenuA			:proc
	extrn	CreateMutexA			:proc

	WH_KEYBOARD			equ 2
	VK_ESCAPE			equ 1Bh
	VK_SHIFT                        equ 10h

	;DEBUG		equ TEST
	DECRYPT		equ YEP

	_clear	macro	what,size
	pushad
	mov	edi,offset what
	mov	ecx,size
	sub	eax,eax
	rep	stosb
	popad
	endm


	_junk	macro prefix
	jmp	$+4
	db	prefix
	db	NOT prefix+1
	endm

.data
	db 0
.code
_start:
	sub	eax,eax
	push	offset _handler
	push	dword ptr fs:[eax]
	mov	dword ptr[@old_esp],esp
	mov	fs:[eax],esp		; SEH frame

	push	offset szMutext
	push	eax
	push	eax
	call	CreateMutexA
	call	GetLastError
	cmp	eax,ERROR_ALREADY_EXISTS
	je	_exit

	call	InitCommonControls

	push	offset szKernel32
	call	LoadLibraryA

	push	offset szDebugBreak
	push	eax
	call	GetProcAddress

	mov	dword ptr[lpDebugBreak],eax

	call	GetCurrentThreadId

	push	eax
	push	0
	push	offset khandler
	push	WH_KEYBOARD
	call	SetWindowsHookExA

	push	PAGE_READWRITE
	push	MEM_RESERVE or MEM_COMMIT
	push	lSerial
	push	0
	call	VirtualAlloc

	mov	lpSerial,eax

	push	ecx
	call	GetModuleHandle  	; module base
	mov	_hInst, eax		; store it

	sub	edx,edx

	push	edx
	push	offset DlgProc		; dialog procedure
	push	edx			
	push	IDD_DIALOG1
	push	eax
	call	DialogBoxParamA
_exit:
	pop	dword ptr fs:[0]
	pop	eax

;	push	MEM_DECOMMIT
;	push	lSerial
;	push	lpSerial
;	call	VirtualFree

;	push	-1
;	call	ExitProcess		; exit

	push	-1
	call	ExitThread

PUBLIC DlgProc
DlgProc proc STDCALL, _hWnd:DWORD, wmsg:DWORD, _wparam:DWORD, _lparam:DWORD
	uses  ebx, edi, esi

	movzx	eax, word ptr [wmsg]

	cmp	ax,WM_DESTROY
	je	_wmdestroy
	cmp	ax,WM_CLOSE
	je	_wmdestroy
	cmp	ax,WM_COMMAND
	je	_wmcommand
	cmp	ax,WM_INITDIALOG
	je	_initdlg
	cmp	_wparam,IDC_ABOUT
	je	_show_about

	sub	eax,eax
	ret					; message loop, return 0
_wmdestroy:
	push	0				; return 0
	push	_hWnd				; dialog wnd handle
	call	EndDialog			; close dialog window

	ret					; <-- jmp exit
_wmcommand:
	cmp	word ptr[_wparam],IDC_LOAD
	je	_load_exe

	cmp	word ptr[_wparam],IDC_TERMINATE
	je	_terminate_thread

	cmp	word ptr[_wparam],IDC_EXIT
	je	_wmdestroy
	
	ret

_initdlg:
	push	IDI_ICON1
	push	_hInst
	call	LoadIconA

	push	eax
	push	1
	push	WM_SETICON
	push	_hWnd
	call	SendMessageA

	push	offset DlgRect
	push	_hWnd
	call	GetWindowRect

	call	GetDesktopWindow

	push	offset DesktopRect
	push	eax
	call	GetWindowRect

	push	0
	mov	eax,DlgRect.rc_bottom
	sub	eax,DlgRect.rc_top
	mov	DlgHeight,eax
	push	eax
	mov	eax,DlgRect.rc_right
	sub	eax,DlgRect.rc_left
	mov	DlgWidth,eax
	push	eax
	mov	eax,DesktopRect.rc_bottom
	sub	eax,DlgHeight
	shr	eax,1
	push	eax
	mov	eax,DesktopRect.rc_right
	sub	eax,DlgWidth
	shr	eax,1
	push	eax
	push	_hWnd
	call	MoveWindow

	push	offset szProgram
	push	_hWnd
	call	SetWindowTextA		; set main text window

	push	_hWnd
	pop	dword ptr[_hWndForThread]

	push	0			;\
	push	IDC_TERMINATE		; > disable terminate button
	call	enable_window		;/

	push	0
	push	_hWnd
	call	GetSystemMenu
	
	push	eax

	push	offset szAbout
	push	IDC_ABOUT
	push	MF_BYPOSITION or MF_STRING
	push	0
        push	eax
	call	InsertMenuA

	pop	eax

	push	0
	push	0901h
	push	MF_BYPOSITION or MF_SEPARATOR
	push	1
        push	eax
	call	InsertMenuA

	ret
_show_about:
	push	0
	push	offset szAboutCapt
	push	offset szAboutText
	push	_hWnd
	call	MessageBoxA
	ret
_terminate_thread:
	push	-1
	push	dword ptr[hThread_handle]
	call	TerminateThread
@thread_terminated:
	push	offset szExitThread		; set Thread Terminated message
	call	status_msg

	push	1
	push	IDC_LOAD
	call	enable_window

	push	0
	push	IDC_TERMINATE
	call	enable_window

	ret

_load_exe:
	sub	eax,eax
	push	offset hThread
	push	eax
	push	eax
	push	offset @createprocess
	push	eax
	push	eax
	call	CreateThread
	mov	dword ptr[hThread_handle],eax
	ret
;
; D E B U G  T H R E A D 
;
@createprocess	proc
	sub	eax,eax
	mov	edi,offset sinfo
	mov	ecx,STARTUPINFOA_+PROCESS_INFORMATION_	; clear it!
	rep	stosb

	mov	[sinfo.cb], PROCESS_INFORMATION
	push	offset pinfo
	push	offset sinfo
	push	eax					;current dir
	push	eax
	push	DEBUG_ONLY_THIS_PROCESS or CREATE_SUSPENDED
	push	eax
	push	eax
	push	eax
	push	eax
	push	offset szFilename			; pointer to command line
	call	CreateProcessA

	test	eax,eax
	jne	@set_breakpoint

	push	-1
	call	MessageBeep

	push	offset szCreate
	call	status_msg

	jmp	@exit_thread
@set_breakpoint:
	mov	eax,lpVA1
	call	@set_bpx

	cmp	OLD_BYTE,51h
	je	@wakeup_thread

	push	MB_ICONHAND
	push	offset szError
	push	offset szWrongBytes
	push	_hWndForThread
	call	MessageBoxA
	jmp	@exit_thread

@wakeup_thread:
	push	pinfo.pi_hThread
	call	ResumeThread

	push	offset szProcessLoaded
	call	status_msg

	push	0
	push	IDC_LOAD
	call	enable_window				; disable load button

	push	1
	push	IDC_TERMINATE
	call	enable_window

@wait_for_debug_event:
	push	-1					; INFINITE
	push	offset dinfo				; debug info structure
	call	WaitForDebugEvent

	mov	eax,dinfo.de_dwDebugEventCode

	cmp	eax,CREATE_PROCESS_DEBUG_EVENT		; create process
	je	@handle_create

	cmp	eax, EXCEPTION_DEBUG_EVENT		; exception
	je	@handle_bpx

	cmp	eax, EXIT_PROCESS_DEBUG_EVENT		; exit process
	je	@the_end

@wait:
	push	DBG_CONTINUE
	jmp	@handled
@unhandled:
	push	DBG_EXCEPTION_NOT_HANDLED
@handled:
	push	dinfo.de_dwThreadId
	push	dinfo.de_dwProcessId
	call	ContinueDebugEvent
	jmp	@wait_for_debug_event
@handle_create:
	mov	eax, dinfo.de_U.cpdi_hThread
	mov	hDebThread, eax				; remember thread handle!
	jmp	@wait

@handle_bpx:
	cmp	dinfo.de_U.ExceptionRecord.ExceptionCode, EXCEPTION_BREAKPOINT
	jne	@wait_for_debug_event

	mov	eax, dinfo.de_U.ExceptionRecord.ExceptionAddress

	cmp	eax,dword ptr[lpDebugBreak]	; breakpoint called by system at start
	je	@wait

	cmp	eax, lpVA1			; our breakpoint?
	jne	@unhandled

	mov	eax,lpVA1
	call	@reset_bpx

	push	offset dtcontext
	push	hDebThread
	call	GetThreadContext

	mov	eax,dtcontext.cx_Ecx		; under ecx is saved s/n
	push	IDC_SERIAL
	push	eax
	call	set_text

	mov	eax,dtcontext.cx_Edi		; user name
	push	IDC_NAME
	push	eax
	call	set_text
	
	push	DBG_CONTINUE			; flags
	push	dinfo.de_dwThreadId
	push	dinfo.de_dwProcessId
	call	ContinueDebugEvent

	mov	eax,lpVA1			; set bpx again
	call	@set_bpx			; but it _must_ be done after ContinueDebugEvent

	jmp	@wait_for_debug_event		; WaitForDebugEvent
@the_end:
	push	DBG_CONTINUE
	push	dinfo.de_dwThreadId
	push	dinfo.de_dwProcessId
	call	ContinueDebugEvent

	call	@thread_terminated
@exit_thread:

	push	-1
	call	ExitThread
	ret					; <--undocumented way to exit thread
@createprocess endp

;
; mov	esi, offset lpInput pointer to bytes
; mov	eax, VAddress
; mov	ecx, NumberOfBytesToRead
; call	@write
@write proc near
	push	ecx
	push	eax

	push	0			; dummy
	push	ecx			; how many bytes?
	push	esi			; ptr to bytes
	push	eax			; dword ptr to VA
	push	pinfo.pi_hProcess	; handle of process
	call	WriteProcessMemory

	push	pinfo.pi_hProcess	; handle of process
	call	FlushInstructionCache

	ret
@write endp

;
; mov	edi, offset lpOutput
; mov	eax, VAddress
; mov	ecx, NumberOfBytesToRead
; call	@read
@read proc near
	push	ecx
	push	eax

	push	0
	push	ecx
	push	edi			; output buffer
	push	eax			; VA
	push	pinfo.pi_hProcess	; process handle
	call	ReadProcessMemory

	push	pinfo.pi_hProcess	; process handle
	call	FlushInstructionCache

	ret
@read endp

;
; mov	eax,breakpointVA
; call	@set_bpx
; brakpoint is set up by writing int 3 opcode
; its much comfortable than setting brakpoint by debug registers
@set_bpx proc near
	sub	ecx,ecx
	inc	ecx
	pushad
	mov	edi,offset OLD_BYTE
	call	@read

	popad
	mov	esi,offset INT3_BPX
	call	@write
	ret
@set_bpx endp

;
; mov	eax,breakpointVA
; call	@reset_bpx
@reset_bpx proc near
	sub	ecx,ecx
	inc	ecx
	mov	esi,offset OLD_BYTE
	call	@write

	push	offset dtcontext
	push	hDebThread
	call	GetThreadContext

	dec	dtcontext.cx_Eip		; decrement EIP
	mov	dtcontext.cx_ContextFlags, CONTEXT_FULL

	push	offset dtcontext
	push	hDebThread
	call	SetThreadContext

	ret
@reset_bpx endp

;
; push	STATUS
; push	nIDDlgItem
; call	enable_window
enable_window proc
	pop	eax
	pop	edx
	pop	ecx
	push	eax

	push	ecx

	push	edx
	push	_hWndForThread
	call	GetDlgItem

	pop	ecx

	push	ecx
	push	eax
	call	EnableWindow
	ret
enable_window endp

;
; push	offset lpMessage
; call	status_msg
status_msg proc near
	pop	eax
	pop	edx
	push	eax

	push	edx
	push	0
	push	WM_SETTEXT
	push	IDC_STATUS
	push	_hWndForThread
	call	SendDlgItemMessageA
	ret
status_msg endp

;
; push	ID
; push	eax
; call	set_text
set_text proc
	pop	edx
	pop	eax
	pop	ecx

	push	edx

	push	ecx

	mov	ecx,lSerial			; length
	mov	edi,dword ptr[lpSerial]		; destination buffer
	call	@read				; read process memory

	mov	edx,dword ptr[lpSerial]
	movzx	eax,byte ptr[edx]

	push	eax
	call	IsCharAlphaNumericA		; check if char is alphanumeric
	xchg	eax,ecx
	jecxz	@skip_set_text

	pop	ecx

	push	dword ptr [lpSerial]		; set text
	jmp	@set_new_text
@skip_set_text:
	pop	ecx
	push	0
@set_new_text:
	push	ecx
	push	dword ptr [_hWndForThread]
	call	SetDlgItemTextA
	ret
set_text endp


khandler proc, dcode :DWORD, wparam :DWORD, lparam :DWORD
uses edi

	cmp wparam, VK_ESCAPE
	jne CallNextHook

	push	-1
	call	ExitThread

CallNextHook:
	push	lparam
	push	wparam
	push	dcode
	push	WH_KEYBOARD
	call	CallNextHookEx
back_now:
	ret
khandler endp
DlgProc	endp
;---------------------- dane -------------------------------------------------------------------
	szKernel32	db 'KERNEL32.DLL',0
	szDebugBreak	db 'DebugBreak',0
	lpDebugBreak	dd 0
	
	szProgram	db '*loader* for Med v2.5 by bart',0
	szMutext	db '2ooo',0
	szAboutCapt	db 'About',0
	szAboutText	db 'Greetz go out to:',0Dh,0Ah
			db 'GustawKit - Ptasiek - Dulek - Arakus - CoxoC',0Dh,0Ah
			db 'beanus - mig21 - ImagiNative - smola - massh',0Dh,0Ah,0

	szInternal	db 'Internal error!',0
	szProcessLoaded	db 'Process loaded...',0
	szCreate	db 'Cannot open file '
	szFilename	db 'MED.EXE',0

	szExitThread	db 'Thread terminated!',0
	szError		db 'Error!',0
	szWrongBytes	db 'Wrong bytes,terminating process!',0
	szAbout		db '&About',0

	lpSerial	dd 0
	lSerial		equ 255

	_hWndForThread	dd	0
	hDebThread	dd 0		; debug thread
	hThread		dd 0		; thread identifier
	hThread_handle	dd 0		; debuger thread handle
	OLD_BYTE	db 0		; place to store byte replaced by int 3
	INT3_BPX	db 0CCh		; int 3
	lpVA1		equ 415E45h	; breakpoint VA

	_hInst          dd ?
	DlgRect 	RECT ?
	DlgWidth 	dd ?
	DlgHeight 	dd ?
	DesktopRect 	RECT ?
	dinfo		DEBUG_EVENT		<0>
	sinfo		STARTUPINFOA		<0>
	pinfo		PROCESS_INFORMATION	<0>
	dtcontext	CONTEXT <CONTEXT_FULL, 0>	; <--FULL context
	Flags		dd 0C0h

_crypt	proc near
	lea	edi,[esi]
_crypt_loop:
	lodsw
IFDEF DECRYPT
	xor	ah,cl
	xor	al,ah
	xchg	al,ah
ELSE
	xchg	al,ah
	xor	al,ah
	xor	ah,cl
ENDIF
	stosw
	loop	_crypt_loop
	ret
_crypt	endp

;-----------------------------------------------------------------------------------------------
_handler:
	mov	esp,12345678
	@old_esp equ dword ptr $-4
	pop	dword ptr fs:[0]
	pop	eax

	push	MB_ICONHAND
	push	offset szError
	push	offset szInternal
	push	0
	call	MessageBoxA

	push	-1
	call	ExitProcess
end	_start
