%macro	callW	1
	extern	%1
	import	%1 kernel32.dll
	call	[%1]
%endmacro

%define	STD_OUTPUT_HANDLE	-11
%define STD_INPUT_HANDLE	-10
%define	STD_ERROR_HANDLE	-12
%define	jmps			jmp short
%define	jnzn			jnz near
%define jzn			jz near
%define	jbn			jb near
;%define	_DEBUG_			1

SECTION CODE USE32 CLASS=CODE
..start:
;	seh frame

	sub	eax,eax
	push	dword handler
	push	dword [fs:eax]
	mov	dword [fs:eax],esp

;	init console

	push	dword STD_OUTPUT_HANDLE
	callW	GetStdHandle
	mov	[hConsoleOut],eax	; save console handle for write

	push	dword STD_INPUT_HANDLE
	callW	GetStdHandle
	mov	[hConsoleIn],eax	; save console handle for read

	push	byte 1
	push	dword ctrlchandler
	callW	SetConsoleCtrlHandler

	call	rnd
	mov	ecx,lCryptedSn
	sub	edx,edx
	div	ecx			; wybierz liczbe zakresu do 0-lCryptedSn

	xchg	eax,edx			; eax modulo
	sub	edx,edx			; edx
	mov	ecx,17			; seriale sa w porcjach 17 bajtowych
	mul	ecx

	lea	eax,[eax+lpCryptedSn]	; eax wskaznik na sn
	push	eax
	call	decrypt			; deszyfruj go
	xchg	esi,eax			; eax wskaznik zdeszyfrowanego bufora
	mov	edi,dword lpSN		; edi dest
	
	call	rnd			; losuj liczbe pseudo przypadkowa

	and	eax,0Fh			; obcinaj
					; hex2ascihex
	add	al,90h			; (0-0F)+90h
	daa				;
	adc	al,40h			; +40h+carry flag
	daa
	mov	dl,al

	mov	ecx,17
	rep	movsb

	mov	byte [edi-15],dl

	mov	edi,dword lpIntro
	call	writeln

	mov	edi,dword lpIntro
	sub	ecx,ecx
	inc	ecx
	call	readln

exit:
	sub	eax,eax
	pop	dword [fs:eax]
	pop	eax

handler:
	push	byte 0
	callW	ExitProcess
;endendendendendendendendendendendendendendendendendendendendendendendendendendendendendendendend
;	P R O C E D U R Y
;endendendendendendendendendendendendendendendendendendendendendendendendendendendendendendendend

;	edx liczba pseudo przypadkowa
rnd:
	callW	GetTickCount
	mov	ebx,eax
	and	ebx,0Fh
	test	ebx,ebx
	jzn	rnd

.loop:
	lea	eax,[eax+ebx*4]
	rol	eax,4
	xor	eax,[seed]
	rol	eax,4
	or	eax,[seed]
	rol	eax,4
	sub	[seed],eax

	dec	ebx
	jnzn	.loop

	ret

ctrlchandler:
	push	byte -1
	callW	ExitProcess

;	edi bufor
writeln:
	pushad
	test	edi,edi
	jzn	crlf

	sub	eax,eax
	sub	ecx,ecx
	dec	ecx
	repne	scasb
	not	ecx
	sub	edi,ecx
	dec	ecx
	jmps	string
crlf:
	mov	edi,dword lpCRLF
	push	byte 2
	pop	ecx
string:
	push	byte 0
	push	dword iWritten
	push	ecx			; string length
	push	edi			; string
	push	dword [hConsoleOut]
	callW	WriteConsoleA

	popad

	ret

;	edi bufor
;	ecx dlugosc pobieranego textu
readln:
	pushad

	push	byte 0
	push	dword iWritten
	push	ecx
	push	edi
	push	dword [hConsoleIn]
	callW	ReadConsoleA

	popad
	ret

;	push	dword lpstrHash
;	call	decrypt
;
;	for (t=0;t<0x11;t++)
;	{
;	sn[t]-=sub_pattern[t];
;	}
;
decrypt:
	pop	edx			; adres powrotu
	pop	eax			; 1 parametr
	push	edx			; zapamietaj adres powrotu

	push	eax			; zapamietaj wskaznik bufora

	push	byte 11h		; wszystkie stringi maja dlugosc
	pop	ecx			; 11h

	mov	esi,dword sub_pattern	; esi wskaznik do bufora z wartosciami
decrypt_string:
	mov	dl,byte [eax]		; dl bajt z sn
	mov	dh,byte [esi]		; dh bajt z esi
	sub	dl,dh			; odejmij sn[t]-=sub_pattern[t];
	mov	byte [eax],dl		; zapisz odszyfrowany bajt
	inc	eax			; zwieksz wskazniki buforow
	inc	esi			;
	dec	ecx			; zmniejsz licznik
	jnzn	decrypt_string		; jelsi nie koniec powtarzaj petle

	pop	eax			; eax po wyjsciu z procki adres bufora

	ret

sub_pattern	db	03h,04h,05h,09h,06h,0Dh,0Ch,02h,01h,05h,03h,08h,02h,08h,01h,0Dh,13h
sub_patternl	equ	$-sub_pattern


SECTION DATA USE32 CLASS=DATA

lpIntro		db	'',0Dh,0Ah
		db	' BVS Solitaire Collection 2.6 keygen by bart^CrackPl 2ooo ',0Dh,0Ah
		db	'',0Dh,0Ah
		db	'Your random sn: '
lpSN:		times	17 db 0
		db	0Dh,0Ah,0Dh,0Ah
		db	'Press enter . . .',0Dh,0Ah,0
lpOut		resb	256

hConsoleOut	resd	1
hConsoleIn	resd	1
iWritten	resd	1
seed		resd	1
lpCRLF		db	0Dh,0Ah

lpCryptedSn:
;			db	'VVM67=</7;:/\4@F'
		db	'VXL67==/8<59/T2@F'
		db	'VWL67=>/69::/@9DD'
		db	'VWL67=?/4>28/>9@E'
		db	'VWL67=@/49;9/;:DK'
		db	'VWL67=A/BKJ:/<4FD'
		db	'VWL67=B/SY8>/:4EL'
		db	'VWL67=C/4<5A/\7?J'
		db	'VWL67=E/455</NO?K'
		db	'VWL67></5:;:/9:?K'
		db	'VWL67>=/5<;:/>8EE'
		db	'VWL67>>/4>5:/<6EF'
		db	'VWL67>?/G;5?/P9@F'
		db	'VWL67>@/3>7;/LE@E'
		db	'VWL67>A/5:::/>:@E'
		db	'VWL67>B/4;U\/93FG'
		db	'VWL67>C/276?/=WFK'
		db	'VWL67>D/365N/97?['
		db	'VWL67>E/E5<9/<4FF'
		db	'VWL67?</G:7>/<8@Y'
		db	'VWL67?=/273A/J5BI'
		db	'VWL67?>/484;/=5FE'
		db	'VWL67??/3<9=/A9BI'
		db	'VWL67?@/3>6</:EAH'
		db	'VWL67?A/4<7=/<4EH'
		db	'VWL67?B/4<;=/;3DH'
		db	'VWL67?C/5<5;/;9BF'
		db	'VWL67?E/58<=/<F?D'
		db	'VWL67@</3>7;/81?F'
		db	'VWL67@=/3>7;/9:?F'
		db	'VWL67@>/255A/=5EE'
		db	'VWL67@?/5>7=/;K>F'
		db	'VWL67@@/5M5@/<:?K'
		db	'VWL67@A/354A/<LEE'
		db	'VWL67@B/2739/<:?G'
		db	'VWL67@C/556@/;1AK'
		db	'VWL67@D/5X6:/A2YE'
		db	'VWL67@E/3849/=4AH'
		db	'VWL67A</B65?/=BCF'
		db	'VWL67A=/GL:</;5?K'
		db	'VWL67A>/I87:/=7>C'
		db	'VWL67A?/ILMR/:4>K'
		db	'VWL67A@/5:6?/;7BK'
		db	'VWL67AA/696:/?9DI'
		db	'VWL67AB/H;8?/>8a_'
		db	'VWL67AC/47;</NI_D'
		db	'VWL67AD/3=:9/;8>E'
		db	'VWL67AE/9>5</92FC'
		db	'VWL67B</9>6:/A1>E'
		db	'VWL67B=/6<5P/LICG'
		db	'VWL67B>/49K?/AFEE'
		db	'VWL67B?/5<5</93DG'
		db	'VWL67B@/3=G?/;3AC'
		db	'VWL67BA/4=48/@8SW'
		db	'VWL67BB/1>5?/@2=E'
		db	'VWL67BD/58:N/:7BE'
		db	'VWL67BE/47:;/[9AF'
		db	'VWL67C</3=48/<8?K'
		db	'EWL66==/H769/\G?D'
		db	'EWL66=>/7Y\9/=5@E'
		db	'EWL66=?/474A/@6DF'
		db	'EWL66=@/GX5;/A5@D'
		db	'EWL66=A/B>5;/?9FF'
		db	'EWL66=B/C87:/>9@E'
		db	'EWL66=C/9<V;/<6@C'
		db	'EWL66=D/6=69/AI@G'
		db	'EWL66=E/2M5:/<3EH'
		db	'EWL66></49M;/A1>F'
		db	'EWL66>=/9P6</=8>F'
		db	'EWL66>>/9<IA/;3AJ'
		db	'EWL66>?/M879/=5@E'
		db	'EWL66>@/79M</>9?J'
		db	'EWL66>A/9779/=1FF'
		db	'EWL66>B/985@/9:=H'
		db	'EWL66>C/:98:/>8@G'
		db	'EWL66>D/7=6:/>6EE'
		db	'EWL66>E/7=6>/;9CH'
		db	'EWL66?</5>8a/RVEG'
		db	'EWL66?W/5>6:/?9EF'
		db	'EWL66?>/7=7;/:1BG'
		db	'EWL66??/H8;A/>1_I'
		db	'EWL66?@/58;X/A3@H'
		db	'EWL66?A/7=3;/<4FE'
		db	'EWL66?B/887;/?8?L'
		db	'EWL66?C/976?/>8EF'
		db	'EWL66?D/L96=/[3@G'
		db	'EWL66?E/9K7:/A9AD'
		db	'EWL66@</9:5;/>9@E'
		db	'EWL66@=/M98;/<4CD'
		db	'EWL66@>/KP<:/A6@E'
		db	'EWL66@?/I85</>4BE'
		db	'EWL66@@/B;8?/A3@G'
		db	'EWL66@A/:F:</@3@l'
		db	'EWL66@B/8K<;/A4ED'
		db	'EWL66@C/KM;A/=4@D'
		db	'EWL66@D/F98;/>:=F'
		db	'EWL66@E/3<;;/A9FF'
		db	'EWL66A</:83;/>9@C'
		db	'EWL66A=/H>6:/:4BD'
		db	'EWL66A>/:87N/A9@G'
		db	'EWL66A?/G56</?8AE'
		db	'EWL66A@/K57;/?3FF'
		db	'EWL66AA/E=<;/@:SF'
		db	'EWL66AB/6<;N/84?H'
		db	'EWL66AC/GX5</>4AH'
		db	'EWL66AD/5:6Q/A3AD'
		db	'EWL66AE/I879/>6FI'
		db	'EWL66B</HY:;/@:CF'
		db	'EWL66B=/H>;;/A4AD'
		db	'EWL66B>/S:9?/@4>E'
		db	'EWL66B?/:=<</::?G'
		db	'EWL66B@/G=6</a8@G'
		db	'EWL66BA/:=79/\9@H'
		db	'EWL66BB/9968/=9?D'
		db	'EWL66BC/6988/P9@G'
		db	'EWL66BD/G>6:/>6AF'
		db	'EWL66BE/896:/O9AF'
		db	'EWL66C</G=6</>9AF'
		db	'EWL66C=/7K;;/>4?l'
		db	'EWL66C>/58;P/;5fG'
		db	'EWL66C?/Z<7=/>6?e'
		db	'EWL66C@/985</a8@G'
		db	'EWL66CA/L=<;/?3>E'
		db	'EWL66CB/U=6:/@3AD'
		db	'EWL66CC/T;5;/=4?l'
		db	'EWL66CD/685Z/;3AD'
		db	'EWL66CE/4L\?/A9?G'
		db	'EWL66D</17<Q/A3@G'
		db	'EWL66D=/K<8:/>9@Y'
		db	'EWL66D>/6L<;/@:>H'
		db	'EWL66D?/U=6</@3AD'
		db	'EWL66D@/T<;;/?9?D'
		db	'EWL66DA/M>7@/>6ED'
		db	'EWL66DB/987=/@5>E'
		db	'EWL66DC/8;6:/>8?D'
		db	'EWL66DD/885>/@4@E'
		db	'EWL66DE/2<5a/<4BE'
		db	'EWL66E</796?/N:@G'
		db	'EWL66E=/69;A/\4?G'
		db	'EWL66E>/965N/;6Eg'
		db	'EWL66E?/58I@/;3El'
		db	'EWL66E@/47:@/N9@E'
		db	'EWL66EA/478\/?5@l'
		db	'EWL66EB/47;>/?9FD'
		db	'EWL66EC/696?/N4?K'
		db	'EWL66ED/478Z/<4Bh'
		db	'EWL66EE/5888/;3FD'
		db	'EWL66F</696@/93FY'
		db	'EWL66F=/696A/@:=F'
		db	'EWL66F>/47;A/?9FC'
		db	'EWL66F?/1>9;/=3EL'
		db	'EWL66F@/58<;/A5?H'
		db	'EWL66FA/47;9/A5@F'
		db	'EWL66FB/7::A/?9EL'
		db	'EWL66FC/9:7;/@3@E'
		db	'EWL66FD/5:9;/>9@D'
		db	'EWL66FE/789</@8?D'
		db	'EWL67=</696>/@:@J'
		db	'EWL67==/385A/>3@E'
		db	'EWL67=>/6<;;/>6DK'
		db	'EWL67=?/U;7a/A9?F'
		db	'EWL67=@/SY;=/>9DY'
		db	'EWL67=A/588:/O4AE'
		db	'EWL67=B/4989/<8?F'
		db	'EWL67=C/K85</:3@l'
		db	'EWL67=D/H<6</A6@D'
		db	'EWL67=E/5:5\/Z4FG'
		db	'EWL67></588@/[9@G'
		db	'EWL67>=/588P/;3AD'
		db	'EWL67>>/5:5?/::BF'
		db	'EWL67>?/6>5:/<4CK'
		db	'EWL67>@/58<8/=9@E'
		db	'EWL67>A/U879/<4EE'
		db	'EWL67>B/Z;6</\:@G'
		db	'EWL67>C/G=6</?7AF'
		db	'EWL67>D/JW9=/>6EE'
		db	'EWL67>E/I>;>/AZCJ'
		db	'EWL67?</G;8?/@6@D'
		db	'EWL67?=/9;7;/@:SI'
		db	'EWL67?>/X<;>/;5El'
		db	'EWL67??/7<<:/@UBI'
		db	'EWL67?@/8>I=/;5al'
		db	'EWL67?A/S::A/=7EL'
		db	'EWL67?B/Z<99/A8RF'
		db	'EWL67?C/:;S=/>HSH'
		db	'EWL67?D/5X<?/?7_F'
		db	'EWL67?E/9>69/\ZCH'
		db	'EWL67@</O=9</?3>L'
		db	'EWL67@=/6F9=/Y6AI'
		db	'EWL67@>/6;;:/A7DF'
		db	'EWL67@?/Z<9@/R9DH'
		db	'EWL67@@/L=5</R8CL'
		db	'EWL67@A/9;:9/A8EF'
		db	'EWL67@B/8;7;/93DL'
		db	'EWL67@C/T99=/>8EG'
		db	'EWL67@D/R:9?/\5BC'
		db	'EWL67@E/87<:/?7BF'
		db	'EWL67A</:=:=/;2AF'
		db	'EWL67A=/U;8?/A8ED'
		db	'EWL67A>/Z<9>/<4?G'
		db	'EWL67A?/U:9?/<4?L'
		db	'EWL67A@/X99=/=7AK'
		db	'EWL67AA/X9<>/;3EL'
		db	'EWL67AB/8;8</98@G'
		db	'EWL67AC/4=<A/<4?E'
		db	'EWL67AD/277?/?7BF'
		db	'EWL67AE/7<8?/\4FG'
		db	'EWL67B</28;A/;3BG'
lCryptedSn	equ	($-lpCryptedSn)/17

