.386
locals
jumps
.model flat,stdcall

INCLUDE				..\stuff.inc

MB_ICONHAND			equ	00000010h ;error
MB_ICONEXCLAMATION		equ	00000030h ;warning
MB_ICONASTERISK			equ	00000040h ;info
MB_OKCANCEL			equ	00000001h ;typ msgboxa
ID_OK				equ   1
PAGE_READONLY			equ   2
PAGE_READWRITE			equ   4     
PAGE_WRITECOPY			equ   8     
SECTION_QUERY			equ   1
SECTION_MAP_WRITE		equ   2
SECTION_MAP_READ		equ   4
SECTION_MAP_EXECUTE		equ   8
SECTION_MAP_EXTEND_SIZE		equ   10
FILE_MAP_COPY			equ   SECTION_QUERY
FILE_MAP_WRITE			equ   SECTION_MAP_WRITE
FILE_MAP_READ			equ   SECTION_MAP_READ

FILE_ATTRIBUTE_NORMAL		equ 080h
OPEN_EXISTING			equ 3
GENERIC_READ			equ 80000000h
FILE_SHARE_READ			equ 0001h

FILE_ATTRIBUTE_ARCHIVE		equ     00000020h


extrn	MessageBoxA			:proc
extrn	ExitProcess			:proc
extrn	GetFileTime			:proc
extrn	SetFileTime			:proc
extrn	GetFileAttributesA		:proc
extrn	SetFileAttributesA		:proc
extrn	CreateFileMappingA		:proc
extrn	MapViewOfFile			:proc
extrn	UnmapViewOfFile			:proc
extrn	CloseHandle			:proc
extrn	CreateFileA			:proc
extrn	GetFileSize			:proc
extrn	lstrcat				:proc

_junk	macro prefix
jmp	$+4
db	prefix
db	NOT prefix+1
endm

_vxd	macro
jmp	$+5
db	0CDh,20h,46h
endm

;DEBUG	equ	1
.data
db 0
.code
_start:

_junk	69h

	mov	oldesp,esp
	sub	edx,edx
	push	offset _handler
	push	dword ptr fs:[edx]
	mov	fs:[edx],esp
	_vxd

	@init_patcher patcher

	mov	edx,offset patcher.szInfo
	call	msg

; file attrib
	push	offset patcher.filename
	call	GetFileAttributesA

	cmp	eax,-1
	jne	_next

	call	cannot_open
	jmp	_exit

_next:
	push	eax

clearattrib:
	push	FILE_ATTRIBUTE_ARCHIVE
	push	offset patcher.filename
	call	SetFileAttributesA

; open file

open:
	sub	eax,eax
	push	eax
	push	FILE_ATTRIBUTE_NORMAL
	push	3 ; OPEN_EXISTING
	push	eax
	push	eax
	push	80000000h + 40000000h ; GENERIC_READ + GENERIC_WRITE
	push	offset patcher.filename
	call	CreateFileA
	cmp	eax,-1
	jne	__next

	call	cannot_open
	jmp	_exit

__next:
	push	eax			; store file handle

	push	offset creation
	push	offset lastaccess
	push	offset lastwrite
	push	eax
	call	GetFileTime

	pop	eax
	push	eax
; get file size
	push	0
	push	eax			; file handle
	call	GetFileSize

;create file mapping
	pop	ecx			; file handle

	cmp	eax,[patcher.filesize]
	je	_map

	push	ecx

	push	01h
	push	offset patcher.szCaption
	push	offset szSize
	push	0
	call	MessageBoxA		; show info about wrong sizes

	pop	ecx

	cmp	eax,1
	jne	_exit

_map:
	sub	edx,edx
	push	ecx			; store file handle
	mov	eax,[patcher.filesize]

	push    edx
	push    eax			; size
	push    edx			; 0 if file size <4GB   
	push    PAGE_READWRITE		; read&write  
	push    edx
	push    ecx			; file handle
	call    CreateFileMappingA

	push	eax			; save handle of mapped file

	sub	edx,edx

	push	edx			; 0 means all file
	push	edx
	push	edx
	push	FILE_MAP_WRITE		; flags read&write
	push	eax
	call	MapViewOfFile

	push	eax			; store pointer to mapped file

	mov	ebx,eax
	xchg	eax,edx

; patching
IFDEF	DEBUG
int	3
ENDIF

	_vxd
	mov	esi,offset patcher.lpTable
	jmp	first_patch
patch_loop:

	xchg	eax,edi		; adres do edi
				_vxd
	lea	edi,[edi+edx]	; edi=edi+pointer_to_mapped_file
	lodsb			; get byte
				_vxd
	stosb			; patch [edi]
first_patch:
	lodsd			; get patch address
				_vxd
	cmp	eax,-1
				_vxd
	jne	patch_loop

_show_msg:
; info
	mov	edx,offset szSuccess
	call	msg

; close memory mapped file
_close:
	call	UnmapViewOfFile		; params already onto the stack
	call	CloseHandle

; restore file attribs
	pop	eax			; file handle
	push	eax

	push	offset creation
	push	offset lastaccess
	push	offset lastwrite
	push	eax
	call	SetFileTime

	call	CloseHandle		; file handle already onto the stack

	pop	eax
	push	eax
	push	offset patcher.filename
	call	SetFileAttributesA

; exit process
_exit:

	pop	dword ptr fs:[0]
	pop	eax
	jmp	_no_error
_handler:
	pop	dword ptr fs:[0]	; remove SEH frame
	mov	esp,oldesp

	push	MB_ICONHAND
	push	offset patcher.szCaption
	push	offset szInternal
	push	0
	call	MessageBoxA
_no_error:
	push	-1
	call	ExitProcess

cannot_open:
	push	offset patcher.filename
	push	offset szCannotOpen
	call	lstrcat
	xchg	eax,edx
msg:
	sub	eax,eax
	push	eax
	push	offset patcher.szCaption
	push	edx
	push	eax
	call	MessageBoxA
ret

_patcher_data:
szCannotOpen	db 'Cannot open file ',0

marker_for_krax	db '$$$$'
patcher		PATCHER_ <0>

creation	dd 0,0
lastaccess	dd 0,0
lastwrite	dd 0,0

oldesp		dd 0

szSuccess	db 'File successfully patched!',0
szInternal	db 'Internal error occured!',0
szSize		db 'Invalid file size!Patch anyway?',0

end _start