%include "icedump.inc"

	BITS 32
	ORG PAGEIN_PATCH_ORIGIN

; manual patch: DEVICE_INIT calls init
; all runtime patches could be made static inside the exe file itself
; but who wants to mess with the LE relocations? ;-)

	dd INIT_CALL			; for the patcher
	dd PAGEIN_PATCH_ORIGIN		; for the patcher

Init:
	pushad
	call	.delta
.delta:
	pop	edx
	sub	edx,.delta		; edx has base of WINICE now

; c_PAGEIN calls parser and passes cmdline in ESI
	mov	byte  [edx+PAGEIN_CMDLINE],0xBE
	mov	dword [edx+PAGEIN_PARSER+1],Parser-PAGEIN_PARSER-5

; client registers saving inside c_PAGEIN_
	mov	byte  [edx+CRS_END],0xC3

; change page fault protected area
	lea	eax,[edx+Init]
	mov	[edx+IGNOREFAULTS1],eax
	lea	eax,[edx+End]
	mov	[edx+IGNOREFAULTS2],eax

; make PCI vendor name table empty
	mov	dword [edx+PCI_VENDORS],0xFFFFFFFF

; reloc ProcDump's structure offset
	add	[edx+Procdump.DataPointer],edx

; allocate callbacks used to transition into ring-0

	lea	esi,[edx+Callback.entryPMCB]
	db 0xCD,0x20,0x0C,0x00,0x01,0x00; VMMcall Allocate_PM_Call_Back
	jnb	.gotPMCB

	xor	eax,eax			; oops...

.gotPMCB:
	movzx	ebx,ax
	mov	[edx+Parser.PMCB_OFF],ebx
	shr	eax,16
	mov	[edx+Parser.PMCB_SEG],eax

	lea	esi,[edx+Callback.entryV86CB]
	db 0xCD,0x20,0x0B,0x00,0x01,0x00; VMMcall Allocate_V86_Call_Back
	jnb	.gotV86CB

	xor	eax,eax			; oops...

.gotV86CB:
	movzx	ebx,ax
	mov	[edx+Parser.V86CB_OFF],ebx
	shr	eax,16
	mov	[edx+Parser.V86CB_SEG],eax

	popad
	retn


; ------------------------------------------------------------------------------
; this is the new PAGEIN parser that accepts the following syntax:
;
;             PAGEIN D <address> [<length> <file name>]
;             PAGEIN P <Bhrama window name>
;             PAGEIN S <PID>|<TID>
;             PAGEIN R <PID>|<TID>
; ------------------------------------------------------------------------------

Parser:
	pushad

	call	.delta
.delta:
	pop	ebp
	sub	ebp,.delta

	call	pSaveRegs		; save the client registers
	call    pSkipWord		; skip over "PAGEIN"
	jb	near .error

	lodsb				; get subcommand
	and	al,0x5F			; upcase

	call	pSkipWhiteSpace		; skip to real arguments
	jz	near .error

	cmp	al,'D'
	jz	near .DUMP

	cmp	al,'P'
	jz	near .PROCDUMP

	cmp	al,'S'
	jz	near .SUSPEND

	cmp	al,'R'
	jz	near .RESUME

	jmp	.error

.PROCDUMP:
	test	byte [ebp+dClient_EFLAGS+2],2	; is client in V86 mode?
	jnz	near .error

	test	byte [ebp+dClient_CS],3	; is client in ring-0?
	jz	near .error

; we should check for a 32 bit code segment too, but stupid people deserve
; their faith ;-)

	mov	[ebp+dClient_ESI],esi	; bhrama server's window name
	mov	eax,[ebp+dClient_EIP]	; use current EIP
	mov	[ebp+Procdump.dumpinfo+BhramaComStruc.EIP],eax

	cmp	dword [ebp+Procdump.oGetCurrentProcessID],0
	jnz	.1
	lea	esi,[ebp+Procdump.GetCurrentProcessID]
	call	pExp2Int
	jb	near .error
	mov	[ebp+Procdump.oGetCurrentProcessID],eax
.1:

	cmp	dword [ebp+Procdump.oFindWindowA],0
	jnz	.2
	lea	esi,[ebp+Procdump.FindWindowA]
	call	pExp2Int
	jb	near .error
	mov	[ebp+Procdump.oFindWindowA],eax
.2:

	cmp	dword [ebp+Procdump.oSendMessageA],0
	jnz	.3
	lea	esi,[ebp+Procdump.SendMessageA]
	call	pExp2Int
	jb	.error
	mov	[ebp+Procdump.oSendMessageA],eax
.3:

	lea	ecx,[ebp+Procdump]
	lea	eax,[ebp+oINT3]
	jmp	.setEIP


.SUSPEND:
	mov	dword [ebp+dClient_EAX],SERVICE_SUSPEND
	jmp	short .parseSR

.RESUME:
	mov	dword [ebp+dClient_EAX],SERVICE_RESUME

.parseSR:
	call	pExp2Int		; parse <pid>|<tid>
	jb	.error

	mov	[ebp+dClient_EDI],eax	; store pid or tid
	jmp	short .setCB

.DUMP:
	mov	dword [ebp+dClient_EAX],SERVICE_DUMP
	call	pExp2Int		; parse <address>
	jb	.error
	mov	[ebp+dClient_EDI],eax	; store start address of block
	call	pSkipWhiteSpace		; skip to <length>
	jz	.emulate		; let's emulate the old behaviour
	call	pExp2Int		; parse <length>
	jb	.error
	call	pSkipWhiteSpace		; skip to <file name>
	jnz	.setDumpInfo
.error:
	call	pRestoreRegs		; restore the client registers
	popad
	retn

.emulate:
	xor	eax,eax			; zero length, old PAGEIN is emulated
	xor	esi,esi			; no filename, old PAGEIN is emulated

.setDumpInfo:
	mov	[ebp+dClient_ECX],eax	; store length of block
	mov	[ebp+dClient_ESI],esi	; store pointer to file name

.setCB:
	mov	eax,oINT3-WINICE_DELTA

	mov	ecx,V86CB_OFF		; these two mov's will be modified
.V86CB_OFF	EQU $-4
	mov	ebx,V86CB_SEG		; runtime while initializing
.V86CB_SEG	EQU $-4

	test	byte [ebp+dClient_EFLAGS+2],2	; is client in V86 mode?
	jz	.PM
	test	ebx,ebx			; is callback valid?
	jnz	.setCSEIP

.testEIP:
	jecxz	.error

.setCSEIP:
	mov	[ebp+dClient_CS],ebx	; set client CS
.setEIP:
	mov	[ebp+dClient_EIP],ecx	; set client (E)IP

	mov	[ebp+oPAGEIN_INT3],eax	; set address of final INT3

;        mov     eax,1
	xor     eax,eax			; wow, saves 2 bytes
	inc	eax			; thanks G-Rom ;-)

	mov     [ebp+fDoingPAGEIN],eax  ; set internal Winice flag to 1
	mov     [ebp+fExecMoreCmds],ah  ; set internal Winice flag to 0

	popad
	retn

.PM:
	mov	ecx,PMCB_OFF		; these two mov's will be modified
.PMCB_OFF	EQU $-4
	mov	ebx,PMCB_SEG		; runtime while initializing
.PMCB_SEG	EQU $-4

	test	byte [ebp+dClient_CS],3	; is client in ring-0?
	jnz	.testEIP		; is callback valid?

	lea	ecx,[ebp+Callback.entryPMR0]
	lea	eax,[ebp+oINT3]
	jmp	short .setEIP


; ------------------------------------------------------------------------------
; this is where we call Procdump based on Stone's example
; ------------------------------------------------------------------------------

Procdump:
	call	.delta			; set up return address first
.delta:
	sub	dword [esp],.delta
	mov	edi,[esp]
	add	dword [esp],oINT3

	call	[edi+.oGetCurrentProcessID]
	mov	[edi+.dumpinfo+BhramaComStruc.PID],eax
;	mov	[edi+.dumpinfo+BhramaComStruc.EIP],0x0
;	mov	[edi+.dumpinfo+BhramaComStruc.OptL1],0x00000000
;	mov	[edi+.dumpinfo+BhramaComStruc.OptL2],0x01000001
;	mov	[edi+.dumpinfo+BhramaComStruc.OptL3],0x01010001
;	mov     [edi+.dumpinfo+BhramaComStruc.OptL4],0x00010000
;	mov     [edi+.dumpinfo+BhramaComStruc.OptL5],0x00000000

; LookUp for ProcDump Server.
	push	esi
	push	dword 0
	call	[edi+.oFindWindowA]
	test	eax, eax
	jnz	.sendmsg

	retn

; Send Dump Message to ProcDump Server.
.sendmsg:
	lea	ebx,[edi+.Service]
	push	ebx
	push	dword 0
	push	dword WM_COPYDATA
	push	dword eax		; ProcDump's hwnd
	call	[edi+.oSendMessageA]

	retn

	align 4
.Service:	dd 1
.DataLength:	dd BhramaComStruc_size
.DataPointer:	dd .dumpinfo		; reloc

.dumpinfo:
	istruc BhramaComStruc
	at BhramaComStruc.version,	dd 3
	at BhramaComStruc.PID,		dd 0
	at BhramaComStruc.EIP,		dd 0
	at BhramaComStruc.OptL1,	dd 0x00000000
	at BhramaComStruc.OptL2,	dd 0x01000101
	at BhramaComStruc.OptL3,	dd 0x01010001
	at BhramaComStruc.OptL4,	dd 0x00030000
	at BhramaComStruc.OptL5,	dd 0x00000000
	iend

.oGetCurrentProcessID:	dd 0
.oFindWindowA:		dd 0
.oSendMessageA:		dd 0
.GetCurrentProcessID:	db 'GetCurrentProcessID',0
.FindWindowA:		db 'FindWindowA',0
.SendMessageA:		db 'SendMessageA',0


; ------------------------------------------------------------------------------
; it can be entered from three different modes: V86, ring-3 PM and ring-0 PM.

; no matter where we're coming from though, the client registers will be
; set up the same way:
;    EDI: flat start address of block
;    ECX: length of block (or 0 if emulating old PAGEIN)
;    ESI: filename (or 0 if emulating old PAGEIN)

Callback:
.entryV86CB:
	pushad
	mov	edi,0xF0000		; start of ROM BIOS
	mov	ecx,0x10000		; length of area we search through
	mov	al,0xCC			; opcode of INT3
	cld
	repnz	scasb			; may cause page fault
	jecxz	.useClientStack		; damn, let's hack the stack instead

	dec	edi			; adjust EDI
	shld	ecx,edi,28		; ECX: client CS
	shrd	ebx,edi,4		; EBX: client IP
	shr	ebx,28
	jmp short .setPAGEIN_INT3

.useClientStack:
	movzx	ecx,word [ebp+Client_SS]	; get client SS
	shrd    edi,ecx,28              ; convert to linear address
	movzx   ebx,word [ebp+Client_ESP]       ; get client SP
	dec	bx			; 1 byte below the stack
	add	edi,ebx			; linear address of our INT3
	stosb				; may cause page fault

.setPAGEIN_INT3:
	mov	[edx+oPAGEIN_INT3],ebx	; store address of our INT3
	jmp short .setCSEIP

.entryPMCB:
	pushad
	mov	ecx,[edx+wWINICE_CODE]	; set client CS:EIP to an INT3
	mov     ebx,oINT3-WINICE_DELTA

.setCSEIP:
        mov     [ebp+Client_CS],ecx
	mov	[ebp+Client_EIP],ebx
	jmp short .service

.entryPMR0:
	call	.delta
.delta:
	sub	dword [esp],.delta	; geee, why does NASM not let me do it
	add	dword [esp],oINT3	; in one expression...
	pushad				; simulate Client Register Structure
	mov	ebp,esp			; on the stack

.service:
;	cmp	dword [ebp+Client_EAX],SERVICE_VERSION
;	jnz	.1
;	mov	dword [ebp+Client_EAX],ICEDUMP_VERSION
;	popad
;	retn
;.1
	cmp	dword [ebp+Client_EAX],SERVICE_DUMP
	jz	near Dump

	cmp	dword [ebp+Client_EAX],SERVICE_SUSPEND
	jz	SuspendResume

	cmp	dword [ebp+Client_EAX],SERVICE_RESUME
	jz	SuspendResume

	popad
	retn


SuspendResume:
	call	.delta
.delta:
	pop	esi
	sub	esi,.delta		; get Winice base

	cmp	dword [esi+.Win32ServiceTable],0	; init phase completed?
	jnz	.has_pointer

	mov	eax,0x2A		; vwin32.vxd ID
	db 0xCD,0x20,0x46,0x01,0x01,0x00; VMMcall GetDDB
	mov	eax,[ecx+0x38]		; get Win32 Services Table pointer
	lea	ebx,[esi+.W32_Error]
	or	eax,eax			; is it initialized ?
	je	near .error
	mov	[esi+.Win32ServiceTable],eax

.has_pointer:
	mov	eax,[ebp+Client_EDI]	; get xID
	cmp	eax,0xF000000
	jl	.is_dbase

	mov	ecx,[esi+dObfuscator]	; ECX: obfuscator
	cmp	ecx,0			; is obfuscator initialized?
	lea	ebx,[esi+.Obf_Error]
	jz	.error
	xor	eax,ecx			; EAX: Thread or Process Database

.is_dbase:
	push	eax			; save it for later use
	shr	eax,12			; convert it to page number
	lea	ebx,[esi+.Mem_Error]
	call	IsPageCommitted		; is the corresponding page present?
	pop	eax			; back to linear address
	jz	.error

	lea	ebx,[esi+.Obj_Error]
	cmp	eax,0x80000000		; PDB/TDB are above private arena
	jl	.error

	mov	ecx,1
	cmp	dword [eax],0x6		; is it TID?
	jz	.handle_thread

	cmp	dword [eax],0x5		; is it PID?
	jnz	.error

.is_process:
	movzx	ecx,word [eax+0x2C]	; get number of threads
	mov	edx,[eax+0x50]		; get ThreadList
	mov	edx,[edx]		; get Thread_Ref pointer

.more_threads: 
	mov	eax,[edx+8]		; get Thread Database        
.handle_thread:
	call	SuspendResumeThread        
	jc	.Sch_error

.get_next_thread:
	mov	edx,[edx]		; get next Thread_Ref
	loop	.more_threads

	popad
	retn

.Sch_error:
	lea	ebx,[esi+.Sch_Error]
	push	ebx
	db 0xCD,0x20,0xF3,0x00,0x01,0x00; VMMcall _Trace_Out_Service

	jmp	short .get_next_thread

.error:
	push	ebx
	db 0xCD,0x20,0xF3,0x00,0x01,0x00; VMMcall _Trace_Out_Service

.return:
	popad
	retn

	align 4
;------------------------------------------------------------------------------
.Win32ServiceTable	dd 0
.Sch_Error db 'Failed to suspend/resume Thread #EAX.',CRLF_0
.Obj_Error db 'Object #EAX is not a valid thread or process object.',CRLF_0
.Obf_Error db 'Obfuscator is not yet initialized.',CRLF_0
.W32_Error db 'Vwin32.vxd has not completed initialization yet.',CRLF_0
.Mem_Error db 'Page #EAX is not committed. Verify command line.',CRLF_0
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
; in:  EAX: thread, EBP: Client registers, ESI: Winice Base
; out: clc: ok, stc: error
;------------------------------------------------------------------------------
SuspendResumeThread:        
	pushad
	cmp	eax,0xF0000000		; check if it's ThreadId
	jl	.is_dbase

	xor	eax,[esi+dObfuscator]	; EAX = Thread Database

.is_dbase:
	lea	edx,[esi+.sfClient]	; get fake client regs
	mov	esi,[esi+SuspendResume.Win32ServiceTable]

	cmp	dword [ebp+Client_EAX],SERVICE_SUSPEND
	jz	.suspend

	cmp	dword [ebp+Client_EAX],SERVICE_RESUME                
	jz	.resume

.error:
	stc
	jmp    short .return

.success:
	clc

.return:
	popad
	retn

.suspend:
	cmp	dword [eax+0x1BC],0	; test suspension counter
	jnz	.success		; already suspended?

	test	byte [eax+0x44],0x40	; thread created suspended?
	jnz	.s_update_r3

	test	byte [eax+0x47],0x10
	jnz	.error

	push	eax			; save TDB, EAX will get trashed
	push	dword [eax+0x5C]	; ring0TCB
	lea	esi,[esi+0x1A*8+8]	; [EDI]: Vwin32SuspendThread
	push	dword 0			; fake VM handle
	push	edx			; Client Regs        
	call	[esi]

	cmp	eax,-1
	pop	eax			; restore EAX
	jz	.error

.s_update_r3:
	inc	dword [eax+0x1BC]	; increment suspension counter

	jmp	short .success

.resume:
	cmp	dword [eax+0x1BC],0	; test suspension counter
	jz	.success		; already running?

	test	byte [eax+0x44],0x40	; thread created suspended?
	jnz	.r_update_r3

	test	byte [eax+0x47],0x10
	jnz	.error

	push	eax
	push    dword [eax+0x5C]	; Ring0 Thread handle
	push	dword 0			; fake VM handle
	push	edx			; fake Client Registers     
	lea	esi,[esi+0x1B*8+8]	; [ESI]: Vwin32ResumeThread
	call	[esi]

	cmp	eax,-1			; error?
	pop	eax
	jz	.error

.r_update_r3:
	dec	dword [eax+0x1BC]	; decrement suspension counter

	jmp	short .success

	align 4
.sfClient TIMES 8  dd 'SGER'
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
; this is the actual dumper code that's executed in ring-0.
;-------------------------------------------------------------------------------
Dump:
	mov	esi,[ebp+Client_ESI]	; get pointer to file name
	test	esi,esi			; emulate old PAGEIN?
	jz	.emulate

	mov	eax,R0_OPENCREATFILE
	mov	ebx,0x2012		; read/write|share:deny all|no INT24
;	mov	ecx,0x20		; archive
	movzx	ecx,bh
;	mov	edx,0x12		; replace/open|create
	movzx	edx,bl
	db 0xCD,0x20,0x32,0x00,0x40,0x00; VxDcall IFSMGR.Ring0_FileIO
	jb	.return

	mov	ebx,eax			; store file handle

.emulate:
	mov	esi,[ebp+Client_EDI]	; get start address of block

.loop:
	mov	edi,esi
	shr	edi,12			; get current page number
	mov	eax,edi			; save page number for later use
	inc	edi			; get next page number
	shl	edi,12			; get linear start address of next page
	sub	edi,esi			; get length of block on current page
	mov	ecx,[ebp+Client_ECX]	; get remaining length
	cmp	edi,ecx			; EDI: bytes to dump from current page
	ja	.1

	mov	ecx,edi			; dump from one page at a time

.1
	call	IsPageCommitted
	jz	.skipPage

	mov	al,[esi]		; PAGEIN!

	jecxz	.return			; emulate old PAGEIN?

	mov	eax,R0_WRITEFILE
	push	ebx			; save file handle
	mov	edx,esi
	sub	edx,[ebp+Client_EDI]	; EDX: absolut file pointer
	db 0xCD,0x20,0x32,0x00,0x40,0x00; VxDcall IFSMGR.Ring0_FileIO
	pop	ebx			; restore file handle
	jb	.close

.skipPage:
	jecxz	.return			; emulate old PAGEIN?

	add	esi,ecx
	sub	[ebp+Client_ECX],ecx	; are we done?
	jnz	.loop

.close:
	mov	eax,R0_CLOSEFILE
	db 0xCD,0x20,0x32,0x00,0x40,0x00; VxDcall IFSMGR.Ring0_FileIO

.return:
	popad
	retn			; client will resume execution at an INT3
.end:

;------------------------------------------------------------------------------
; in:  EAX: page number,
; out: ZF set on error, cleared otherwise
; EDI,EDX will be destroyed
; ------------------------------------------------------------------------------
; the following piece of code directly accesses the page tables and directories
; to figure out if a specific page has been committed or not. credits go to
; LiuTaoTao for the short code to calculate the offsets into the tables.
; ------------------------------------------------------------------------------
IsPageCommitted:
	mov	edi,0xFF800000		; linear start address of page tables
	lea	edx,[edi+4*eax]		; EAX: current page number
	shr	edx,12			; EDX: current directory number
	test	byte [edi+4*edx],0x1	; is page directory present?
	jz	.1
	test	byte [edi+4*eax+1],0x2	; is page committed?
.1
	retn

End:
