; Virogen's PE Realinger v0.4, (c)1998 Virogen[NOP]
; http://virogen.cjb.net email:vgen@hotmail.com
; ---------------------------------------------------------------
; 
; This is a simple little utility I whipped up fast to make PEs
; smaller by rebuilding them, changing the file alignment to 200h (if
; it was 1000h) and removing other unnecessary space in the PE. It 
; works on both PE (win32) EXE and DLLs.
;
; Features:
;   -makes PE exe/dlls smaller
;   -removes unnecessary padding from PEs
;   -removes unncesssary padding from object table
;   -stores new corrrect checksum
;   -does not alter date/time or file attributes
; 
; Explanation:
; For whatever reason (I think perhaps for quicker load time), newer
; win32 executables typically have a file alignment of 1000h (4096).
; What this means is that there is a shitload of wasted space in the
; executable. To explain this, consider an object that has a real 
; physical size of 8050h. Since this physical size must be aligned
; on a file alignment boundary, the end physical size of the object
; is 9000h. This is 0FB0h (4016) bytes of wasted disk space for this
; one object. Now if we change the file alignment to 200h (512) then
; the end physical size of the object is only 8200h, wasting only 1B0h
; (423) bytes of disk space. 
; Vgalign also checks for other wasted space in the PE file and removes
; it.
; 
;  
; Updates:
;   v0.01: Initial release
;   v0.02: Now removes unnecessary padding from PEs. Some assemblers and other compilers
;         may insert unallocated bytes at the end of the EXE to put it on the object
;         alignment boundary. This is not necessary. 
;	  Also displays old/new file size and difference. Whoop!
;   v0.03: Removes unnecessary space from object table.
;   v0.4: Sets total size of header correctly if object table size was adjusted.
;	  converted into console application
;	  accepts wildcards as argument (must be in current directory)
;
; latez
; Virogen[NOP]
;
include mywin.inc       

.586p
locals
jumps
.model flat,STDCALL

extrn   ExitProcess:PROC         
extrn   CreateFileA:PROC         
extrn   CloseHandle:PROC         
extrn   ReadFile:PROC            
extrn   WriteFile:PROC           
extrn   SetFilePointer:PROC      
extrn   MapViewOfFile:PROC       
extrn   CreateFileMappingA:PROC  
extrn   UnmapViewOfFile:PROC     
extrn   SetEndOfFile:PROC        
extrn   SetFilePointer:PROC      
extrn   GetFileAttributesA:PROC  
extrn   SetFileAttributesA:PROC  
extrn   GetFileSize:PROC         
extrn   GetTickCount:PROC        
extrn   GetFileSize:PROC         
extrn   GetFileTime:PROC         
extrn   SetFileTime:PROC         
extrn   CheckSumMappedFile:PROC  
extrn   GetCommandLineA:PROC     
extrn	GetStdHandle:PROC
extrn	WriteConsoleA:PROC
extrn	FindFirstFileA:PROC
extrn	FindNextFileA:PROC
extrn	FindClose:PROC
extrn   IsBadReadPtr:PROC        

org 0  
.data                                   ; data object

;
;
; the new alignment of the executable. 200h is the smallest value allowed, do not try
; and align upwards, I haven't added support for that in this code and you'll end up
; over-writing some objects and just fucking your executable all up.
newalign equ 200h
;
;
cr      equ 0dh
lf      equ 0ah
tab     equ 9

caption         db 50 dup(196),cr,lf
		db 'Virogen''s PE Realigner v0.4, (c)1998 Virogen[NOP]',cr,lf
		db 50 dup(196),cr,lf,0
badcmd_txt      db 'Invalid command line!',cr,lf,' Usage: VGALIGN [filename]',cr,lf,0
success_txt     db cr,lf,'Realigned file: ',0	        
nofiles_txt	db cr,lf,'No files found at: ',0
error_txt       db cr,lf,'Error realigning file: ',0
orga_txt	db cr,lf,'Original File Alignment: '
laorg		db 6 dup(0)
newa_txt	db 'New File Alignment: 200h',0
org_txt		db cr,lf,'Original Size: '
lorg		db 13 dup(0)
new_txt		db 'New Size: '
lnew		db 13 dup(0)                
diff_txt        db 'Difference: '
ldiff		db 13 dup(0)
alldone_txt	db cr,lf,cr,lf,'VGAlign complete! The '
tfiles		db 13 dup(0)
alldone_txt2	db 'files decreased a total of '
tdiff		db 13 dup(0)
alldone_txt3	db 'bytes.',cr,lf,0
find_data	WIN32_FIND_DATA <0>
creation        dd 0,0                     ; our file time structures
lastaccess      dd 0,0
lastwrite       dd 0,0
oldchksum       dd 0
orgalign	dd 0
fsize           dd 0
org_fsize	dd 0
new_fsize 	dd 0
map_ptr         dd 0
oldattrib       dd 0                        ; stored file attribs
fnameptr        dd 0                        ; ptr to file name we're inf
ptrpeheader     dd 0
high_size	dd 0
objPsize        dd 0
maphandle       dd 0
handle          dd 0
error           db -1                       ;
hstdo		dd 0
byteswrote	dd 0
ffhandle	dd 0
total_files	dd 0
total_diff	dd 0
nowc		db 0


.code                                   ; code object - change flags to rwx
start:
        call    GetSHandle
        lea	ebx,caption
        call    WriteString
        call    GetCommandLineA                 ; retrieve command line
        or      eax,eax                         
        jz      _exit_bad_cmd_line              ; if none then abort /w msg
        xchg    esi,eax
sl:
        cmp     byte ptr [esi],0                ; if first byte is NULL then something way wrong
        jz      _exit_bad_cmd_line    
        shl     eax,8                           ; rotate 1 byte in eax, for loop.. eax running load
        lodsb           	                ; get next byte in al
        cmp     eax,'lign'       	        ; end of our proggie name?
        jnz     not_eoc
        cmp     byte ptr [esi],'.'
        jnz     esl
not_eoc:    
        cmp     eax,'.exe'                      ; .exe end of our proggie name?
        jz      esl
        cmp     eax,'.EXE'                      ; .EXE end of our proggie name?
        jnz     sl
esl:
        lodsb
        cmp     al,' '
        jz      esl             
        cmp     al,'"'
        jz      esl
        dec     esi
esl2:    
        cmp     byte ptr [esi],0                ; if first char in parameter 1 is NULL then we fuq
        jz      _exit_bad_cmd_line    
                       
        mov	fnameptr,esi
        
        mov	edi,esi
        mov	al,0        
        mov	ecx,0ffh
        cld
        repnz	scasb
        mov	edi,esi
        xchg	ecx,edx
        mov	ecx,0ffh
        sub	ecx,edx
        push	ecx
        mov	edi,esi
        mov	al,'?'
        repnz 	scasb
        jz	got_wcard
        mov	edi,esi
        pop	ecx
        push	ecx
        mov	al,'*'
        repnz	scasb        
        jz	got_wcard        
        pop	ecx
        mov	nowc,1
        jmp	skip_find
        
got_wcard:                
        pop	ecx
               
        
        push    offset find_data
        push	esi
        call	FindFirstFileA
        mov	ffhandle,eax        
        or	eax,eax
        jz	_exit_no_files
        jmp	got_ff
do_fn:
	push	offset find_data
	push	ffhandle
	call	FindNextFileA	        
	or	eax,eax
	jz	_exit_success
got_ff:	                
        lea	esi,find_data.cFileName
skip_find:        
        mov	fnameptr,esi
                        
	mov	error,-1
        call    AlignFile                       ; go align 
        
        cmp     error,-1                        ; error?
        jz      _exit_error                     ; if so go display error message
        
        inc	total_files
        
    	lea     edi,lorg
    	mov     edx,org_fsize
    	call    write_decimal
    	        
        lea     edi,lnew
    	mov     edx,new_fsize
    	call    write_decimal
	
	cmp	orgalign,200h
	jz	was_200h
	mov	dword ptr laorg,'0001'
	mov	laorg+4,'h'
	jmp	orga_set
was_200h:	
	mov	dword ptr laorg,'h002'
orga_set:
        lea     edi,ldiff
    	mov     edx,org_fsize
    	sub     edx,new_fsize
    	add	total_diff,edx
    	call    write_decimal
    		
        lea	ebx,success_txt
        call	WriteString
        mov	ebx,fnameptr
        call	WriteString
	lea	ebx,orga_txt
	call	WriteString
	lea	ebx,newa_txt
	call	WriteString
	lea	ebx,org_txt
	call	WriteString
      	lea	ebx,new_txt
      	call	WriteString
      	lea	ebx,diff_txt
      	call	WriteString
      	                                          
        cmp	nowc,1        
        jnz	do_fn

_exit_success:
	lea	edi,tfiles
	mov	edx,total_files
	call	write_decimal
	lea	edi,tdiff
	mov	edx,total_diff
	call	write_decimal	
	lea	ebx,alldone_txt
	call	WriteString	
	lea	ebx,alldone_txt2
	call	WriteString
	lea	ebx,alldone_txt3
	call	WriteString
	xor 	eax,eax
	jmp	_exit	
_exit_error:
        lea	ebx,error_txt
        call	WriteString
        mov	ebx,fnameptr        
        call	WriteString
	cmp	nowc,1
	jnz	do_fn	
	jmp	_exit_success
 
_exit_no_files:
	lea	ebx,nofiles_txt
	call	WriteString
	mov	ebx,fnameptr
	call	WriteString
	mov	eax,3
	jmp	_exit
_exit_bad_cmd_line: 
	lea	ebx,badcmd_txt
        call	WriteString
        xor     eax,eax           
        inc     eax               

_exit:  
	mov	ebx,ffhandle
	or	ebx,ebx
	jz	no_ffhandle
	push	ebx
	call	FindClose
no_ffhandle:	  
        call    ExitProcess,eax

;-----------------------------------------------
; align file - call with fnameptr set
;
AlignFile proc

        mov     eax,fnameptr
        push    eax                                                               
        call    GetFileAttributesA                  ; get file attributes         
        mov     oldattrib,eax                                                      
                                                                                   
        cmp     eax,-1                               ; if error then maybe shared  
        jnz     not_shared                                                         
        ret                                          ; can't encrypt it            

not_shared:
        push    20h                                 ; +A
        mov     eax,fnameptr
        push    eax
        call    SetFileAttributesA                  ; clear 'da attribs
        
        mov     esi,fnameptr
        call    OpenFile
        call    test_error
        jnc     open_ok
        ret         
open_ok:
        mov     handle,eax                                                          
                                                                                    
        push    offset creation                                                     
        push    offset lastaccess                                                   
        push    offset lastwrite                                                    
        push    eax                                                                 
        call    GetFileTime                           ; grab the file time          
                                                                                    
        xor     ecx,ecx                                ; only map size of file      
        call    create_mapping                        ; create file mapping         
        jc      abort_encrypt                                                       
        mov     ecx,fsize
        or	ecx,ecx					; no file size?
        jz	abort_encrypt
        mov 	org_fsize,ecx
                                               ; eax->mapped file                
        cmp     word ptr [eax],'ZM'                    ; is EXE?                    
        jnz     abort_encrypt                                                       
                                                                                    
        call    GetPEHeader                           ; load esi->PE Header         
                                                                                    
        push    2                                                                   
        push    esi                                    ; test ptr for read acces 
        call    IsBadReadPtr                           ; was ptr any good?       
        or      eax,eax                                                             
        jnz     abort_encrypt                                                       
                                                                                    
        cmp     word ptr [esi],'EP'                    ; PE?                        
        jnz     abort_encrypt                                                       
not_encrypted:                                                                                                     
                                                                                                                                                                                                                                                                                                                                                                                                                            
	mov	eax,[esi+filealign]
	mov	orgalign,eax
	
was_same:
        xor     eax,eax                                                                              
        mov     ax, word ptr [esi+NtHeaderSize]        ; get header size                             
        add     eax,18h                                ; object table is here                        
        add     eax,esi                                                                                      
        	
	push    eax				       ; save ptr to obj table
	xor     edx,edx				  
	mov     ecx,40 
	xor     eax,eax
	mov     ax,[esi+numObj]
	inc     eax
	mul     ecx
	xchg    eax,ebx	
	pop 	eax	
	push    eax
	add     eax,ebx
	mov     ecx,[esi+filealign]
	call    align_fix
	xchg    ebx,eax					; ebx->phy. start of first obj
	pop 	eax
        
        mov 	ecx,ebx
        sub	ecx,map_ptr
        mov 	[esi+sizehdr],ecx			; save new total size of hdr        
        
        mov     ecx,newalign
        mov     [esi+filealign],ecx
                
        xor     ecx,ecx                                                            
        mov     cx,[esi+numObj]                         ; get number of objects           
	mov     edi,ebx					; edi->phy. start of first obj
; edi contains pointer to current writing address of the executable	
otbl_loop:		
	push    eax ecx					
	mov     ecx,edi					; ecx->current obj poff
	sub     ecx,map_ptr				; get real obj poff
	mov     esi,[eax+objpoff]			; esi->original obj p. off
	mov     [eax+objpoff],ecx			; save new physical offset at cur
	mov	ebx,[eax+objvsize]			; get virtual size
	cmp     ebx,[eax+objpsize]			; bigger than physical size?
	jge     skip_align				; if so skip re-aligning this one
	mov     ecx,newalign				; ecx=200h
	push    eax 					; save obj rec ptr
	xchg    eax,ebx					; eax=object virtual size
	call    align_fix				; align that baby
	xchg    eax,ebx					; ebx=object virtual size
	pop 	eax					; restore obj ptr
	jmp     did_align				
skip_align:		
	mov     ebx,[eax+objpsize]			; use psize if vsize>psize
did_align:
	mov     [eax+objpsize],ebx			; save new aligned physical size
	add     esi,map_ptr				; set esi into mapping
	mov     ecx,ebx				 	; ecx=physical size
	rep     movsb					; store object at new|old location
next_obj:
	pop     ecx eax					
	add     eax,40					; onto next object ..whohoo
	loop    otbl_loop	
		
	sub     eax,40					; adjust to last object
	mov     ecx,[eax+objpsize]			; ecx=last object physical size
	add     ecx,[eax+objpoff]			; ecx=total physical size of file
	push    ecx					

	call    unmap
		
	mov     error,0
	
        pop     ecx                                                                      
        mov     new_fsize,ecx
        push    FILE_BEGIN                              ; from file begin                
        push    0                                       ; distance high                  
        push    ecx                                     ; distance low                   
        push    handle                                                                   
        call    SetFilePointer                          ; move file pointer to       
                                                 ;	 real EOF                           
        push    handle                                                                   
        call    SetEndOfFile                             ; set end of file            
go_checksum:
        xor     ecx,ecx
        call    create_mapping
        jc      unmapped
        call    GetPEHeader
        lea     eax,[esi+checksum]
        push    eax                                   ; destination of checksum in hdr
        push    offset oldchksum
        push    fsize                                 ; new file size
        mov     eax,map_ptr
        push    eax
        call    CheckSumMappedFile
        call    unmap
        
        mov     error,0                                ; if we made it here then no error
        jmp     unmapped                                
abort_encrypt:
        call    unmap                                  ;unmap if aborted infection
unmapped:

        push    offset creation                                              
        push    offset lastaccess                                            
        push    offset lastwrite                                             
        push    handle                                                       
        call    SetFileTime                    ; restore orginal file time
                                                                             
        push    handle                                                       
        call    CloseHandle                                                  
        
        mov     eax,oldattrib                          ; get original attribs 
        push    eax 
        mov     eax,fnameptr
        push    eax                    
        call    SetFileAttributesA                    ; restore the original attributes
                
        ret                                 
AlignFile endp

GetPEHeader proc
        mov     esi,[eax+3Ch]                        ; where PE hdr pointer is 
        add     esi,eax                                                        
        mov     ptrpeheader,esi                      ; esi->PE Hdr             
        ret
GetPEHeader endp

; create_mapping - create file mapping of [handle]
; entry: ecx=+adjust mapping size
;
create_mapping proc
        push    ecx                                ; save additional mapping size  
        push    offset high_size                   ; high fsize storage, not needed
        push    handle                             ; file handle                   
        call    GetFileSize                                                           
        call    test_error                                                            
        jnc     good_nc
bad_cm_abort:
        pop	ecx
        jmp	create_abort
good_nc:                                                                  
        mov     fsize,eax                                                             
        or	eax,eax        
        jz	bad_cm_abort
        mov	eax,high_size
        or	eax,eax
        jnz	bad_cm_abort
        
        pop     ecx                     ; restore map size
        
        push    0              ; no map name
        add     eax,ecx
        push    eax            ; low size+vs  
        push    0              ; high size   
        push    PAGE_READWRITE ; read&write  
        push    0                            
        push    handle                       
        call    CreateFileMappingA           
        call    test_error                   
        jc      create_abort
        mov     maphandle,eax
        
        push    0               ; # of bytes, 0= map entire file
        push    0               ; file offset low
        push    0               ; file offset high             
        push    FILE_MAP_WRITE  ; access flags - read&write       
        push    eax             ; handle                          
        call    MapViewOfFile                                     
        call    test_error                                        
        jc      create_abort
        mov     map_ptr,eax

create_abort:
        ret
create_mapping endp


; test_error - test API for an error return
;  entry: eax=API return
;  returns: carry if error
;
test_error proc
        cmp     eax,-1 
        jz      api_err
        or      eax,eax
        jz      api_err
        clc
        ret
api_err:
        stc
        ret
test_error endp

; unmap file - Unmap view of file
; 
unmap proc
  
        push    map_ptr          
        call    UnmapViewOfFile  
        push    maphandle        
        call    CloseHandle      
        ret

unmap endp

; sets eax on alignment of ecx
;
align_fix proc  
        xor     edx,edx                                                                    
        div     ecx                               ; /alignment                                  
        or      edx,edx				  ; if no remainder then no next
        jz      no_adjust
        inc     eax                               ; next alignment                                
no_adjust:        
        mul     ecx                               ; *alignment                             
        ret
align_fix endp     

OpenFile proc
        push    0                                                
        push    20h                          ; attribute normal  
        push    3                          ; 3=open existing file
        push    0                                                
        push    0                                                
        push    0c0000000h                 ; permissions         
        push    esi                                              
        call    CreateFileA                                      
        ret
OpenFile endp

write_decimal proc
	push	edi
	mov	ecx,3
	xor	eax,eax
	rep	stosd
	pop	edi
    	mov 	eax,edx
    	mov 	esi,10
    	xor 	ecx,ecx
nz:
	xor 	edx,edx
    	div 	esi
    	push 	edx
    	inc 	ecx
    	or 	eax,eax
    	jnz 	nz
wdl:
    	pop 	edx
    	add 	dl,'0'
    	mov 	al,dl
    	stosb
    	loop wdl
	ret           
write_decimal endp

GetSHandle proc
        push    -11
        call    GetStdHandle
        mov     [hstdo],eax             
        ret
GetSHandle endp

WriteString proc
        pushad
        mov     edi,ebx
        xor     eax,eax 
        mov     ecx,0fffh
        cld
        repnz scasb                                ; find end of string        
        mov     ecx,edi              
        sub     ecx,ebx
        push    0
        push    offset byteswrote
        push    ecx     
        push    ebx
        push    [hstdo]
        call    WriteConsoleA
        popad
        ret
WriteString endp

end start
ends

