/*------------------------------------------------------------
WDump95.CPP -- Memory Dumper for Windows '95
made in 1998 by The Key "...when cracking is not enough..."
Based on source code of Quine's Softdump.
------------------------------------------------------------*/

#include <windows.h>
#include "resource.h"
#include "ezfont.h"

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM) ;
BOOL	CALLBACK DialogProc(HWND, UINT, WPARAM, LPARAM);
BOOL	CALLBACK AboutProc(HWND, UINT, WPARAM, LPARAM);
BOOL	GenerateAddress(HWND);
BOOL	Dump(HWND);
BOOL	NewFile(HWND);

HINSTANCE hInstance;
HWND	hwnd; //handle of main window

static char szAppName[] = "WDump95" ;
char	szCompletePath[500];
char	szFilename[500];
char	szSize[100];
char	szTempString[1000];
BOOL	bSizeConversion;
DWORD	dwFilenameLen=0;
HFONT	hAddressFont;
HDC		hAddressDC;

HANDLE	hFileMap=0;
HANDLE	hFile=0;
LPVOID	pMappedFile=0;
DWORD	dwSize=0;
DWORD*	lpdwResult=0;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{
	MSG         msg ;
	WNDCLASSEX  wndclass ;

	wndclass.cbSize        = sizeof (wndclass) ;
	wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
	wndclass.lpfnWndProc   = WndProc ;
	wndclass.cbClsExtra    = 0 ;
	wndclass.cbWndExtra    = 0 ;
	wndclass.hInstance     = hInstance ;
	wndclass.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE(IDI_MAINICON)) ;
	wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
	wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
	wndclass.lpszMenuName  = NULL ;
	wndclass.lpszClassName = szAppName ;
	wndclass.hIconSm       = NULL ;	//put the small icon of .hIcon member

	RegisterClassEx (&wndclass) ;

	hwnd = CreateWindow (szAppName,         // window class name
		"WDump95",				 // window caption
		WS_OVERLAPPEDWINDOW,     // window style
		CW_USEDEFAULT,           // initial x position
		CW_USEDEFAULT,           // initial y position
		CW_USEDEFAULT,           // initial x size
		CW_USEDEFAULT,           // initial y size
		NULL,                    // parent window handle
		NULL,                    // window menu handle
		hInstance,               // program instance handle
		NULL) ;		             // creation parameters

	ShowWindow (hwnd, SW_MINIMIZE) ;
	UpdateWindow (hwnd) ;

	while (GetMessage (&msg, NULL, 0, 0))
	{
		TranslateMessage (&msg) ;
		DispatchMessage (&msg) ;
	}
	return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD	i;
	DWORD	dwPathLen;

	switch (iMsg)
	{
	case WM_CREATE :
		hInstance = ((LPCREATESTRUCT) lParam)->hInstance;

		// Prepare path
		dwPathLen = GetModuleFileName( GetModuleHandle(NULL), szCompletePath, 500);
		for ( i=dwPathLen ; (i>0) && (szCompletePath[i] != '\\') ; i-- );
		szCompletePath[i]=0x0;

		PostMessage(hwnd, WM_COMMAND, 0x77777777,0);
		return 0 ;

	case WM_COMMAND :
		if (wParam == 0x77777777)
		{
			DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), hwnd, (DLGPROC) DialogProc);
			DestroyWindow(hwnd);
		}
		return 0 ;

	case WM_DESTROY :
		PostQuitMessage (0) ;
		return 0 ;

	}

	return DefWindowProc (hwnd, iMsg, wParam, lParam) ;
}

BOOL CALLBACK DialogProc (HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
{

	switch (iMsg)
    {

	case WM_INITDIALOG:
		SetClassLong (hDlg, GCL_HICON, (long) LoadIcon (hInstance, MAKEINTRESOURCE(IDI_MAINICON)));
		EnableWindow(GetDlgItem(hDlg, IDC_DUMP), FALSE);
		hAddressDC = GetDC(GetDlgItem(hDlg, IDC_ADDRESS));
		hAddressFont = EzCreateFont (hAddressDC, "MS Sans Serif", 180, 0, 0, TRUE);
		SelectObject (hAddressDC, hAddressFont);
		SendMessage(GetDlgItem(hDlg, IDC_ADDRESS), WM_SETFONT, (WPARAM) hAddressFont, MAKELPARAM(TRUE, 0));
		return FALSE ;
		break;

	case WM_COMMAND :
		switch (LOWORD (wParam))
		{

		case IDCANCEL :
#ifndef _DEBUG
			if ( MessageBox(hDlg, "Are you sure you want to quit WDump95?",szAppName,
				MB_YESNO | MB_ICONQUESTION ) == IDNO ) return 0;
#endif
			
			// If file was not dumped assume user don't need it and therefore delete it.

			if ( IsWindowEnabled(GetDlgItem(hDlg, IDC_DUMP)) )
			{
				UnmapViewOfFile (pMappedFile);
				CloseHandle (hFileMap);
				CloseHandle (hFile);
				DeleteFile (szFilename);
			}
			EndDialog (hDlg, 0) ;
			return TRUE ;
			break;

		case IDC_GENERATE :
			GenerateAddress(hDlg);
			return TRUE ;
			break;

		case IDC_DUMP :
			Dump(hDlg);
			return TRUE ;
			break;

		case IDC_NEW :
			NewFile(hDlg);
			return TRUE ;
			break;

		case IDC_ABOUT :
			DialogBox(hInstance, MAKEINTRESOURCE(IDD_ABOUT), hDlg, (DLGPROC) AboutProc);
			return TRUE ;
			break;

		};

	case WM_DESTROY:
		DeleteObject(hAddressFont);
		return FALSE ;
		break;

	}
		return FALSE ;
}

BOOL	GenerateAddress(HWND hDlg)
{

	BYTE*	i;
	WIN32_FIND_DATA	wfd;

	// Change cursor (pointer) to "wait" state

	SetCursor( LoadCursor(hInstance,MAKEINTRESOURCE(IDC_WAITCUR)) );
	
	// Check if already exist and ask for overwrite authorization

	dwFilenameLen = GetDlgItemText(hDlg, IDC_FILENAME, szFilename, 500);
	if ( (FindFirstFile(szFilename, &wfd))!=INVALID_HANDLE_VALUE )
	{
			if ( MessageBox(hDlg,
			"File already exist.\nDo you want to overwrite it ?",
			szAppName,
			MB_YESNO | MB_ICONEXCLAMATION ) == IDNO )
			{
				return FALSE;
			}
	}

	// Get and check file size

	dwSize = GetDlgItemInt(hDlg, IDC_SIZEFILE, &bSizeConversion, FALSE);
	dwSize = dwSize * (1024) ;
	if ( (dwSize<1) || (dwSize>((1024*1024)*1024) || (bSizeConversion==FALSE) ))
	{
		MessageBox(hDlg,
			"Wrong file size.\nPlease enter a correct value.\nBetween 1 Kb and 1 Gb.",
			szAppName,
			MB_OK | MB_ICONERROR );
		return FALSE;
	}

	// Get and check filename

	dwFilenameLen = GetDlgItemText(hDlg, IDC_FILENAME, szFilename, 500);

	if ( dwFilenameLen<1 )
	{
		MessageBox(hDlg,
			"Wrong filename.\nPlease enter a correct name.",
			szAppName,
			MB_OK | MB_ICONERROR );
		return FALSE;
	}

	// Create and check MemoryMapped file

	hFile = CreateFile ( (LPCTSTR) szFilename, GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_WRITE, 0, CREATE_ALWAYS, 0, 0);

	if (!hFile)
	{
		MessageBox(hDlg,
			"Error while opening file.\nPlease check input data and retry.\n",
			szAppName,
			MB_OK | MB_ICONERROR );
		return FALSE;
	}

	hFileMap = CreateFileMapping ( hFile, NULL, PAGE_READWRITE | SEC_COMMIT, 0, dwSize, NULL);

	if (!hFileMap)
	{
		wsprintf(szTempString, "Unable to create file mapping.\nError Code: %d.\n", GetLastError());
		MessageBox(hDlg,
			szTempString,
			szAppName,
			MB_OK | MB_ICONERROR );
		CloseHandle (hFile);
		return FALSE;
	}

	pMappedFile = MapViewOfFile ( hFileMap, FILE_MAP_WRITE, 0, 0, 0);

	if (!pMappedFile)
	{
		wsprintf(szTempString, "MapViewOfFile failed.\nError code: %d.", GetLastError());
		MessageBox(hDlg,
			szTempString,
			szAppName,
			MB_OK | MB_ICONERROR );
		CloseHandle (hFileMap);
		CloseHandle (hFile);
		return FALSE;
	}

	// Force the pages into memory, and stick in identifier

	i = (BYTE*)pMappedFile;
	for ( ; i<(BYTE*)((DWORD)pMappedFile+dwSize); i++) *i = 0xCC;
	strcpy((char*)pMappedFile, "WDump95 by The Key");

	// Write it to the disk

	FlushViewOfFile(pMappedFile,0);

	// Show Address

	wsprintf(szTempString, "0x%X\0", (DWORD)pMappedFile);
	SetDlgItemText(hDlg, IDC_ADDRESS, szTempString);

	// Disable "Generate Address" button

	EnableWindow(GetDlgItem(hDlg, IDC_GENERATE), FALSE);

	// Enable "Dump" button

	EnableWindow(GetDlgItem(hDlg, IDC_DUMP), TRUE);

	// Show filename and filesize in main window caption

	wsprintf(szTempString, "%s - %ld KB", szFilename, dwSize/1024);
	SetWindowText(hwnd, szTempString);

	// Change cursor (pointer) to normal state

	SetCursor( LoadCursor(NULL, IDC_ARROW));

	return TRUE;
}

BOOL	Dump(HWND hDlg)
{

	if ( !FlushViewOfFile(pMappedFile,0) )
	{
		MessageBox(hDlg,
			"FlushViewOfFile failed.\nCheck to make sure file is ok.\n",
			szAppName,
			MB_OK | MB_ICONERROR );
		UnmapViewOfFile ( pMappedFile);
		CloseHandle ( hFileMap );
		CloseHandle ( hFile );
		return FALSE;
	}

	UnmapViewOfFile ( pMappedFile);
	CloseHandle ( hFileMap );
	CloseHandle ( hFile );
	MessageBox(hDlg,
		"Memory dumped successfully.\nThank you for using WDump95.",
		szAppName,
		MB_OK | MB_ICONINFORMATION );

	// Enable "Generate Address" button

	EnableWindow(GetDlgItem(hDlg, IDC_GENERATE), TRUE);

	// Disable "Dump" button

	EnableWindow(GetDlgItem(hDlg, IDC_DUMP), FALSE);

	// Clear Address viewer

	SetWindowText(GetDlgItem(hDlg, IDC_ADDRESS), "N/A\0");

	return TRUE;
}

BOOL	NewFile(HWND hDlg)
{
	UnmapViewOfFile (pMappedFile);
	CloseHandle (hFileMap);
	CloseHandle (hFile);
	if ( IsWindowEnabled(GetDlgItem(hDlg, IDC_DUMP)) )
	{
		DeleteFile (szFilename);
	}
	EnableWindow(GetDlgItem(hDlg, IDC_GENERATE), TRUE);
	EnableWindow(GetDlgItem(hDlg, IDC_DUMP), FALSE);
	SetWindowText(hwnd, "WDump95");
	SetWindowText(GetDlgItem(hDlg, IDC_ADDRESS), "N/A\0");
	return TRUE;
}

BOOL	CALLBACK AboutProc	(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
{

	static	HWND hName;
	static	HWND hAboutText;
	static	HFONT hFontName;
	static	HDC hDCName;
	static char szAboutText[] = "\r\n"
								"WDump95 v2.10 by THE KEY - \"when cracking is not enough\""
								"\r\n"
								"\r\n"
								"WDump95 is a \"memory dumper\", that "
								"is a cracking tool to save chunks of memory "
								"to a disk file. It creates a memory mapped file, "
								"that is a memory space shared between all processes, "
								"so you can copy data in and then save those on "
								"the disk for further analysis/processing. "
								"File name and file size can be set as you "
								"like. File size can be between 1 Kb and 1 Gb. "
								"\r\n"
								"\r\n"
								"To use this memory dumper simply type a filename, if "
                                "you want you can include a path, and then type the file "
								"size in kilobytes. Then press the \"Generate Address\" "
								"button that will create the memory buffer and "
								"will display the address you can use inside your "
								"debugger. After you did your work in the debugger "
								"you save the buffer to the file through the "
								"\"Dump\" button. If you are not satisfied with the "
								"current filename or file size press \"New\" button "
								"and enter the new values. "
								"\r\n"
								"\r\n"
								"This useful tool was developed by THE KEY. "
								"It is based on source code of Quine's Softdump. "
								"The development of this tool would not be possible "
								"without the help of Quine's source code. "
								"For this reason THE KEY "
								"decided to release the source code of WDump95 letting, "
								"in this way, other crackers/programmers enhance this "
								"program and release it to the public again. All this "
								"to encourage the cracking world to create free, "
								"powerful, cracking tools. "
								"\r\n"
								"\r\n"
								"\r\n"
								"\r\n"
								"\r\n"
								"\t\t        THE KEY "
								"\r\n"
								"\t      ...when cracking is not enough..."
								"\r\n"
								"\r\n"
								"\r\n"
								"\r\n"
								" \0 ";

	static char szGreet[] =		"\r\n"
								"\r\n"
								"\r\n"
								"\r\n"
								"\t\t        THE KEY "
								"\r\n"
								"\t      ...when cracking is not enough..."
								"\r\n"
								"\r\n"
								"\r\n"
								"\r\n"
								" \0 ";
	switch (iMsg)
    {

	case WM_INITDIALOG:
		hAboutText = GetDlgItem(hDlg, IDC_ABOUTTEXT);
		hName = GetDlgItem(hDlg, IDC_ABOUTNAME);
		hDCName = GetDC(hName);
		hFontName = EzCreateFont (hDCName, "MS Sans Serif", 240, 0, EZ_ATTR_BOLD, TRUE);
		SelectObject (hDCName, hFontName);
		SendMessage(hName, WM_SETFONT, (WPARAM) hFontName, MAKELPARAM(TRUE, 0));

		SetWindowText(hAboutText, szAboutText);

		return FALSE ;

	case WM_COMMAND :
		switch (LOWORD (wParam))
		{
		case IDOK :
		case IDCANCEL :
			SetWindowText(hAboutText, szGreet);
			UpdateWindow(hAboutText);
			Sleep(4000);			
			EndDialog(hDlg,0);
			break;
		}

		case WM_DESTROY:
			DeleteObject(hFontName);
			return FALSE ;

	}
	return FALSE ;
}