extrn   GetStdHandle:proc
extrn   WriteConsoleA:proc
extrn   _wsprintfA:proc

.data

STD_INPUT_HANDLE        equ     -10
STD_OUTPUT_HANDLE       equ     -11
STD_ERROR_HANDLE        equ     -12

text_buff       db      500 dup (0)
console_in      dd      ?
console_out     dd      ?
bytes_read      dd      ?

.code

;
  init_console  proc
;
        push    STD_INPUT_HANDLE
        call    GetStdHandle
        or      eax, eax
        je      init_error
        mov     [console_in], eax
        push    STD_OUTPUT_HANDLE
        call    GetStdHandle
        or      eax, eax
        je      init_error
        mov     [console_out], eax
        
        ret
init_error:
        push    0
        call    ExitProcess
endp


;
  write_console proc    text_out:dword, text_len:dword
;
        pusha
        push    0
        push    offset bytes_read       ; number of bytes read
        push    text_len                ; text length
        push    text_out                ; offset of text
        push    console_out             ; handle
        call    WriteConsoleA
        popa
        ret
endp


;
  write_hex2    proc    hex_in:dword, value1:dword, value2:dword
;
        pusha
        push    value2
        push    value1
        push    hex_in
        push    offset text_buff
        call    _wsprintfA
        add     esp, 4*4
        push    eax offset text_buff
        call    write_console
        popa
        ret
endp

;
  write_str_prm proc   text_out:dword, str_disp:dword
;
        pusha
        push    str_disp
        push    text_out
        push    offset text_buff
        call    _wsprintfA
        add     esp, 4*3
        push    eax offset text_buff
        call    write_console
        popa
        ret
endp

;
  write_stat    proc    str_disp:dword, val1:dword, val2:dword, \
                            val3:dword, val4:dword, val5:dword
;
        pusha
        push    val1 val2 val3 val4 val5
        push    str_disp
        push    offset text_buff
        call    _wsprintfA
        add     esp, 4*7
        push    eax offset text_buff
        call    write_console
        popa
        ret
endp

