/*********************************************************************
  Routines for WAV-files
  support for 8, 12 and 16 bit samples (12 bit are treated as 16 bit)

  part of: Hide4PGP by Heinz Repp
  last modified: 05/20/97
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "hide4pgp.h"

static WORD32 filelength, position;

/*********************************************************************
  skipto:    searches from current position for specified subchunk
  parameter: pointer to string with chunk type
  returns:   length, 0L if not found
             file read pointer points behind the chunk length entry
*********************************************************************/
static long skipto (char *subtype)
{ WORD32 length;
  int found;

  while (position < filelength)
  { if (fseek (StegFile, (long) position, SEEK_SET)) break;
    found = next_is (subtype);
    length = getlong (StegFile);
    position += length + 9 & (WORD32) ~1;  /* word aligned */
    if (found)
      return (long) length;
  } /* endwhile */
  return 0L;
} /* skipto subchunk */


/*********************************************************************
  wav_prepare: check WAV file characteristics, optionally output
             specification data
  parameter: none
  returns:   data width flag, TRUE for 16 (or 12) bit, FALSE for 8
*********************************************************************/
int wav_prepare (void)
{ WORD32 sample_fq;
  int bit_p_spl;

  if (! next_is ("IFF") ||
      (filelength = getlong (StegFile),
       ! next_is ("WAVE")))
  { fputs ("Error (WAV): File identification failed.\n", stderr);
    exit (20);
  } else if (verbose)
    fputs ("Microsoft RIFF / subtype WAVE format detected.\n", stderr);
  filelength += 8;
  position = 12;
  if (skipto ("fmt ") == 0L) unexp_EOF ();
  if (getword (StegFile) != 1)
  { fputs ("Error (WAV): Sound data not in PCM format.\n", stderr);
    exit (21);
  } /* endif format */
  if (verbose > 1)
    fprintf (stderr, "No. of channels  : %i\n", getword (StegFile));
  else getword (StegFile);
  sample_fq = getlong (StegFile);
  if (verbose > 1)
    fprintf (stderr, "Sample frequency : %li Hz.\n", (long) sample_fq);
  fseek (StegFile, 6, SEEK_CUR);
  if ((bit_p_spl = getword (StegFile)) == 12 && hiding)
  { fseek (StegFile, -2L, SEEK_CUR);
    putword (bit_p_spl = 16, StegFile);
    if (verbose)
      fputs ("Sample was 12 bit - changed to -> ", stderr);
  } /* endif 12 bit when hiding */
  if (verbose)
    fprintf (stderr, "Sample resolution: %i bit.\n", bit_p_spl);
  switch (bit_p_spl)
  { case 8:
      return FALSE;
    case 16:
      return TRUE;
    default:
      fputs ("Error (WAV): This resolution is not supported.\n", stderr);
      exit (22);
  } /* switch bit_p_spl */
} /* wav_prepare */


/*********************************************************************
  wav_nextblk: advance read pointer to next data block
  parameter: none
  returns:   length of continous data block, 0L if none
*********************************************************************/
long wav_nextblk (void)
{ return skipto ("data");
} /* wav_nextblk */
