DOSSEG
.MODEL	SMALL

.STACK

.DATA

	PUBLIC	SECTOR_OFFSET
;-----------------------------------------------;
; SECTOR_OFFSET is the offset of the half-	;
; sector display into the full sector.	It must ;
; be a multiple of 16, and not greater than 256 ;
;-----------------------------------------------;
SECTOR_OFFSET	DW	0

	PUBLIC	CURRENT_SECTOR_NO, DISK_DRIVE_NO
CURRENT_SECTOR_NO	DW	0		;Initially sector 0
DISK_DRIVE_NO		DB	0		;Initially Drive A:

	PUBLIC	LINES_BEFORE_SECTOR, HEADER_LINE_NO
	PUBLIC	HEADER_PART_1, HEADER_PART_2
;-----------------------------------------------;
; LINES_BEFORE_SECTOR is the number of lines	;
; at the top of the screen before the half-	;
; sector display.				;
;-----------------------------------------------;
LINES_BEFORE_SECTOR	DB	2
HEADER_LINE_NO		DB	0
HEADER_PART_1		DB	'Disk ',0
HEADER_PART_2		DB	'         Sector ',0
	PUBLIC	PROMPT_LINE_NO, EDITOR_PROMPT
PROMPT_LINE_NO		DB	21
EDITOR_PROMPT		DB	'Press function key, or enter'
			DB	' character or hex byte: ',0

.DATA?

	PUBLIC	SECTOR
;-----------------------------------------------;
; The entire sector (up to 8192 bytes) is	;
; stored in this part of memory.		;
;-----------------------------------------------;
SECTOR	DB	8192 DUP (?)

.CODE

	EXTRN	CLEAR_SCREEN:PROC, READ_SECTOR:PROC
	EXTRN	INIT_SEC_DISP:PROC, WRITE_HEADER:PROC
	EXTRN	WRITE_PROMPT_LINE:PROC, DISPATCHER:PROC
	EXTRN	INIT_WRITE_CHAR:PROC
DISK_PATCH	PROC
	MOV	AX,DGROUP		;Put data segment into AX
	MOV	DS,AX			;Set DS to point to data

	CALL	INIT_WRITE_CHAR
	CALL	CLEAR_SCREEN
	CALL	WRITE_HEADER
	CALL	READ_SECTOR
	CALL	INIT_SEC_DISP
	LEA	DX,EDITOR_PROMPT
	CALL	WRITE_PROMPT_LINE
	CALL	DISPATCHER

	MOV	AH,4Ch			;Return to DOS
	INT	21h
DISK_PATCH	ENDP


	END	DISK_PATCH
