.MODEL	MEM_MODEL,C

INCLUDE	sochalib.inc

;-----------------------------------------------------------------------;
; JS -- Copyright (C) 1992 by John Socha				;
;									;
; This file contains a number of procedures that check or set various	;
; things having to do with the hardware.				;
;									;
;	GetDisplayType		Tells you what type of display active	;
;	is_ega (private)	Checks to see if this is EGA adapter	;
;	EgaActive		Checks if EGA is the active card	;
;	GetDisplayRows		Returns number of rows on screen	;
;-----------------------------------------------------------------------;
rom_seg		segment at 40h
	org	4Ah
crt_cols	DW	?		;Number of columns on the screen

	org	87h
ega_info	DB	?		;Info byte for EGA monitor
rom_seg		ends


.CODE


;-----------------------------------------------------------------------;
; This procedure determines whether the display type is a monochrome	;
; or color-graphics card.						;
;									;
; Returns:	AX	0	No display cards			;
;			1	Color card in 40x25 mode		;
;			2	Color card in 80x25 mode		;
;			3	If monochrome card			;
; Destroys:	AH							;
;-----------------------------------------------------------------------;
GetDisplayType	proc	uses cx
	int	11h			;Get equipment flags
	mov	cl,4
	shr	ax,cl			;Right justify display flags
	and	ax,3			;Keep just the display flags
	ret
GetDisplayType	endp


;-----------------------------------------------------------------------;
; This procedure checks to see if the display adapter is an EGA card.	;
; This test if from the IBM Personal Computer Seminar Proceddings	;
; Volume 2, Number 11 from November 1984				;
;									;
; Returns:	ZR	If this is an EGA card				;
; 		NZ	Otherwise					;
;-----------------------------------------------------------------------;
is_ega	proc	private uses ax bx cx si di bp
	mov	ax,1200h		;Make an EGA-specific call
	mov	bl,10h			;For EGA information
	mov	bh,0FFh			;Load BH with invalid info
	mov	cl,0Fh			;Load CL with reserved switch settings
	int	10h			;Make call to EGA ROM BIOS

	cmp	cl,0Ch			;Is switch setting in valid range?
	jae	not_ega			;No, this is not an EGA card
	cmp	bh,1			;Is this a valid flag?
	ja	not_ega			;No, this is not an EGA card
	cmp	bl,3			;Is memory value within range?
	ja	not_ega			;No, this is not an EGA card
	xor	ax,ax			;Set the zero flag for EGA card

done_is_ega:
	ret

not_ega:
	xor	ax,ax
	inc	ax			;Clear the zero flag
	jmp	done_is_ega
is_ega	endp


;-----------------------------------------------------------------------;
; This procedure tests to see if an EGA monitor is the active monitor.	;
;									;
; Returns:	0	EGA card is not the active card			;
;		-1	An EGA or VGA card *is* active			;
;-----------------------------------------------------------------------;
EgaActive	proc	uses es
	call	is_ega			;See if have an EGA card installed
	jnz	ega_not_active		;No, report EGA not active

	mov	ax,rom_seg		;Point to ROM BIOS data area
	mov	es,ax
	test	es:ega_info,8		;Is this card active?
	jnz	ega_not_active		;No
	xor	ax,ax			;Yes, return -1 since EGA card found
	not	ax
	jmp	done_ega_active

ega_not_active:
	xor	ax,ax			;Return 0 for no EGA card active

done_ega_active:
	ret
EgaActive	endp


;-----------------------------------------------------------------------;
; This procedure returns the number of rows on the screen:		;
;									;
; Returns:	AX	25		All non-EGA/VGA displays	;
;		> 25		EGA/VGA displays with more lines	;
;-----------------------------------------------------------------------;
GetDisplayRows	proc uses bx si di bp es
	call	EgaActive		;Return 0 if no EGA card
	or	ax,ax			;Is this an EGA card?
	mov	al,25			;Return 25 for non-EGA displays
	jz	done_get_rows		;No, return 25 lines

	mov	ax,1130h		;Ask for EGA information
	xor	bh,bh			;Return the current information
	int	10h			;DL = Number of rows - 1
	inc	dl			;DL = Number of rows
	mov	al,dl			;Returns result in AX
done_get_rows:
	xor	ah,ah			;Set upper byte to 0
	ret
GetDisplayRows	endp


	end
