; OPENSPAC.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

;
; This subroutine inserts spaces into the file buffer.  On entry, EAX
; contains the number of spaces to be inserted.  On return, CF = 1 if
; there was not enough space in the file buffer.
;
; assumes FS = file buffer selector
public	open_space
extrn	add_push:near
extrn	working:near
extrn	memcopy:near

include	dataseg.inc
extrn	filesiz:dword, buffersiz:dword
extrn	cursor:dword, dirty_bits:byte
@curseg	ends

include	codeseg.inc
open_space	proc	near
	mov	ecx,filesiz	; last character in file
	add	ecx,eax
	cmp	ecx,buffersiz
	ja	short no_room
	mov	filesiz,ecx
	mov	esi,cursor	; source
	sub	ecx,eax
	sub	ecx,esi		; ECX = bytes to move
	mov	edi,esi
	add	edi,eax		; EDI = destination

	push	ds
	mov	bx,fs
	mov	es,bx
	mov	ds,bx
	call	memcopy		; memcopy uses DWORD-aligned DWORD copy
				; for speed
	pop	ds

; mark file changed
	or	dirty_bits,11000000b
	call	add_push	; adjust push offset if nessesary
	ret

;
; ECX = minimum bytes required
;
no_room:
	call	working
	pushad
	add	ecx,1023	; round up to nearest k
	and	ecx,(not 1023)	; bytes requested
	mov	bx,fs		; selector
	push	ecx
	sys	ResMem32
	pop	ecx
	jc	short no0
	mov	buffersiz,ecx	; new buffer size
no0:
	popad
	jnc	open_space
	ret

open_space	endp

@curseg	ends
	end
