; SCRNROWS.ASM for E32 - Copyright (C) 1994 - 1996 Douglas Herr
;  all rights reserved

; change screen rows on EGA, VGA or RamFont monitors

; 01/18/1996 DH: changed PICKSTR calls to PICKSTRING

include	model.inc

public	screen_rows
extrn	locate:near
extrn	get_screen_data:near

extrn	cursoroff:near
extrn	crtinfo:near, getcrt:near
extrn	pickstring:near, $tpick:near
extrn	set_screen_dimensions:near
extrn	htext:near, hram8043:near, hram9025:near, hram9043:near
extrn	hram8029:near, hram9029:near
extrn	svga132:near

include	dataseg.inc
extrn	columns:byte, rows:word
extrn	cursor:dword, cur_posn:word

ega	db '12 rows',0
herc	db '25 rows',0
	db '29 rows',0
	db '43 rows',0
	db 0
vga	db '14 rows',0
	db '25 rows',0
	db '32 rows',0
	db '50 rows',0
	db 0
vga132	db '25 rows',0
	db '30 rows',0
	db '43 rows',0
	db '50 rows',0
	db '60 rows',0
	db 0

rowdata		dw 12
		dw 25
		dw 29
		dw 43

herc_dispatch	dd hram9025
		dd hram9029
		dd hram9043
		dd htext
		dd hram8029
		dd hram8043
@curseg	ends

include	codeseg.inc
screen_rows	proc	near
	call	cursoroff
	call	getcrt
	mov	dx,0707h	; row 10, column 10
	xor	ebx,ebx		; default:first selection

	cmp	al,0FFh		; CGA?
	je	exit
s0:	cmp	al,128
	ja	short is_herc
	cmp	al,1
	je	short is_ega
	cmp	al,3
	je	short is_vga
	cmp	ax,0100h
	je	short is_ega
	cmp	ax,0300h
	je	short is_vga
	jmp	exit

is_ega:
	lea	esi,ega
	jmp	short v0
is_vga:
	lea	esi,vga
v0:	cmp	columns,100
	ja	short is_svga
	mov	eax,offset @curseg:$tpick
	call	pickstring
	cmp	al,27
	je	short exit
	mov	ax,rowdata[ebx*2]
	mov	bl,columns
	call	set_screen_dimensions
	jmp	short get_dim

is_svga:
	lea	esi,vga132
	mov	eax,offset @curseg:$tpick
	call	pickstring
	cmp	al,27
	je	short exit
	mov	eax,ebx
@svga:	call	svga132
	jnc	short get_dim	; continue if no error
	sub	al,1		;  else try next lower resolution
	jc	short exit	;  exit if 25 rows doesn't work
	jmp	@svga		;  try again

is_herc:
	lea	esi,herc
	mov	eax,offset @curseg:$tpick
	call	pickstring
	cmp	al,27
	je	short exit
	cmp	columns,85
	sbb	eax,eax		; AX = 0FFFFh if in 80-column mode
	and	eax,12		; AX = 12 if in 80-column mode
	call	herc_dispatch[eax+ebx*4]

get_dim:
	call	get_screen_data
	mov	dx,cur_posn
	cmp	al,dh		; above bottom of screen?
	ja	short exit	;  yup, skip
	mov	dh,al		;  else move cursor to bottom of screen
	mov	esi,cursor
	call	locate

exit:	clc
	ret
screen_rows	endp

@curseg	ends
	end
