        PAGE    60, 130
;
;--------------------------------------------------------------------
;Sample Driver for ScrewDriver Debugger.
;It is empty device driver, which call debugger while started
;--------------------------------------------------------------------
;
_TEXT   SEGMENT  WORD PUBLIC 'CODE'
_TEXT   ENDS
    ASSUME CS: _TEXT, DS: _TEXT
;
;The driver Request Header structure definition.
reqhdr  STRUC
reqlen  DB      ?
unit    DB      ?
command DB      ?
status  DW      ?
dummy   DB      8 DUP (?)
units   DB      ?
address DD      ?
cmdline DD      ?
reqhdr  ENDS
;
;**************************************
_TEXT      SEGMENT
;**************************************
;
        dd      -1      ;Link to next driver, -1 = end of list
        dw      1010000000000000b       ;Device attributes,
;                                       Character and Non-IBM bits set
        dw      strat   ;Stategy entry point
        dw      intrp   ;Interrupt entry point
        db      'EmptyDrv'  ;Device name
;
preqhdr DD      ?       ;Pointer to the Request Header
_tytle  DB      'Empty Driver',0dh,0ah,'$'
        EVEN
;
;--------------------------------------
;Strategy:
;Called by MS-DOS when ever the driver is accessed.
;On entry:  ES:BX = Address of Request Header
;--------------------------------------
strat   PROC    FAR
;Call ScrewDriver
        int     3h
;Save the address of the request header.
        mov     WORD PTR cs:[preqhdr], bx
        mov     WORD PTR cs:[preqhdr+2], es
        ret
strat   ENDP
        EVEN
;
;--------------------------------------
;Interrupt:
;Called by MS-DOS immediately after Strategy routine
;--------------------------------------
intrp   PROC    FAR
;Save the registers including flags.
        push    ax
        push    bx
        push    cx
        push    dx
        push    ds
        push    es
        push    di
        push    si
        push    bp
        pushf
;Set DS=CS for access to global variables.
        push    cs
        pop     ds
;
        les     di, [preqhdr]           ;ES:DI = Request Header
        mov     bl, es:[di.command]     ;Get Function code in BL
        or      bl, bl                  ;Only Function 00h (Init) is legal
        jz      SHORT init              ;If 0 then goto
        cmp     bl, 16                  ;Else test for "legal" DOS functions
        jle     @F
        mov     ax, 8003h               ;Return "Unknown Command"
        jmp     SHORT exit
@@:     xor     ax, ax          ;Return zero for unsupported functions
        jmp     SHORT exit
init:   call    init_drv
        les     di, [preqhdr]           ;Restore ES:DI = Request Header
exit:   or      ax, 0100h               ;Turn on the "Done" bit
        mov     es:[di.status], ax      ;Store return code
;Restore the registers.
        popf
        pop     bp
        pop     si
        pop     di
        pop     es
        pop     ds
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
intrp   ENDP
;
init_drv        PROC    NEAR
        mov     WORD PTR es:[di][address], OFFSET last_adr
        mov     WORD PTR es:[di][address+2], cs
        mov     dx, offset _tytle
        mov     ah, 9
        int     21h
        xor     ax, ax
        ret
init_drv        ENDP
;
last_adr:
;
;**************************************
_TEXT   ENDS
;**************************************
;
END


