
;
;                           CMOSVIEW
;
;
;    Display the contents of CMOS with documented function 
;    names.  See book for reserved functions, which vary in 
;    function depending on manufacturer.
;
;    (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc


cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:stacka

cmosview  proc  far
        db      'CMOSVIEW v1.00 '
        db      '(c) 1994 Frank van Gilluwe',0

msgE    db      'Diagnostic status byte              '
msgF    db      'Shutdown status byte                '
        db      'Diskette drive types (drive A & B)  '
        db      'Vendor Specific                     '
        db      'Hard disk type                      '
        db      'Vendor Specific                     '
        db      'Equipment byte                      '
        db      'Base memory, low                    '
        db      'Base memory, high                   '
        db      'Extended memory, low                '
        db      'Extended memory, high               '
        db      'Hard disk 0 extended type           '
        db      'Hard disk 1 extended type           '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'CMOS checksum, high (some)          '
        db      'CMOS checksum, low (some)           '
        db      'Extended memory, low                '
        db      'Extended memory, high               '
        db      'Date century byte (MCA-checksum lo) '
        db      'Power on flags (MCA-checksum hi)    '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific                     '
        db      'Vendor Specific (extended)          '


disp_CMOS_head  db      CR, LF
                db      'CMOS RAM MEMORY CONTENTS', CR, LF
                db      CR, LF
                db      '      Loc  Value     Function '
crlf            db      CR, LF, '$'

disp_CMOS_text  db      '       '
disp_CMOS_loc   db             '      '
disp_CMOS_value db                   '      '
disp_CMOS_type  db      'Vendor Specific                     '
                db      CR, LF, '$'


disp_MCA_msg    db      CR, LF
                db      'MCA extended CMOS memory (2 KB)' 
                db      CR, LF, CR, LF
                db      '       loc   0  1  2  3  4  5  6  7'
                db      '   8  9  A  B  C  D  E  F'
                db      CR, LF, '$'

disp_EISA_msg   db      CR, LF
                db      'EISA extended CMOS memory (8 KB)' 
                db      CR, LF, CR, LF
                db      '     bank-loc  0  1  2  3  4  5  6  7'
                db      '   8  9  A  B  C  D  E  F'
                db      CR, LF, '$'

disp_eCMOS_all  db      '       '
disp_eCMOS      db      '                                 '
                db      '                         '
                db      CR, LF, '$'


old_int6_seg dw 0                  ; temp storage for old int 6
old_int6_off dw 0                  ;  vector (bad opcode)
badoff       dw 0                  ; temp return offset if bad offset
                                   ;  interrupt 6 called

;

start:  
        call    display_CMOS       ; display standard CMOS values

        call    sysvalue           ; get system type
        test    al, 40h            ; MCA ?
        jz      check_EISA         ; jump if not

; check if MCA has extended MCA CMOS memory (model 50 does not)

        cli                        ; disable interrupts
        mov     al, 80h
        out     70h, al            ; disable NMI
        IODELAY
        mov     ax, 186h           ; extended CMOS register 186h
        out     74h, al            
        IODELAY
        mov     al, ah
        out     75h, al
        IODELAY
        in      al, 71h            ; get current value
        IODELAY
        mov     ah, al             ; save for restoral later
        not     al
        out     71h, al            ; output inverted value
        IODELAY
        in      al, 71h            ; ignore first read
        IODELAY
        in      al, 71h
        IODELAY
        not     al                 ; al should = ah
        xchg    al, ah
        out     71h, al            ; restore original value
        IODELAY
        push    ax
        xor     al, al             ; zero AL to enable NMI
        out     70h, al            ; turn on NMI
        pop     ax
        sti                        ; enable interrupts
        cmp     al, ah             ; are values the same 
        jne     CMOS_exit          ;  if not, write failed
                                   ; Extended MCA CMOS works!
        OUTMSG  disp_MCA_msg 
        call    disp_MCA_CMOS      ; display extended memory
        jmp     CMOS_exit

check_EISA:
        test    al, 20h            ; EISA ?
        jz      CMOS_exit          ; jump if not
        OUTMSG  disp_EISA_msg   
        call    disp_EISA_CMOS     ; display extended memory

CMOS_exit:
        mov     ah,4Ch
        int     21h                ; exit with al return code

cmosview  endp


;
;    DISPLAY_CMOS
;       display the CMOS RAM memory contents which may be 
;       redirected to a file.
; 
;       Called with:    nothing
;
;       Returns:        CMOS register values sent to std output
;
;       Regs used:      all
;
;       Subs used:      hex, read_CMOS, write_CMOS

display_CMOS    proc    near
        push    cs
        pop     ds
        push    cs
        pop     es

        OUTMSG  disp_CMOS_head     ; output header string 

; first check if CMOS limit is 3Fh or 7Fh.  If the register sets
;   E to 3Fh are identical to 4Eh to 7Fh, only 64 registers are
;   supported, otherwise 128 registers likely supported

        mov     cl, 0Eh            ; start at CMOS location 0E
        mov     ch, 7Fh            ; assume limit for 128 regs
        mov     al, cl

disp_CMOS_size:
        call    read_CMOS          ; get location value in ah
        mov     bh, ah             ; temp save in bh
        add     cl, 40h            ; switch to possible upper set
        call    read_CMOS          ; get location value in ah
        sub     cl, 40h
        cmp     ah, bh             ; are registers the same ?
        jne     disp_CMOS_128      ; if not, 128 regs supported
        inc     cl
        cmp     cl, 3Fh            ; are we done ?
        je      disp_CMOS_size     ; loop if not

        mov     ch, 3Fh            ; set limit for 64 regs
        jmp     disp_CMOS_regs

; the registers fail to compare so it looks like 128 registers,
;   but to be sure, write a value and confirm it is written.

disp_CMOS_128:
        mov     al, 7Fh            ; select very last location
        call    read_CMOS          ; get location value in ah
        mov     bh, al             ; save it for later
        not     ah                 ; invert current value
        mov     bl, ah             ; save for compare
        call    write_CMOS
        call    read_CMOS
        cmp     bl, ah             ; was value written ?
        je      disp_CMOS_skp1     ; jump if so, 128 registers 
        mov     cl, 3Fh            ; limit is 64 regsisters
disp_CMOS_skp1:
        mov     ah, bh
        call    write_CMOS         ; restore original value

; now output the registers, starting at E

disp_CMOS_regs:
        mov     cl, 0Eh            ; start at CMOS location E

disp_CMOS_loop:
        mov     al, cl
        mov     bx, offset disp_CMOS_loc
        call    hex                ; convert loc to ASCII hex
        mov     al, cl
        call    read_CMOS          ; get location value in ah
        mov     al, ah
        mov     bx, offset disp_CMOS_value
        call    hex                ; convert value to ascii hex

        cmp     cl, 40h            ; insert line feed after 3F
        jne     disp_CMOS_skp2
        OUTMSG  crlf
disp_CMOS_skp2:
        cmp     cl, 40h            ; 40h+ are vendor specific
        ja      disp_CMOS_skp3     ;   so reuse text 
        mov     si, offset msgE
        mov     di, offset disp_CMOS_type
        mov     dx, offset msgF - offset msgE
        mov     al, cl
        sub     al, 0Eh
        mul     dl                 ; ax = dl*al
        add     si, ax
        push    cx
        mov     cx, dx
        cld
        rep     movsb              ; transfer type string
        pop     cx
disp_CMOS_skp3:
        OUTMSG  disp_CMOS_text     ; output info line
        inc     cl
        cmp     cl, ch             ; all done ?
        jbe     disp_CMOS_loop

        ret
display_CMOS    endp

                
;
;    DISP_MCA_CMOS
;       display the extended CMOS RAM memory contents on a MCA
;       system.
; 
;       Called with:    nothing
;
;       Returns:        CMOS register values sent to std output
;
;       Regs used:      all
;
;       Subs used:      hex

disp_MCA_CMOS    proc    near
        push    cs
        pop     ds
        push    cs
        pop     es

; output the registers, starting at 0

        mov     cx, 0              ; extended CMOS location 0

d_MCA_loop1:
        mov     bx, offset disp_eCMOS
        mov     al, ch
        call    hex                ; convert reg to ASCII hex
        add     bx, 2
        mov     al, cl
        call    hex                ; convert reg to ASCII hex
        add     bx, 4

d_MCA_loop2:
        mov     al, cl
        cli                        ; disable interrupts
        out     74h, al            ; set low portion of register
        mov     al, ch
        out     75h, al            ; set high portion of register
        IODELAY
        in      al, 76h            ; get port value
        sti                        ; enable interrupts
        call    hex
        add     bx, 3
        inc     cx
        test    cl, 7              ; 8th value in line ?
        jnz     d_MCA_skp1         ; jump if not
        inc     bx
d_MCA_skp1:
        test    cl, 0Fh            ; 16 values output ?
        jnz     d_MCA_loop2
        OUTMSG  disp_eCMOS_all     ; output line of 16 registers
        cmp     cx, 800h           ; all registers output ?
        jb      d_MCA_loop1        ; loop if not

d_MCA_done:
        ret
disp_MCA_CMOS    endp


;
;    DISP_EISA_CMOS
;       display the extended CMOS RAM memory contents on a EISA
;       system.
; 
;       Called with:    nothing
;
;       Returns:        CMOS register values sent to std output
;
;       Regs used:      all
;
;       Subs used:      hex

disp_EISA_CMOS    proc    near
        push    cs
        pop     ds
        push    cs
        pop     es

; output the registers, starting at 0

        mov     cl, 0              ; extended CMOS bank 0
d_EISA_next_bank:                  ;   (1 of 32 banks)
        mov     dx, 800h           ; ports 800 to 8FF
d_EISA_loop1:
        mov     bx, offset disp_eCMOS
        mov     al, cl             ; get bank number
        call    hex                ; convert to ASCII 
        add     bx, 2
        mov     byte ptr [bx], '-' ; separator
        inc     bx
        mov     byte ptr [bx], '8' ; always 800-8FFh
        inc     bx
        mov     al, dl
        call    hex                ; convert reg to ASCII hex
        add     bx, 4

d_EISA_loop2:
        cli                        ; disable interrupts
        push    dx
        mov     dx, 0C00h
        mov     al, cl             ; bank select
        out     dx, al
        pop     dx
        IODELAY
        in      al, dx             ; get register
        sti                        ; enable interrupts
        call    hex
        add     bx, 3
        inc     dx
        test    dl, 7              ; 8th value in line ?
        jnz     d_EISA_skp1        ; jump if not
        inc     bx
d_EISA_skp1:
        test    dl, 0Fh            ; 16 values output ?
        jnz     d_EISA_loop2
        push    dx
        OUTMSG  disp_eCMOS_all     ; output line of 16 registers
        pop     dx
        cmp     dx, 900h           ; 256 registers output ?
        jb      d_EISA_loop1
        OUTMSG  crlf               ; insert a blank line
        inc     cl
        cmp     cl, 32             ; all 32 banks output ?
        jb      d_EISA_next_bank
        ret
disp_EISA_CMOS    endp


;
;   READ_CMOS
;       read the contents of a specific CMOS register
;
;       Call with:      al = CMOS address to read 
;
;       Returns:        ah = Contents of register
;                            NMI enabled, if disabled

read_CMOS       proc    near
        or      al, 80h            ; disable NMI
        cli                        ; disable interrupts
        out     70h, al            ; al= register to read
        IODELAY
        in      al, 71h            ; returns contents of reg
        mov     ah, al
        mov     al, 0
        IODELAY
        out     70h, al            ; enable NMI
        sti                        ; enable interrupts
        ret
read_CMOS       endp


;
;    WRITE_CMOS
;       write to a CMOS register
;
;       Call with:      al = CMOS register to write
;                       ah = Value to write
;
;       Returns:        NMI enabled, if disabled

write_CMOS      proc    near
        cli                        ; disable interrupts
        or      al, 80h            ; disable NMI
        out     70h, al            ; al= register to read
        mov     al, ah
        IODELAY
        out     71h, al            ; write register
        mov     al, 0
        IODELAY
        out     70h, al            ; enable NMI
        sti                        ; enable interrupts
        ret
write_CMOS      endp


;
;    HEX
;       convert the hex number in al into two ascii characters
;       in bx
;
;       Called with:    al = input hex number
;                       bx = ptr where to put ascii
;
;       Regs Used:      al,bx

hex     proc    near
        push    bx
        mov     bl, al
        and     al, 0fh
        add     al, 90h
        daa
        adc     al, 40h
        daa
        mov     bh, al

        mov     al, bl             ; upper nibble
        shr     al, 1
        shr     al, 1
        shr     al, 1
        shr     al, 1
        and     al, 0fh
        add     al, 90h
        daa
        adc     al, 40h
        daa
        mov     bl, al
        mov     ax, bx
        pop     bx
        mov     [bx], ax           ; output ascii bytes
        ret
hex     endp


;
;    SYSTEM TYPE DETECTION SUBROUTINE
;       Determine the type of system the software is running 
;       on.
;
;       Called with:    nothing
;
;       Returns:        al = System type
;                             0 if PC (8088 based)
;                             1 if XT (8088 based)
;                             2 if PC convertible (8088 based)
;                             3 if PC jr (8088 based)
;                             4 other pre-80286 based machine
;                             8 if XT (80286 based)
;                            10h if AT or ISA
;                            20h if EISA 
;                            40h if MCA 
;
;       Regs used:      ax, bx
;                       eax, ebx (386 or later)
;
;       Subs called:    cpuvalue

sysvalue proc    near
        push    cx
        push    dx
        push    es

        call    far ptr cpuvalue   ; get the cpu type in al
        mov     cl, al             ; save cpu number (0 to 5)

; Avoid directly reading BIOS ROM, because a few memory managers 
; like 386MAX alter bytes at the end of the BIOS. 

        push    cx                 ; save cpu number on stack
        mov     ah, 0C0h
        int     15h                ; get BIOS config data es:bx
        pop     cx
        jc      sys_skp1           ; jump if no config support
        mov     dl, es:[bx+2]      ; get model byte
        mov     dh, es:[bx+3]      ; get sub-model byte

        mov     al, 40h            ; assume MCA
        test    byte ptr es:[bx+5], 2  
        jnz     sys_Exit           ; exit if MCA
        jmp     sys_skp2

; we only get hear on older PCs in which a memory manager 
;  can not be run

sys_skp1:                          ; ok, get BIOS model directly 
        mov     ax, 0F000h
        mov     es, ax             ; point into system BIOS
        mov     dx, es:[0FFFEh]    ; get model & sub-model byte

; now use the model and submodel bytes to determine machine

sys_skp2:
        xor     al, al             ; assume PC (al=0)
        cmp     dl, 0FFh
        je      sys_Exit           ; jump if PC     
        inc     al                 ; assume XT (al=1)
        cmp     dl, 0FEh
        je      sys_Exit           ; jump if XT
        cmp     dl, 0FBh
        je      sys_Exit           ; jump if XT
        inc     al                 ; assume PC convertible (al=2)
        cmp     dl, 0F9h
        je      sys_Exit           ; jump if convertible
        inc     al                 ; assume PCjr (al=3)
        cmp     dl, 0FDh
        je      sys_Exit           ; jump if PCjr
        inc     al                 ; assume other pre-286 (al=4)
        cmp     cl, 2              ; cpu pre-286 ?
        jb      sys_Exit           ; jump so
        ja      sys_skp3           ; jump if 386 or above

; possible a 286 XT - use the model and sub-model bytes to 
;  determine

        mov     al, 8              ; assumption for 286XT
        cmp     dx, 02FCh          ; model code for 286XT ?
        je      sys_exit           ; jump if so

; check if EISA system by looking for the "EISA" string at 
;  address F000:FFD9

sys_skp3:
        mov     ax, 0F000h
        mov     es, ax
        mov     al, 10h            ; assume a standard AT/ISA
        cmp     word ptr es:[0FFD9h], 'IE'
        jne     sys_exit           ; jump if not EISA
        cmp     word ptr es:[0FFDBh], 'AS'
        jne     sys_exit           ; jump if not EISA
        mov     al, 20h            ; EISA machine
sys_Exit:
        pop     es
        pop     dx
        pop     cx
        ret
sysvalue endp


;
;    CPU IDENTIFICATION SUBROUTINE
;       Identify the CPU type, from 8088 to the Pentium.  Works 
;       even if the 386 or later CPU is in V86 mode.  Note that
;       interrupts are enabled at exit, even if they were 
;       disabled on entry.  If it is necessary to run this 
;       routine with interrupts disabled, just remove all CLI 
;       and STI instructions, so long as interrupts are 
;       always disabled before running.
;
;       Called with:    nothing
;
;       Returns:        al = CPU type
;                             0 if 8088/8086 or V20/V30
;                             1 if 80186/80188
;                             2 if 80286
;                             3 if 80386
;                             4 if 80486
;                             5 if Pentium
;                       ah =  bit 0 = 0 if CPUID unavailable
;                                     1 if CPUID ok
;                             bit 1 = 0 if not V20/V30
;                                     1 if NEC V20/V30
;
;       Regs used:      ax, bx (all)
;                       eax, ebx (386 or later)
;
;       Subs called:    hook_int6, restore_int6, bad_op_handler

.8086   ; all instructions 8088/8086 unless overridden later

cpuvalue proc    far
        push    cx
        push    dx
        push    ds
        push    es

; 8088/8086 test - Use rotate quirk - All later CPUs mask the CL
;   register with 0Fh, when shifting a byte by cl bits.  This 
;   test loads CL with a large value (20h) and shifts the AX
;   register right.  With the 8088, any bits in AX are shifted 
;   out, and becomes 0.  On all higher level processors, the
;   CL value of 20h is anded with 0Fh, before the shift.  This
;   means the effective number of shifts is 0, so AX is 
;   unaffected.

        mov     cl, 20h            ; load high CL value
        mov     ax, 1              ; load a non-zero value in AX
        shr     ax, cl             ; do the shift
        cmp     ax, 0              ; if zero, then 8088/86
        jne     up186              ; jump if not 8088/86

; V20/V30 test - It is now either a V20/V30 or a 8088.  I'll use
;   another undocumented trick to find out which.  On the 8088,
;   0Fh performs a POP CS.  On the V20/V30, it is the start of
;   a number of multi-byte instructions.  With the byte string
;   0Fh, 14h, C3h the CPU will perform the following:
;               8088/8086               V20/V30
;             pop     cs              set1   bl, cl  
;             adc     al, 0C3h

        xor     al, al             ; clear al and carry flag
        push    cs
        db      0Fh, 14h, 0C3h     ; instructions (see above)
        cmp     al, 0C3h           ; if al is C3h then 8088/8086
        jne     upV20
        mov     ax, 0              ; set 8088/8086 flag
        jmp     uP_Exit

upV20:
        pop     ax                 ; correct for lack of pop cs
        mov     ax, 200h           ; set V20/V30 flag
        jmp     uP_Exit

; 80186/80188 test - Check what is pushed onto the stack with a 
;   PUSH SP instruction.  The 80186 updates the stack pointer 
;   before the value of SP is pushed onto the stack.  With all
;   higher level processors, the current value of SP is pushed
;   onto the stack, and then the stack pointer is updated.
        
up186:  
        mov     bx, sp             ; save the current stack ptr
        push    sp                 ; do test
        pop     ax                 ; get the pushed value
        cmp     ax, bx             ; did SP change ?
        je      up286              ; if not, it's a 286+ 
        mov     ax, 1              ; set 80186 flag
        jmp     uP_Exit

; 80286 test A - We'll look at the top four bits of the EFLAGS 
;   register.  On a 286, these bits are always zero.  Later 
;   CPUs allow these bits to be changed.  During this test, 
;   We'll disable interrupts to ensure interrupts do not change 
;   the flags. 

up286: 
        cli                        ; disable interrupts
        pushf                      ; save the current flags

        pushf                      ; push flags onto stack 
        pop     ax                 ; now pop flags from stack
        or      ax, 0F000h         ; try and set bits 12-15 hi
        push    ax
        popf                       ; set new flags
        pushf
        pop     ax                 ; see if upper bits are 0

        popf                       ; restore flags to original
        sti                        ; enable interrupts
        test    ax, 0F000h         ; were any upper bits 1 ?
        jnz     up386              ; if so, not a 286

; 80286 test B - If the system was in V86 mode, (386 or higher) 
;   the POPF instruction causes a protection fault, and the 
;   protected mode software must emulate the action of POPF. If 
;   the protected mode software screws up, as occurs with a 
;   rarely encountered bug in Windows 3.1 enhanced mode, the 
;   prior test may look like a 286, but it's really a higher 
;   level processor. We'll check if the protected mode bit is 
;   on.  If not, it's guaranteed to be a 286.

.286P                              ; allow a 286 instruction
        smsw    ax                 ; get machine status word
        test    ax, 1              ; in protected mode ?
        jz      is286              ; jump if not (must be 286)

; 80286 test C - It's very likely a 386 or greater, but it is 
;   not guaranteed yet.  There is a small possibility the system 
;   could be in 286 protected mode so we'll do one last test. We 
;   will try out a 386 unique instruction, after vectoring the 
;   bad-opcode interrupt vector (int 6) to ourselves.  

        call    hook_int6          ; do it!
        mov     [badoff], offset upbad_op  ; where to go if bad
.386
        xchg    eax, eax           ; 32 bit nop (bad on 286)
        
        call    restore_int6       ; restore vector
        jmp     up386              ; only gets here if 386 
                                   ;  or greater!

; Interrupt vector 6 (bad opcode) comes here if system is a 
;   80286 (assuming the 286 protected mode interrupt 6 handler 
;   will execute the bad-opcode interrupt). 

upbad_op:
        call    restore_int6
is286:
        mov     ax, 2              ; set 80286 flag
        jmp     uP_Exit

; 80386 test - Bit 18 in EFLAGS is not settable on a 386, but is
;   changeable on the 486 and later CPUs.  Bit 18 is used to 
;   flag alignment faults. During this test, we'll disable 
;   interrupts to ensure no interrupt will change any flags.

.386                               ; allow 386 instructions

up386:
        cli                        ; disable interrupts
        pushfd                     ; push flags to look at
        pop     eax                ; get eflags
        mov     ebx, eax           ; save for later
        xor     eax, 40000h        ; toggle bit 18
        push    eax                                    
        popfd                      ; load modified eflags to CPU
        pushfd                     ; push eflags to look at
        pop     eax                ; get current eflags
        push    ebx                ; push original onto stack
        popfd                      ; restore original flags
        sti                        ; enable interrupts
        xor     eax, ebx           ; check if bit changed 
        jnz     up486              ; changed, so 486 or later
        mov     ax, 3              ; set 80386 flag
        jmp     uP_Exit

; 80486 test - Bit 21 in EFLAGS is not settable on a 486, but is
;   changeable on the Pentium CPU.  If bit 21 is changeable, it 
;   indicates the CPU supports the CPUID instruction.  It's 
;   amazing it's only taken 10 years to implement the CPUID 
;   instruction, which should have been included from the start!  
;   During this test, we'll disable interrupts to ensure no 
;   interrupt will change any flags. 

up486:
        cli                        ; disable interrupts
        pushfd                     ; push flags to look at
        pop     eax                ; get eflags
        mov     ebx, eax           ; save for later
        xor     eax, 200000h       ; toggle bit 21
        push    eax                                    
        popfd                      ; load modified eflags to CPU
        pushfd                     ; push eflags to look at
        pop     eax                ; get current eflags
        push    ebx                ; push original onto stack
        popfd                      ; restore original flags
        sti                        ; enable interrupts
        xor     eax, ebx           ; check if bit changed 
        jnz     upPentium          ; changed, it's a Pentium
        mov     ax, 4              ; set 80486 flag
        jmp     uP_Exit

; Pentium - It's possible the CPUID instruction may appear on 
;   other CPU chips, so run the CPUID instruction to see what 
;   CPU type it indicates.  The CPUID returns a family number 
;   0 to 5 for the processor type.  As of this date, only the 
;   Pentium supports the CPUID instruction and it is assigned 
;   type 5.

upPentium:
        push    ecx                ; CPUID changes eax to edx
        push    edx
        mov     eax, 1             ; get family info function
        CPUID                      ; macro for CPUID instruction
        and     eax, 0F00h         ; find family info
        shr     eax, 8             ; move to al
        mov     ah, 1              ; set flag that CPUID ok
        pop     edx
        pop     ecx
       
up_Exit:
        pop     es
        pop     ds
        pop     dx
        pop     cx
        ret
cpuvalue endp
.8086                              ; return to 8086 instructions


;
;    HOOK INTERRUPT 6
;       Save the old interrupt 6 vector and replace it with  
;       a new vector to the bad_op_handler.  Vectors are handled 
;       directly without using DOS.
;
;       Called with:    nothing
;                      
;       Returns:        vector hooked
;                       old vector stored at
;                         ds:[old_int6_seg]
;                         ds:[old_int6_off]
;
;       Regs used:      none

hook_int6 proc    near
        push    ax
        push    cx
        push    es
        xor     ax, ax
        mov     es, ax
        cli                        ; disable interrupts
        mov     ax, es:[6*4]       ; get offset of int 6
        mov     cx, es:[6*4+2]     ; get segment
        mov     es:[6*4], offset bad_op_handler
        mov     word ptr es:[6*4+2], seg bad_op_handler
        sti                        ; enable interrupts
        mov     [old_int6_seg], cx ; save original vector
        mov     [old_int6_off], ax
        pop     es
        pop     cx
        pop     ax
        ret
hook_int6 endp


;
;    RESTORE INTERRUPT 6
;       Restore the previously saved old interrupt 6 vector.
;       Vectors handled directly without using DOS.
;
;       Called with:    old vector stored at
;                         ds:[old_int6_seg]
;                         ds:[old_int6_off]
;                      
;       Returns:        vector restored
;
;       Regs used:      none

restore_int6 proc    near
        push    ax
        push    cx
        push    dx
        mov     cx, [old_int6_seg] ; get original vector
        mov     dx, [old_int6_off]
        push    es
        xor     ax, ax
        mov     es, ax
        cli                        ; disable interrupts
        mov     es:[6*4], dx       ; restore original int 6
        mov     es:[6*4+2], cx
        sti                        ; enable interrupts
        pop     es
        pop     dx
        pop     cx
        pop     ax
        ret
restore_int6 endp


;
;    BAD OFFSET INTERRUPT HANDLER
;       If a bad opcode occurs (80286 or later) will come here.
;       The saved BADOFF offset is used to goto the routine
;       previously stored in BADOFF.
;
;       In a few cases, it is also used for double faults. A few
;       instructions (RDMSR & WRMSR) can issue a double fault if
;       not supported, so well come here as well.
;
;       Called with:    cs:[badoff] previously set
;
;       Returns:        returns to address stored in badoff


bad_op_handler proc far
        push    ax
        push    bp
        mov     ax, cs:[badoff]
        mov     bp, sp
        mov     ss:[bp+4], ax      ; insert new return offset
        pop     bp
        pop     ax
        iret
bad_op_handler endp


cseg    ends

;================================================== stack ======

stacka  segment para stack

        db      192 dup (0)

stacka  ends

        end     start

