
;
;    I/O DELAY EXAMPLE
;
;
;    Show the use of the IODELAY subroutine.  This example
;    is not real useful, but just shows how it would be used
;    when accessing I/O ports on the same device in quick 
;    succession.
;
;    (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.


cseg    segment para public
        assume  cs:cseg, ds:cseg

        org     100h               ; Assemble into a COM file.

iodelayt  proc  far

start:  
        call    iodelay            ; initialize iodelay 

        ; other user code

        in      al, 40h            ; read timer channel 0
        call    iodelay            ; delay for fast CPU
        mov     ah, al
        in      al, 42h            ; read timer channel 2
                                   ; (same chip as port 40h)
        ; exit
                                   
        mov     ah,4Ch
        int     21h                ; exit with al return code

iodelayt  endp


;
;    I/O DELAY
;       Delay to ensure successive I/O operations to the same 
;       device are not too fast on a fast CPU.  First time 
;       iodelay is called, a 5 mS delay occurs to calibrate
;       the delay loop.
;
;       Called with:    nothing
;
;       Returns:        delay of 1 to 16 uS
;
;       Regs used:      none (flags altered)

iodelay proc    near
        push    cx
        mov     cx, cs:[io_count]
        jcxz    io_init
io_delay_loop:
        loop    io_delay_loop      ; 13 cycles per loop on a 386
        pop     cx
        ret

; first time run, so determine initialization value and save

io_init:
        push    ax
        push    bx
        push    dx
        push    es

        mov     ax, cs
        mov     es, ax
        mov     ax, 8300h          ; set wait interval
        mov     cx, 0
        mov     dx, 5000           ; delay 5 mS, util wait flag
        mov     bx, offset io_flag ;  is set
        int     15h                ; start 5 mS delay
        jc      io_failed_15       ; unimplemented or in progress

; the RTC timer has begun, and will set bit 7 of the wait flag when
; 5 mS elapses.  Meanwhile, the software loop counts down slowly for
; slow systems, and fast for fast systems.  The loop is 30 cycles 
; on a 386 CPU.  Other CPUs will vary slightly from this.

        dec     cx                 ; cx = FFFFh

io_delay_loop2:
        test    cs:[io_flag], 80h  ; flag set after 5 mS
        jnz     io_5ms_done        ; jump if 5 ms complete
        jmp     short $+2
        loop    io_delay_loop2

        mov     ax, 100            ; gets here if > 400 Mhz CPU,
        jmp     io_exit            ;  so use really large number

; cx = countdown from FFFF 

io_5ms_done:
        mov     ax, 0FFFFh
        sub     ax, cx             ; get number of times looped
        mov     bx, 1500           ; adjustment factor
        xor     dx, dx             ; dx zeroed for divde
        div     bx                 ; ax= dx:ax/cx
        cmp     ax, 0
        je      io_1_delay         ; set at least 1 delay
        jmp     io_set             ; ax = delay value

io_failed_15:
        or      ah, ah             ; was int 15 supported or busy?
        jz      io_exit            ; jump if busy, try again later
                                   ; only slow machines fail int 15h
io_1_delay:
        mov     ax, 1              ; mininum delay period
io_set:
        mov     cs:[io_count], ax  ; load delay value
io_exit:
        pop     es
        pop     dx
        pop     bx
        pop     ax
        pop     cx
        ret
iodelay endp

io_count dw     0                  ; 0 = non-intialized count
io_flag  db     0                  ; bit 7=1 at end of 5mS wait

;  end of iodelay subroutine 

cseg    ends
        end     start

