
;
;                            IRQREDIR
;
;    Run IRQ redirection 
;
;    (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc


cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:stacka

irqredir  proc  far


irq_message db  CR, LF
        db      'IRQREDIR TSR Installed'
        db      ' - IRQ 0-7 redirected to interrupts 50-57h'
        db      CR, LF, '$'

start:  
        push    cs
        pop     ds
        OUTMSG  irq_message        ; output info message

        call    irq_redirect
        mov     ah,4Ch
        int     21h                ; exit with al return code
irqredir  endp


;
;    IRQ_REDIRECT
;       Redirect IRQ 0 through 7 to an alternate set of 
;       interrupt vectors. This may boost performance when the 
;       system is in V86 mode if IRQ 5 is used for high 
;       interrupt rates.  See the Warnings section for more 
;       about the conflict between IRQ 5 and interrupt 0Dh.
;
;       Some software such as OS/2, Deskview, DoubleDOS, and the
;       IBM 3270 emulator perform a similar task, usually to get 
;       these functions before any application can.  This is
;       useful when multi-tasking software must appear to share 
;       hardware with software applications that never intended 
;       this!  Do not use this with any of those programs. 
; 
;       Notes: 1) No check is made to see if interrupt 50h to 
;                 57h is in use before the vectors are changed. 
;              2) Any program or TSR that hooks interrupts 8 to 
;                 0Fh after IRQ_redirect is run, will never get 
;                 access to that interrupt! See notes after this 
;                 code for an alternative approach. 
;
;       Regs used:      ax, cx, di, si, ds, es

IRQ_redirect    proc    near
        cli                        ; disable interrupts

                                   ; Program int controller 1
                                   ; ------------------------
        in      al, 21h            ; get current interrupt mask
        mov     ah, al             ; save for later
        IODELAY
        mov     al, 11h            ; Init command 1, cascade & 
        out     20h, al            ;   require 4th init byte
        IODELAY
        mov     al, 50h            ; Init command 2
        out     21h, al            ;   switch IRQ's to int 50h
        IODELAY
        mov     al, 4              ; Init command 3
        out     21h, al            ;   slave controller on IRQ 2
        IODELAY
        mov     al, 1              ; Init command 4, normal EOI
        out     21h, al            ;   non-buffered, 80x86
        IODELAY
        mov     al, ah             ; Operation command 1
        out     21h, al            ;   restore interrupt mask

                                   ; Now copy interrupt vectors
                                   ; --------------------------
        xor     ax, ax
        mov     es, ax             ; set segment registers to 
        mov     ds, ax             ;   point to interrupt table
        mov     cx, 8 * 2          ; number of words to transfer
        mov     si, 8 * 4          ; start at interrupt 8
        mov     di, 50h * 4        ; xfer to interrupt 50-57h
        cld
        rep     movsw              ; transfer interrupt vectors
        sti                        ; enable interrupts
        ret
IRQ_redirect    endp


;
;    INTERRUPT_51h
;       Alternate code - see text in book
;
;       Registers used: all

Interrupt_51h   proc    far

;  << possible code here, for operations prior to anyone else >>

        push    ax
        push    es
        mov     ax, 0 
        mov     es, ax                  ; segment of int table
        mov     ax, es:[9 * 4]          ; current int 9 offset
        mov     cs:[old_int_9_off], ax  ; save
        mov     ax, es:[9 * 4 + 2]      ; current int 9 segment
        mov     cs:[old_int_9_seg], ax  ; save
        pop     es
        pop     ax
        pushf
        call    dword ptr cs:[old_int_9_off] ; call current int9

;  << possible code here, for operations after anyone else >>

        ret     2                  ; get rid of extra flags
Interrupt_51h   endp

old_int_9_off   dw      0          ; temporary int 9 offset
old_int_9_seg   dw      0          ; temporary int 9 segment


cseg    ends


;================================================== stack ======

stacka  segment para stack

        db      192 dup (0)

stacka  ends

        end     start
