
;
;                          TIMEVENT
;
;
;    Program displays any previous event duration, and resets 
;    the timer to time the next event duration.  
;
;    (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc

cseg    segment para public
        assume  cs:cseg, ds:cseg

        org     100h               ; Assemble into a COM file.


timevent proc   far

; first, check if timer has overflowed

start:
        in      al, 61h
        test    al, 20h            ; check Timer 2 output status
        jz      timeskp1           ; jump if not overflowed
        mov     dx, offset ovrflow ; output overflow message
        jmp     timeskp2

; read Timer 2 counter contents

timeskp1:
        mov     al, 80h            ; latch output command
        out     43h, al            ; send command 
        IODELAY
        in      al, 42h            ; get lsb of counter
        IODELAY
        mov     dl, al          
        in      al, 42h            ; get msb of counter
        mov     dh, al             ; dx = counter value
        mov     ax, 0FFFFh         ; starting value
        sub     ax, dx             ; ax = duration count

; multiply the duration count ax by 838 to get microseconds

        mov     bx, 838
        mul     bx                 ; dx:ax = ax * bx
        call    make_decimal       ; convert dx:ax to decimal
        mov     dx, offset event   ; duration message
timeskp2:
        mov     ah, 9
        int     21h                ; display message

; now re-set Timer 2 mode and count for the next duration

        mov     al, 0B0h           ; Timer 2 command, mode 0
        out     43h, al            ; send command
        IODELAY
        mov     al, 0FFh           ; counter value FFFF
        out     42h, al            ; send lsb to counter
        IODELAY
        out     42h, al            ; send msb to counter

        mov     ah, 4Ch
        int     21h                ; DOS terminate
timevent endp


event           db      CR, LF
                db      'Last event duration = '
out_value       db      '           uS   '
                db      '   Counter reset for next event'
                db      CR, LF, '$'

ovrflow         db      CR, LF
                db      'Last event duration exceeded 54,142 uS'
                db      '   Counter reset for next event'
                db      CR, LF, '$'


;
;    MAKE_DECIMAL
;       convert a 32-bit value into a decimal number
;       
;       Called with:    dx:ax = 32-bit value to convert to 
;                               decimal in the form 99,999.999
;
;       Returns:        decimal number inserted at out_value
;
;       Regs used:      ax, bx, cx, dx, di
;
;       Subs called:    hex2ascii, decw

make_decimal proc   near
        mov     cx, 10000
        div     cx                 ; dx:ax/cx = ax, dx remainder
        push    ax                 ; save remainder
        mov     di, offset out_value+5   ; where to put result
        mov     bl, 1              ; no justification
        mov     ax, dx             ; get lower 10,000
        call    decw               ; convert to decimal
        sub     di, 4              ; mov di back
        mov     cl, [di]           ; get char
        pop     ax              
        cmp     ax, 0              ; no higher value ?
        jne     mkdec0             ; jump if ax has value
        cmp     cl, ' '            ; 1,000s ?
        je      mkdec4             ; jump if not (done)
        mov     byte ptr [di], '.'
        dec     di              
        mov     [di], cl           ; put in 1,000's digit
        jmp     mkdec4             ; done
mkdec0:
        cmp     cl, ' '            ; space ?
        jne     mkdec1             ; jump if not (valid)
        mov     cl, '0'            ; covert to zero
mkdec1:
        mov     byte ptr [di], '.'
        dec     di
        mov     [di], cl           ; put in 1,000's digit
        add     di, 2
        cmp     byte ptr [di], ' ' ; space ? (100's digit)
        jne     mkdec2             ; jump if not
        mov     byte ptr [di], '0' ; convert to zero
mkdec2:
        inc     di
        cmp     byte ptr [di], ' ' ; space ?  (10's digit)
        jne     mkdec3             ; jump if not
        mov     byte ptr [di], '0' ; convert to zero
mkdec3:
        mov     di, offset out_value  ; where to put balance
        mov     bl, 1              ; no justification
        call    decw               ; convert ax to dec
        sub     di, 4              ; mov back to comma 
        mov     ax, [di]           ; get 2 char
        cmp     ah, ' '            ; no 1,000,000's ?
        je      mkdec4             ; jump if none (done)
        mov     byte ptr [di+1], ',' 
        dec     di
        mov     [di], ax           ; put millions digits up
mkdec4:
        ret
make_decimal endp


;
;    DECW
;       Convert the hex number in ax into decimal 1 to 5 ascii 
;       characters and insert into [di].  Increment di ptr.  The 
;       leading zeros are suppressed.
;
;       Call with:      ax = input hex number 
;                       di = pointer where to store characters
;                       bl = 0 for left justification 
;                            1 for no justification
;
;       Returns:        word converted to ascii at [di]
;
;       Regs used:      bx
;
;       Subs called:    hex2ascii

decw    proc    near
        push    ax
        push    cx
        push    dx
        cmp     ax, 0              ; check for zero
        jne     decskip0           ; jump if not
        mov     al, 4              ; if justify, make ax = 0
        mul     bl                 ;    no justify, ax = 4
        add     di, ax             ; move pointer
        mov     byte ptr [di], '0' ; put up ascii zero
        jmp     decskip15          ; done !

decskip0:
        xor     cl, cl             ; temp flag, 0=suppression on
        mov     ch, bl             ; save flag (0=left justify)
        xor     dx, dx             ; zero
        mov     bx, 10000
        div     bx                 ; (labelcnt)/10000
        cmp     al, 0              ; 10000's ?
        je      decskip1           ; jump if zero
        inc     cl                 ; no longer zero suppression
        call    hex2ascii          ; convert to ascii
        mov     byte ptr [di], bh  ; put 1000's digit in
        jmp     decskip2
decskip1:
        cmp     ch, 0              ; left justify ?
        je      decskip3           ; jump if so
decskip2:
        inc     di
decskip3:
        mov     ax, dx             ; get remainder
        xor     dx, dx             ; zero
        mov     bx, 1000
        div     bx                 ; (labelcnt)/1000
        cmp     cl, 0              ; zero suppression active ?
        jne     decskip3a          ; jump if not
        cmp     al, 0              ; 1000's ?
        je      decskip4           ; jump if zero
decskip3a:
        inc     cl                 ; no longer zero suppression
        call    hex2ascii          ; convert to ascii
        mov     byte ptr [di], bh  ; put 1000's digit in
        jmp     decskip5
decskip4:
        cmp     ch, 0              ; left justify ?
        je      decskip6           ; jump if so
decskip5:
        inc     di
decskip6:
        mov     ax, dx             ; get remainder
        xor     dx, dx             ; zero
        mov     bx, 100
        div     bx                 ; (remainder in dx)/100
        cmp     cl, 0              ; zero suppression active ?
        jne     decskip7           ; jump if not
        cmp     al, 0              ; zero ?
        je      decskip8           ; suppress zero
decskip7:
        inc     cl                 ; no longer zero suppression
        call    hex2ascii          ; convert to ascii
        mov     byte ptr [di], bh  ; put 100's digit in
        jmp     decskip9
decskip8:
        cmp     ch, 0              ; left justify ?
        je      decskip10          ; jump if so
decskip9:
        inc     di
decskip10:
        mov     ax, dx             ; get remainder
        xor     dx, dx             ; zero
        mov     bx, 10
        div     bx                 ; (remainder in dx)/10
        cmp     cl, 0              ; zero suppression active ?
        jne     decskip11          ; jump if not
        cmp     al, 0              ; zero ?
        je      decskip12          ; suppress zero
decskip11:
        call    hex2ascii          ; convert to ascii
        mov     byte ptr [di], bh  ; put 10's digit in
        jmp     decskip13
decskip12:
        cmp     ch, 0              ; left justify ?
        je      decskip14          ; jump if so
decskip13:
        inc     di
decskip14:
        mov     al, dl             ; get 1's digit (remainder)
        call    hex2ascii          ; convert to ascii
        mov     byte ptr [di], bh  ; put 1's digit in output
decskip15:
        inc     di
        pop     dx
        pop     cx
        pop     ax
        ret
decw    endp


;
;   HEX2ASCII
;       Convert the hex number in al into two ascii characters
;
;       Called with:    al = input hex number
;
;       Returns         bx = converted digits in ascii
;
;       Regs Used:      al, bx

hex2ascii       proc    near
        mov     bl, al
        and     al, 0fh
        add     al, 90h
        daa
        adc     al, 40h
        daa
        mov     bh, al

        mov     al, bl             ; upper nibble
        shr     al, 1
        shr     al, 1
        shr     al, 1
        shr     al, 1
        and     al, 0fh
        add     al, 90h
        daa
        adc     al, 40h
        daa
        mov     bl, al             ; bx has two ascii bytes
        ret
hex2ascii       endp

cseg    ends

        end     start


